/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.TypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;

public interface InstrumentedType
extends TypeDescription {
    public InstrumentedType withField(String var1, TypeDescription var2, int var3);

    public InstrumentedType withMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, List<? extends TypeDescription> var4, int var5);

    public InstrumentedType withInitializer(TypeInitializer var1);

    public TypeInitializer getTypeInitializer();

    public TypeDescription detach();

    public static abstract class AbstractBase
    extends TypeDescription.AbstractTypeDescription
    implements InstrumentedType {
        protected final TypeInitializer typeInitializer;
        protected final List<FieldDescription> fieldDescriptions;
        protected final List<MethodDescription> methodDescriptions;

        protected AbstractBase() {
            this.typeInitializer = TypeInitializer.NoOp.INSTANCE;
            this.fieldDescriptions = Collections.emptyList();
            this.methodDescriptions = Collections.emptyList();
        }

        protected AbstractBase(TypeInitializer typeInitializer, String typeInternalName, List<? extends FieldDescription> fieldDescriptions, List<? extends MethodDescription> methodDescriptions) {
            this.typeInitializer = typeInitializer;
            this.fieldDescriptions = new ArrayList<FieldDescription>(fieldDescriptions.size());
            for (FieldDescription fieldDescription : fieldDescriptions) {
                this.fieldDescriptions.add(new FieldToken(typeInternalName, fieldDescription));
            }
            this.methodDescriptions = new ArrayList<MethodDescription>(methodDescriptions.size());
            for (MethodDescription methodDescription : methodDescriptions) {
                this.methodDescriptions.add(new MethodToken(typeInternalName, methodDescription));
            }
        }

        private static boolean isAssignable(TypeDescription sourceType, TypeDescription targetType) {
            if (sourceType.equals(targetType)) {
                return true;
            }
            TypeDescription targetTypeSuperType = targetType.getSupertype();
            if (targetTypeSuperType != null && targetTypeSuperType.isAssignableTo(sourceType)) {
                return true;
            }
            if (sourceType.isInterface()) {
                for (TypeDescription interfaceType : targetType.getInterfaces()) {
                    if (!interfaceType.isAssignableTo(sourceType)) continue;
                    return true;
                }
            }
            return false;
        }

        private TypeDescription withSubstitutedSelfReference(String instrumentedTypeName, TypeDescription typeDescription) {
            return typeDescription.getInternalName().equals(instrumentedTypeName) ? this : typeDescription;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return false;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            return new Annotation[0];
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return new Annotation[0];
        }

        @Override
        public boolean isInstance(Object object) {
            return this.isAssignableFrom(object.getClass());
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.isAssignableFrom(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(this, typeDescription);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return this.isAssignableTo(new TypeDescription.ForLoadedType(type));
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return AbstractBase.isAssignable(typeDescription, this);
        }

        @Override
        public boolean represents(Class<?> type) {
            return type.getName().equals(this.getName());
        }

        @Override
        public boolean isArray() {
            return false;
        }

        @Override
        public TypeDescription getComponentType() {
            return null;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return null;
        }

        @Override
        public TypeDescription getEnclosingClass() {
            return null;
        }

        @Override
        public String getSimpleName() {
            return this.getName().substring(this.getPackageName().length() + 1, this.getName().length());
        }

        @Override
        public String getCanonicalName() {
            return this.getName();
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.Explicit(this.fieldDescriptions);
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.Explicit(this.methodDescriptions);
        }

        @Override
        public String getPackageName() {
            int packageIndex = this.getName().lastIndexOf(46);
            if (packageIndex == -1) {
                return "";
            }
            return this.getName().substring(0, packageIndex);
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.SINGLE;
        }

        @Override
        public String getDescriptor() {
            return "L" + this.getInternalName() + ";";
        }

        @Override
        public TypeDescription getDeclaringType() {
            return null;
        }

        @Override
        public TypeInitializer getTypeInitializer() {
            return this.typeInitializer;
        }

        protected class MethodToken
        extends MethodDescription.AbstractMethodDescription {
            private final String internalName;
            private final TypeDescription returnType;
            private final List<TypeDescription> parameterTypes;
            private final List<TypeDescription> exceptionTypes;
            private final int modifiers;

            public MethodToken(String internalName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                this.internalName = internalName;
                this.returnType = returnType;
                this.parameterTypes = new ArrayList<TypeDescription>(parameterTypes);
                this.exceptionTypes = new ArrayList<TypeDescription>(exceptionTypes);
                this.modifiers = modifiers;
            }

            private MethodToken(String typeInternalName, MethodDescription methodDescription) {
                this.internalName = methodDescription.getInternalName();
                this.returnType = AbstractBase.this.withSubstitutedSelfReference(typeInternalName, methodDescription.getReturnType());
                this.parameterTypes = new ArrayList<TypeDescription>(methodDescription.getParameterTypes().size());
                for (TypeDescription typeDescription : methodDescription.getParameterTypes()) {
                    this.parameterTypes.add(AbstractBase.this.withSubstitutedSelfReference(typeInternalName, typeDescription));
                }
                this.exceptionTypes = new ArrayList<TypeDescription>(methodDescription.getExceptionTypes().size());
                for (TypeDescription typeDescription : methodDescription.getExceptionTypes()) {
                    this.exceptionTypes.add(AbstractBase.this.withSubstitutedSelfReference(typeInternalName, typeDescription));
                }
                this.modifiers = methodDescription.getModifiers();
            }

            @Override
            public TypeDescription getReturnType() {
                return this.returnType;
            }

            @Override
            public TypeList getParameterTypes() {
                return new TypeList.Explicit(this.parameterTypes);
            }

            @Override
            public Annotation[][] getParameterAnnotations() {
                return new Annotation[0][0];
            }

            @Override
            public TypeList getExceptionTypes() {
                return new TypeList.Explicit(this.exceptionTypes);
            }

            @Override
            public boolean isConstructor() {
                return "<init>".equals(this.internalName);
            }

            @Override
            public boolean represents(Method method) {
                return false;
            }

            @Override
            public boolean represents(Constructor<?> constructor) {
                return false;
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                return false;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }

            @Override
            public String getName() {
                return this.isConstructor() ? this.getDeclaringType().getName() : this.getInternalName();
            }

            @Override
            public String getInternalName() {
                return this.internalName;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                MethodToken that = (MethodToken)o;
                return this.modifiers == that.modifiers && this.internalName.equals(that.internalName) && this.parameterTypes.equals(that.parameterTypes) && this.returnType.equals(that.returnType);
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + this.internalName.hashCode();
                result = 31 * result + this.returnType.hashCode();
                result = 31 * result + this.parameterTypes.hashCode();
                result = 31 * result + this.modifiers;
                return result;
            }

            public String toString() {
                return "InstrumentedType.MethodToken{internalName='" + this.internalName + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + ", modifiers=" + this.modifiers + '}';
            }
        }

        protected class FieldToken
        extends FieldDescription.AbstractFieldDescription {
            private final String name;
            private final TypeDescription fieldType;
            private final int modifiers;

            public FieldToken(String name, TypeDescription fieldType, int modifiers) {
                this.name = name;
                this.fieldType = fieldType;
                this.modifiers = modifiers;
            }

            private FieldToken(String typeInternalName, FieldDescription fieldDescription) {
                this.name = fieldDescription.getName();
                this.fieldType = AbstractBase.this.withSubstitutedSelfReference(typeInternalName, fieldDescription.getFieldType());
                this.modifiers = fieldDescription.getModifiers();
            }

            @Override
            public TypeDescription getFieldType() {
                return this.fieldType;
            }

            @Override
            public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
                return false;
            }

            @Override
            public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
                return null;
            }

            @Override
            public Annotation[] getAnnotations() {
                return new Annotation[0];
            }

            @Override
            public Annotation[] getDeclaredAnnotations() {
                return new Annotation[0];
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.fieldType.getDescriptor();
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                if (!super.equals(o)) {
                    return false;
                }
                FieldToken that = (FieldToken)o;
                return this.modifiers == that.modifiers && this.fieldType.equals(that.fieldType) && this.name.equals(that.name);
            }

            @Override
            public int hashCode() {
                int result = super.hashCode();
                result = 31 * result + this.name.hashCode();
                result = 31 * result + this.fieldType.hashCode();
                result = 31 * result + this.modifiers;
                return result;
            }

            public String toString() {
                return "InstrumentedType.FieldToken{name='" + this.name + '\'' + ", fieldType=" + this.fieldType + ", modifiers=" + this.modifiers + '}';
            }
        }
    }
}

