/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.bytebuddy.instrumentation.ByteCodeElement;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.matcher.JunctionMethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.DeclaredInType;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.Type;

public interface TypeDescription
extends ByteCodeElement,
DeclaredInType,
ModifierReviewable,
AnnotatedElement {
    public boolean isInstance(Object var1);

    public boolean isAssignableFrom(Class<?> var1);

    public boolean isAssignableFrom(TypeDescription var1);

    public boolean isAssignableTo(Class<?> var1);

    public boolean isAssignableTo(TypeDescription var1);

    public boolean represents(Class<?> var1);

    public boolean isArray();

    public TypeDescription getComponentType();

    public boolean isPrimitive();

    public TypeDescription getSupertype();

    public TypeList getInterfaces();

    public MethodDescription getEnclosingMethod();

    public TypeDescription getEnclosingClass();

    public String getSimpleName();

    public String getCanonicalName();

    public boolean isAnonymousClass();

    public boolean isLocalClass();

    public boolean isMemberClass();

    public FieldList getDeclaredFields();

    public MethodList getDeclaredMethods();

    public MethodList getReachableMethods();

    public String getPackageName();

    public StackSize getStackSize();

    public static class ForLoadedType
    extends AbstractTypeDescription {
        private final Class<?> type;

        public ForLoadedType(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean isInstance(Object object) {
            return this.type.isInstance(object);
        }

        @Override
        public boolean isAssignableFrom(Class<?> type) {
            return this.type.isAssignableFrom(type);
        }

        @Override
        public boolean isAssignableFrom(TypeDescription typeDescription) {
            return typeDescription.isAssignableTo(this.type);
        }

        @Override
        public boolean isAssignableTo(Class<?> type) {
            return type.isAssignableFrom(this.type);
        }

        @Override
        public boolean isAssignableTo(TypeDescription typeDescription) {
            return typeDescription.isAssignableFrom(this.type);
        }

        @Override
        public boolean represents(Class<?> type) {
            return type == this.type;
        }

        @Override
        public boolean isInterface() {
            return this.type.isInterface();
        }

        @Override
        public boolean isArray() {
            return this.type.isArray();
        }

        @Override
        public TypeDescription getComponentType() {
            return this.type.getComponentType() == null ? null : new ForLoadedType(this.type.getComponentType());
        }

        @Override
        public boolean isPrimitive() {
            return this.type.isPrimitive();
        }

        @Override
        public boolean isAnnotation() {
            return this.type.isAnnotation();
        }

        @Override
        public boolean isSynthetic() {
            return this.type.isSynthetic();
        }

        @Override
        public TypeDescription getSupertype() {
            return this.type.getSuperclass() == null ? null : new ForLoadedType(this.type.getSuperclass());
        }

        @Override
        public TypeList getInterfaces() {
            return new TypeList.ForLoadedType(this.type.getInterfaces());
        }

        @Override
        public TypeDescription getDeclaringType() {
            Class<?> declaringType = this.type.getDeclaringClass();
            return declaringType == null ? null : new ForLoadedType(declaringType);
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            Method enclosingMethod = this.type.getEnclosingMethod();
            Constructor<?> enclosingConstructor = this.type.getEnclosingConstructor();
            if (enclosingMethod != null) {
                return new MethodDescription.ForLoadedMethod(enclosingMethod);
            }
            if (enclosingConstructor != null) {
                return new MethodDescription.ForLoadedConstructor(enclosingConstructor);
            }
            return null;
        }

        @Override
        public TypeDescription getEnclosingClass() {
            Class<?> enclosingType = this.type.getEnclosingClass();
            return enclosingType == null ? null : new ForLoadedType(enclosingType);
        }

        @Override
        public String getSimpleName() {
            return this.type.getSimpleName();
        }

        @Override
        public String getCanonicalName() {
            return this.type.getCanonicalName();
        }

        @Override
        public boolean isAnonymousClass() {
            return this.type.isAnonymousClass();
        }

        @Override
        public boolean isLocalClass() {
            return this.type.isLocalClass();
        }

        @Override
        public boolean isMemberClass() {
            return this.type.isMemberClass();
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.ForLoadedField(this.type.getDeclaredFields());
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.ForLoadedType(this.type);
        }

        @Override
        public String getPackageName() {
            return this.type.getPackage().getName();
        }

        @Override
        public StackSize getStackSize() {
            return StackSize.of(this.type);
        }

        @Override
        public String getName() {
            return this.type.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getDescriptor(this.type);
        }

        @Override
        public int getModifiers() {
            return this.type.getModifiers();
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
            return this.type.getAnnotation(annotationType);
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.type.isAnnotationPresent(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.type.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.type.getDeclaredAnnotations();
        }

        public String toString() {
            return "TypeDescription.ForLoadedType{" + this.type + "}";
        }
    }

    public static abstract class AbstractTypeDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements TypeDescription {
        @Override
        public boolean isInstance(Object object) {
            return this.isAssignableFrom(object.getClass());
        }

        @Override
        public String getInternalName() {
            return this.getName().replace('.', '/');
        }

        @Override
        public MethodList getReachableMethods() {
            ArrayList<MethodDescription> methodDescriptions = new ArrayList<MethodDescription>();
            UniqueSignatureFilter uniqueSignatureFilter = new UniqueSignatureFilter();
            methodDescriptions.addAll(this.getDeclaredMethods().filter(uniqueSignatureFilter));
            JunctionMethodMatcher subclassFilter = MethodMatchers.not(MethodMatchers.isPrivate()).and(MethodMatchers.isMethod()).and(MethodMatchers.not(MethodMatchers.isStatic())).and(MethodMatchers.not(MethodMatchers.isPackagePrivate()).or(MethodMatchers.isVisibleTo(this))).and(uniqueSignatureFilter);
            if (this.getSupertype() != null) {
                methodDescriptions.addAll(this.getSupertype().getReachableMethods().filter(subclassFilter));
            }
            for (TypeDescription anInterface : this.getInterfaces()) {
                methodDescriptions.addAll(anInterface.getReachableMethods().filter(uniqueSignatureFilter));
            }
            return new MethodList.Explicit(methodDescriptions);
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPublic() || typeDescription.getPackageName().equals(this.getPackageName());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof TypeDescription && this.getName().equals(((TypeDescription)other).getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        private static class UniqueSignatureFilter
        implements MethodMatcher {
            private final Set<String> foundSignatures = new HashSet<String>();

            private UniqueSignatureFilter() {
            }

            @Override
            public boolean matches(MethodDescription methodDescription) {
                return this.foundSignatures.add(methodDescription.getUniqueSignature());
            }

            public String toString() {
                return "UniqueSignatureFilter{foundSignatures=" + this.foundSignatures + '}';
            }
        }
    }
}

