/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type.auxiliary;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.ModifierContributor;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.modifier.MemberVisibility;

public class MethodCallProxy
implements AuxiliaryType {
    private static final String FIELD_NAME_PREFIX = "argument";
    private final MethodDescription targetMethod;
    private final Assigner assigner;

    public MethodCallProxy(MethodDescription targetMethod) {
        this(targetMethod, new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE), true));
    }

    public MethodCallProxy(MethodDescription targetMethod, Assigner assigner) {
        this.targetMethod = targetMethod;
        this.assigner = assigner;
    }

    private static LinkedHashMap<String, TypeDescription> extractFields(MethodDescription methodDescription) {
        TypeList parameterTypes = methodDescription.getParameterTypes();
        LinkedHashMap<String, TypeDescription> typeDescriptions = new LinkedHashMap<String, TypeDescription>((methodDescription.isStatic() ? 0 : 1) + parameterTypes.size());
        int currentIndex = 0;
        if (!methodDescription.isStatic()) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), methodDescription.getDeclaringType());
        }
        for (TypeDescription parameterType : parameterTypes) {
            typeDescriptions.put(MethodCallProxy.fieldName(currentIndex++), parameterType);
        }
        return typeDescriptions;
    }

    private static String fieldName(int index) {
        return String.format("%s%d", FIELD_NAME_PREFIX, index);
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        MethodDescription accessorMethod = methodAccessorFactory.requireAccessorMethodFor(this.targetMethod);
        LinkedHashMap<String, TypeDescription> parameterFields = MethodCallProxy.extractFields(accessorMethod);
        DynamicType.Builder builder = new ByteBuddy(classFileVersion).subclass(Object.class, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER.toArray(new ModifierContributor.ForType[DEFAULT_TYPE_MODIFIER.size()])).implement(Runnable.class).intercept(new MethodCall(accessorMethod, this.assigner)).implement(Callable.class).intercept(new MethodCall(accessorMethod, this.assigner)).defineConstructor((List<TypeDescription>)new ArrayList<TypeDescription>(parameterFields.values()), new ModifierContributor.ForMethod[0]).intercept(new ConstructorCall());
        for (Map.Entry<String, TypeDescription> field : parameterFields.entrySet()) {
            builder = builder.defineField(field.getKey(), field.getValue(), MemberVisibility.PRIVATE);
        }
        return builder.make();
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.assigner.equals(((MethodCallProxy)other).assigner) && this.targetMethod.equals(((MethodCallProxy)other).targetMethod);
    }

    public int hashCode() {
        return 31 * this.targetMethod.hashCode() + this.assigner.hashCode();
    }

    public String toString() {
        return "MethodCallProxy{targetMethod=" + this.targetMethod + ", assigner=" + this.assigner + '}';
    }

    private static class ConstructorCall
    implements Instrumentation {
        private ConstructorCall() {
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            return new Appender(instrumentedType);
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass();
        }

        public int hashCode() {
            return 31;
        }

        private class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.forType(instrumentedMethod.getDeclaringType()).loadFromIndex(0);
                FieldList fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index] = new StackManipulation.Compound(thisReference, MethodVariableAccess.forType(fieldDescription.getFieldType()).loadFromIndex(instrumentedMethod.getParameterOffset(index)), FieldAccess.forField(fieldDescription).putter());
                    ++index;
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(thisReference, MethodInvocation.invoke(this.instrumentedType.getSupertype().getDeclaredMethods().filter(MethodMatchers.isConstructor()).getOnly()), new StackManipulation.Compound(fieldLoading), MethodReturn.VOID).apply(methodVisitor, instrumentationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private ConstructorCall getConstructorCall() {
                return ConstructorCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ConstructorCall.this.equals(((Appender)other).getConstructorCall());
            }

            public int hashCode() {
                return this.instrumentedType.hashCode();
            }

            public String toString() {
                return "Appender{constructorCall=" + ConstructorCall.this + ", instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    private static class MethodCall
    implements Instrumentation {
        private final MethodDescription accessorMethod;
        private final Assigner assigner;

        private MethodCall(MethodDescription accessorMethod, Assigner assigner) {
            this.accessorMethod = accessorMethod;
            this.assigner = assigner;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            return new Appender(instrumentedType);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && this.accessorMethod.equals(((MethodCall)o).accessorMethod);
        }

        public int hashCode() {
            return this.accessorMethod.hashCode();
        }

        public String toString() {
            return "MethodCall{accessorMethod=" + this.accessorMethod + '}';
        }

        private class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                StackManipulation thisReference = MethodVariableAccess.forType(this.instrumentedType).loadFromIndex(0);
                FieldList fieldList = this.instrumentedType.getDeclaredFields();
                StackManipulation[] fieldLoading = new StackManipulation[fieldList.size()];
                int index = 0;
                for (FieldDescription fieldDescription : fieldList) {
                    fieldLoading[index++] = new StackManipulation.Compound(thisReference, FieldAccess.forField(fieldDescription).getter());
                }
                StackManipulation.Size stackSize = new StackManipulation.Compound(new StackManipulation.Compound(fieldLoading), MethodInvocation.invoke(MethodCall.this.accessorMethod), MethodCall.this.assigner.assign(MethodCall.this.accessorMethod.getReturnType(), instrumentedMethod.getReturnType(), false), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "Appender{methodCall=" + MethodCall.this + ", instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    public static class AssignableSignatureCall
    implements StackManipulation {
        private final MethodDescription targetMethod;

        public AssignableSignatureCall(MethodDescription targetMethod) {
            this.targetMethod = targetMethod;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription auxiliaryType = instrumentationContext.register(new MethodCallProxy(this.targetMethod));
            return new StackManipulation.Compound(TypeCreation.forType(auxiliaryType), Duplication.SINGLE, MethodVariableAccess.loadThisAndArguments(this.targetMethod), MethodInvocation.invoke(auxiliaryType.getDeclaredMethods().filter(MethodMatchers.isConstructor()).getOnly())).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.targetMethod.equals(((AssignableSignatureCall)other).targetMethod);
        }

        public int hashCode() {
            return this.targetMethod.hashCode();
        }

        public String toString() {
            return "MethodCallProxy.AssignableSignatureCall{targetMethod=" + this.targetMethod + '}';
        }
    }
}

