/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.type.auxiliary;

import java.util.Collections;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.ModifierContributor;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DefaultValue;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.JunctionMethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.modifier.Ownership;

public class TypeProxy
implements AuxiliaryType {
    public static final String REFLECTION_METHOD = "make";
    public static final String INSTANCE_FIELD = "target";
    private final TypeDescription proxiedType;
    private final TypeDescription instrumentedType;
    private final boolean ignoreFinalizer;

    public TypeProxy(TypeDescription proxiedType, TypeDescription instrumentedType, boolean ignoreFinalizer) {
        this.proxiedType = proxiedType;
        this.instrumentedType = instrumentedType;
        this.ignoreFinalizer = ignoreFinalizer;
    }

    @Override
    public DynamicType make(String auxiliaryTypeName, ClassFileVersion classFileVersion, AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
        JunctionMethodMatcher finalizerMatcher = this.ignoreFinalizer ? MethodMatchers.not(MethodMatchers.isFinalizer()) : MethodMatchers.any();
        return new ByteBuddy(classFileVersion).subclass(this.proxiedType, (ConstructorStrategy)ConstructorStrategy.Default.IMITATE_SUPER_TYPE).name(auxiliaryTypeName).modifiers(DEFAULT_TYPE_MODIFIER.toArray(new ModifierContributor.ForType[DEFAULT_TYPE_MODIFIER.size()])).method(finalizerMatcher).intercept(new MethodCall(methodAccessorFactory)).defineMethod(REFLECTION_METHOD, TargetType.DESCRIPTION, Collections.emptyList(), Ownership.STATIC).intercept(new SilentConstruction()).make();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TypeProxy typeProxy = (TypeProxy)other;
        return this.ignoreFinalizer == typeProxy.ignoreFinalizer && this.instrumentedType.equals(typeProxy.instrumentedType) && this.proxiedType.equals(typeProxy.proxiedType);
    }

    public int hashCode() {
        int result = this.proxiedType.hashCode();
        result = 31 * result + this.instrumentedType.hashCode();
        result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
        return result;
    }

    public String toString() {
        return "TypeProxy{proxiedType=" + this.proxiedType + ", instrumentedType=" + this.instrumentedType + ", ignoreFinalizer=" + this.ignoreFinalizer + '}';
    }

    private class SilentConstruction
    implements Instrumentation {
        private SilentConstruction() {
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            return new Appender(instrumentedType);
        }

        private TypeProxy getTypeProxy() {
            return TypeProxy.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && TypeProxy.this.equals(((SilentConstruction)other).getTypeProxy());
        }

        public int hashCode() {
            return TypeProxy.this.hashCode();
        }

        public String toString() {
            return "TypeProxy.SilentConstruction{typeProxy=" + TypeProxy.this + "}";
        }

        private class Appender
        implements ByteCodeAppender {
            public static final String REFLECTION_FACTORY_INTERNAL_NAME = "sun/reflect/ReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_NAME = "getReflectionFactory";
            public static final String GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR = "()Lsun/reflect/ReflectionFactory;";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME = "newConstructorForSerialization";
            public static final String NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR = "(Ljava/lang/Class;Ljava/lang/reflect/Constructor;)Ljava/lang/reflect/Constructor;";
            public static final String JAVA_LANG_OBJECT_DESCRIPTOR = "Ljava/lang/Object;";
            public static final String JAVA_LANG_OBJECT_INTERNAL_NAME = "java/lang/Object";
            public static final String JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME = "java/lang/reflect/Constructor";
            public static final String NEW_INSTANCE_METHOD_NAME = "newInstance";
            public static final String NEW_INSTANCE_METHOD_DESCRIPTOR = "([Ljava/lang/Object;)Ljava/lang/Object;";
            public static final String JAVA_LANG_CLASS_INTERNAL_NAME = "java/lang/Class";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_NAME = "getDeclaredConstructor";
            public static final String GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR = "([Ljava/lang/Class;)Ljava/lang/reflect/Constructor;";
            private final TypeDescription instrumentedType;

            private Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                methodVisitor.visitMethodInsn(184, REFLECTION_FACTORY_INTERNAL_NAME, GET_REFLECTION_FACTORY_METHOD_NAME, GET_REFLECTION_FACTORY_METHOD_DESCRIPTOR);
                methodVisitor.visitLdcInsn(Type.getType(this.instrumentedType.getDescriptor()));
                methodVisitor.visitLdcInsn(Type.getType(JAVA_LANG_OBJECT_DESCRIPTOR));
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_CLASS_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CLASS_INTERNAL_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_NAME, GET_DECLARED_CONSTRUCTOR_METHOD_DESCRIPTOR);
                methodVisitor.visitMethodInsn(182, REFLECTION_FACTORY_INTERNAL_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_NAME, NEW_CONSTRUCTOR_FOR_SERIALIZATION_METHOD_DESCRIPTOR);
                methodVisitor.visitInsn(3);
                methodVisitor.visitTypeInsn(189, JAVA_LANG_OBJECT_INTERNAL_NAME);
                methodVisitor.visitMethodInsn(182, JAVA_LANG_CONSTRUCTOR_INTERNAL_NAME, NEW_INSTANCE_METHOD_NAME, NEW_INSTANCE_METHOD_DESCRIPTOR);
                methodVisitor.visitTypeInsn(192, this.instrumentedType.getInternalName());
                methodVisitor.visitInsn(176);
                return new ByteCodeAppender.Size(4, 0);
            }

            private SilentConstruction getSilentConstruction() {
                return SilentConstruction.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && SilentConstruction.this.equals(((Appender)other).getSilentConstruction());
            }

            public int hashCode() {
                return 31 * SilentConstruction.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "TypeProxy.SilentConstruction.Appender{silentConstruction=" + SilentConstruction.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    private class MethodCall
    implements Instrumentation {
        private final AuxiliaryType.MethodAccessorFactory methodAccessorFactory;

        private MethodCall(AuxiliaryType.MethodAccessorFactory methodAccessorFactory) {
            this.methodAccessorFactory = methodAccessorFactory;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(TypeProxy.INSTANCE_FIELD, TypeProxy.this.instrumentedType, 4096);
        }

        @Override
        public ByteCodeAppender appender(TypeDescription instrumentedType) {
            return new Appender(instrumentedType);
        }

        private TypeProxy getTypeProxy() {
            return TypeProxy.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.methodAccessorFactory.equals(((MethodCall)other).methodAccessorFactory) && TypeProxy.this.equals(((MethodCall)other).getTypeProxy());
        }

        public int hashCode() {
            return 31 * TypeProxy.this.hashCode() + this.methodAccessorFactory.hashCode();
        }

        public String toString() {
            return "TypeProxy.MethodCall{typeProxy=" + TypeProxy.this + "methodAccessorFactory=" + this.methodAccessorFactory + '}';
        }

        private class Appender
        implements ByteCodeAppender {
            private final StackManipulation fieldLoadingInstruction;

            public Appender(TypeDescription instrumentedType) {
                this.fieldLoadingInstruction = FieldAccess.forField(instrumentedType.getDeclaredFields().named(TypeProxy.INSTANCE_FIELD)).getter();
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                MethodDescription proxyMethod = MethodCall.this.methodAccessorFactory.requireAccessorMethodFor(instrumentedMethod);
                StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.forType(TypeProxy.this.instrumentedType).loadFromIndex(0), this.fieldLoadingInstruction, MethodVariableAccess.loadArguments(instrumentedMethod), MethodInvocation.invoke(proxyMethod), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
                return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
            }

            private MethodCall getMethodCall() {
                return MethodCall.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldLoadingInstruction.equals(((Appender)other).fieldLoadingInstruction) && MethodCall.this.equals(((Appender)other).getMethodCall());
            }

            public int hashCode() {
                return 31 * MethodCall.this.hashCode() + this.fieldLoadingInstruction.hashCode();
            }

            public String toString() {
                return "Appender{methodCall=" + MethodCall.this + "fieldLoadingInstruction=" + this.fieldLoadingInstruction + '}';
            }
        }
    }

    public static class ByReflectionFactory
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final TypeDescription instrumentedType;
        private final boolean ignoreFinalizer;

        public ByReflectionFactory(TypeDescription proxiedType, TypeDescription instrumentedType, boolean ignoreFinalizer) {
            this.proxiedType = proxiedType;
            this.instrumentedType = instrumentedType;
            this.ignoreFinalizer = ignoreFinalizer;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription proxyType = instrumentationContext.register(new TypeProxy(this.proxiedType, this.instrumentedType, this.ignoreFinalizer));
            return new StackManipulation.Compound(MethodInvocation.invoke(proxyType.getDeclaredMethods().filter(MethodMatchers.named(TypeProxy.REFLECTION_METHOD).and(MethodMatchers.takesArguments(0))).getOnly()), Duplication.SINGLE, MethodVariableAccess.forType(this.instrumentedType).loadFromIndex(0), FieldAccess.forField(proxyType.getDeclaredFields().named(TypeProxy.INSTANCE_FIELD)).putter()).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ByReflectionFactory that = (ByReflectionFactory)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.instrumentedType.equals(that.instrumentedType) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.instrumentedType.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ByReflectionFactory{proxiedType=" + this.proxiedType + ", instrumentedType=" + this.instrumentedType + ", ignoreFinalizer=" + this.ignoreFinalizer + '}';
        }
    }

    public static class ByConstructor
    implements StackManipulation {
        private final TypeDescription proxiedType;
        private final TypeDescription instrumentedType;
        private final List<TypeDescription> constructorParameters;
        private final boolean ignoreFinalizer;

        public ByConstructor(TypeDescription proxiedType, TypeDescription instrumentedType, List<TypeDescription> constructorParameters, boolean ignoreFinalizer) {
            this.proxiedType = proxiedType;
            this.instrumentedType = instrumentedType;
            this.constructorParameters = constructorParameters;
            this.ignoreFinalizer = ignoreFinalizer;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            TypeDescription proxyType = instrumentationContext.register(new TypeProxy(this.proxiedType, this.instrumentedType, this.ignoreFinalizer));
            StackManipulation[] constructorValue = new StackManipulation[this.constructorParameters.size()];
            int index = 0;
            for (TypeDescription parameterType : this.constructorParameters) {
                constructorValue[index++] = DefaultValue.of(parameterType);
            }
            return new StackManipulation.Compound(TypeCreation.forType(proxyType), Duplication.SINGLE, new StackManipulation.Compound(constructorValue), MethodInvocation.invoke(proxyType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.takesArguments(this.constructorParameters))).getOnly()), Duplication.SINGLE, MethodVariableAccess.forType(this.instrumentedType).loadFromIndex(0), FieldAccess.forField(proxyType.getDeclaredFields().named(TypeProxy.INSTANCE_FIELD)).putter()).apply(methodVisitor, instrumentationContext);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ByConstructor that = (ByConstructor)other;
            return this.ignoreFinalizer == that.ignoreFinalizer && this.constructorParameters.equals(that.constructorParameters) && this.instrumentedType.equals(that.instrumentedType) && this.proxiedType.equals(that.proxiedType);
        }

        public int hashCode() {
            int result = this.proxiedType.hashCode();
            result = 31 * result + this.instrumentedType.hashCode();
            result = 31 * result + this.constructorParameters.hashCode();
            result = 31 * result + (this.ignoreFinalizer ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeProxy.ByConstructor{proxiedType=" + this.proxiedType + ", instrumentedType=" + this.instrumentedType + ", constructorParameters=" + this.constructorParameters + ", ignoreFinalizer=" + this.ignoreFinalizer + '}';
        }
    }
}

