/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import java.util.Collection;
import java.util.Random;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.modifier.SyntheticState;
import net.bytebuddy.modifier.TypeManifestation;
import net.bytebuddy.modifier.Visibility;

public interface NamingStrategy {
    public String name(UnnamedType var1);

    public static class Fixed
    implements NamingStrategy {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return this.name;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Fixed)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "NamingStrategy.Fixed{name='" + this.name + '\'' + '}';
        }
    }

    public static class PrefixingRandom
    implements NamingStrategy {
        private final String prefix;
        private final Random random;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.random = new Random();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return String.format("%s.%s$%d", this.prefix, unnamedType.getSuperClass().getName(), Math.abs(this.random.nextInt()));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((PrefixingRandom)other).prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public String toString() {
            return "NamingStrategy.PrefixingRandom{prefix='" + this.prefix + '\'' + ", random=" + this.random + '}';
        }
    }

    public static class SuffixingRandom
    implements NamingStrategy {
        private static final String JAVA_PACKAGE = "java.";
        private static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        private final String suffix;
        private final String javaLangPackagePrefix;
        private final Random random;

        public SuffixingRandom(String suffix) {
            this(suffix, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.random = new Random();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            String superClassName = unnamedType.getSuperClass().getName();
            if (superClassName.startsWith(JAVA_PACKAGE) || unnamedType.getSuperClass().isSealed()) {
                superClassName = this.javaLangPackagePrefix + "." + superClassName;
            }
            return String.format("%s$%s$%d", superClassName, this.suffix, Math.abs(this.random.nextInt()));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SuffixingRandom that = (SuffixingRandom)other;
            return this.javaLangPackagePrefix.equals(that.javaLangPackagePrefix) && this.suffix.equals(that.suffix);
        }

        public int hashCode() {
            int result = this.suffix.hashCode();
            result = 31 * result + this.javaLangPackagePrefix.hashCode();
            return result;
        }

        public String toString() {
            return "NamingStrategy.SuffixingRandom{suffix='" + this.suffix + '\'' + ", javaLangPackagePrefix='" + this.javaLangPackagePrefix + '\'' + ", random=" + this.random + '}';
        }
    }

    public static interface UnnamedType {
        public TypeDescription getSuperClass();

        public Collection<TypeDescription> getDeclaredInterfaces();

        public Visibility getVisibility();

        public TypeManifestation getTypeManifestation();

        public SyntheticState getSyntheticState();

        public ClassFileVersion getClassFileVersion();
    }
}

