/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.dynamic.ClassLoadingStrategy;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.FieldRegistry;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.ModifierContributor;
import net.bytebuddy.instrumentation.TypeInitializer;
import net.bytebuddy.instrumentation.attribute.FieldAttributeAppender;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.attribute.TypeAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface DynamicType {
    public TypeDescription getDescription();

    public byte[] getBytes();

    public Map<TypeDescription, byte[]> getRawAuxiliaryTypes();

    public Map<TypeDescription, TypeInitializer> getTypeInitializers();

    public boolean hasAliveTypeInitializers();

    public Map<TypeDescription, File> saveIn(File var1) throws IOException;

    public static class Default
    implements DynamicType {
        private static final String CLASS_FILE_EXTENSION = ".class";
        protected final TypeDescription typeDescription;
        protected final byte[] binaryRepresentation;
        protected final TypeInitializer typeInitializer;
        protected final List<? extends DynamicType> auxiliaryTypes;

        public Default(TypeDescription typeDescription, byte[] binaryRepresentation, TypeInitializer typeInitializer, List<? extends DynamicType> auxiliaryTypes) {
            this.typeDescription = typeDescription;
            this.binaryRepresentation = binaryRepresentation;
            this.typeInitializer = typeInitializer;
            this.auxiliaryTypes = auxiliaryTypes;
        }

        @Override
        public TypeDescription getDescription() {
            return this.typeDescription;
        }

        @Override
        public Map<TypeDescription, TypeInitializer> getTypeInitializers() {
            HashMap<TypeDescription, TypeInitializer> classLoadingCallbacks = new HashMap<TypeDescription, TypeInitializer>();
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                classLoadingCallbacks.putAll(dynamicType.getTypeInitializers());
            }
            classLoadingCallbacks.put(this.typeDescription, this.typeInitializer);
            return classLoadingCallbacks;
        }

        @Override
        public boolean hasAliveTypeInitializers() {
            for (TypeInitializer typeInitializer : this.getTypeInitializers().values()) {
                if (!typeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] getBytes() {
            return this.binaryRepresentation;
        }

        @Override
        public Map<TypeDescription, byte[]> getRawAuxiliaryTypes() {
            HashMap<TypeDescription, byte[]> auxiliaryTypes = new HashMap<TypeDescription, byte[]>();
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                auxiliaryTypes.put(dynamicType.getDescription(), dynamicType.getBytes());
                auxiliaryTypes.putAll(dynamicType.getRawAuxiliaryTypes());
            }
            return auxiliaryTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, File> saveIn(File folder) throws IOException {
            HashMap<TypeDescription, File> savedFiles = new HashMap<TypeDescription, File>();
            File target = new File(folder, this.typeDescription.getName().replace('.', File.separatorChar) + CLASS_FILE_EXTENSION);
            FileOutputStream fileOutputStream = new FileOutputStream(target);
            try {
                fileOutputStream.write(this.binaryRepresentation);
            }
            finally {
                fileOutputStream.close();
            }
            savedFiles.put(this.typeDescription, target);
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                savedFiles.putAll(dynamicType.saveIn(folder));
            }
            return savedFiles;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.auxiliaryTypes.equals(aDefault.auxiliaryTypes) && Arrays.equals(this.binaryRepresentation, aDefault.binaryRepresentation) && this.typeDescription.equals(aDefault.typeDescription) && this.typeInitializer.equals(aDefault.typeInitializer);
        }

        public int hashCode() {
            int result = this.typeDescription.hashCode();
            result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
            result = 31 * result + this.typeInitializer.hashCode();
            result = 31 * result + this.auxiliaryTypes.hashCode();
            return result;
        }

        public String toString() {
            return "DynamicType.Default{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + ", typeInitializer=" + this.typeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + '}';
        }

        protected static class Loaded<T>
        extends Default
        implements net.bytebuddy.dynamic.DynamicType$Loaded<T> {
            private final Map<TypeDescription, Class<?>> loadedTypes;

            protected Loaded(TypeDescription typeDescription, byte[] typeByte, TypeInitializer typeInitializer, List<? extends DynamicType> auxiliaryTypes, Map<TypeDescription, Class<?>> loadedTypes) {
                super(typeDescription, typeByte, typeInitializer, auxiliaryTypes);
                this.loadedTypes = loadedTypes;
            }

            @Override
            public Class<? extends T> getLoaded() {
                return this.loadedTypes.get(this.typeDescription);
            }

            @Override
            public Map<TypeDescription, Class<?>> getLoadedAuxiliaryTypes() {
                HashMap loadedAuxiliaryTypes = new HashMap(this.loadedTypes);
                loadedAuxiliaryTypes.remove(this.typeDescription);
                return loadedAuxiliaryTypes;
            }

            @Override
            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.loadedTypes.equals(((Loaded)other).loadedTypes);
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + this.loadedTypes.hashCode();
            }

            @Override
            public String toString() {
                return "DynamicType.Default.Loaded{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + ", typeInitializer=" + this.typeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + ", loadedTypes=" + this.loadedTypes + '}';
            }
        }

        public static class Unloaded<T>
        extends Default
        implements net.bytebuddy.dynamic.DynamicType$Unloaded<T> {
            public Unloaded(TypeDescription typeDescription, byte[] typeByte, TypeInitializer typeInitializer, List<? extends DynamicType> auxiliaryTypes) {
                super(typeDescription, typeByte, typeInitializer, auxiliaryTypes);
            }

            @Override
            public net.bytebuddy.dynamic.DynamicType$Loaded<T> load(ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
                LinkedHashMap<TypeDescription, byte[]> types = new LinkedHashMap<TypeDescription, byte[]>(this.getRawAuxiliaryTypes());
                types.put(this.typeDescription, this.binaryRepresentation);
                return new Loaded(this.typeDescription, this.binaryRepresentation, this.typeInitializer, this.auxiliaryTypes, this.initialize(classLoadingStrategy.load(classLoader, types)));
            }

            private Map<TypeDescription, Class<?>> initialize(Map<TypeDescription, Class<?>> uninitialized) {
                Map<TypeDescription, TypeInitializer> typeInitializers = this.getTypeInitializers();
                for (Map.Entry<TypeDescription, Class<?>> entry : uninitialized.entrySet()) {
                    typeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                }
                return new HashMap(uninitialized);
            }

            @Override
            public String toString() {
                return "DynamicType.Default.Unloaded{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + ", typeInitializer=" + this.typeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + '}';
            }
        }
    }

    public static interface Unloaded<T>
    extends DynamicType {
        public Loaded<T> load(ClassLoader var1, ClassLoadingStrategy var2);
    }

    public static interface Loaded<T>
    extends DynamicType {
        public Class<? extends T> getLoaded();

        public Map<TypeDescription, Class<?>> getLoadedAuxiliaryTypes();
    }

    public static interface Builder<T> {
        public Builder<T> classFileVersion(ClassFileVersion var1);

        public OptionalMatchedMethodInterception<T> implement(Class<?> ... var1);

        public OptionalMatchedMethodInterception<T> implement(TypeDescription ... var1);

        public Builder<T> name(String var1);

        public Builder<T> modifiers(ModifierContributor.ForType ... var1);

        public Builder<T> ignoreMethods(MethodMatcher var1);

        public Builder<T> attribute(TypeAttributeAppender var1);

        public Builder<T> annotateType(Annotation ... var1);

        public Builder<T> classVisitor(ClassVisitorWrapper var1);

        public Builder<T> bridgeMethodResolverFactory(BridgeMethodResolver.Factory var1);

        public Builder<T> methodLookupEngine(MethodLookupEngine.Factory var1);

        public FieldValueTarget<T> defineField(String var1, Class<?> var2, ModifierContributor.ForField ... var3);

        public FieldValueTarget<T> defineField(String var1, TypeDescription var2, ModifierContributor.ForField ... var3);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, Class<?> var2, List<Class<?>> var3, ModifierContributor.ForMethod ... var4);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, ModifierContributor.ForMethod ... var4);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(Iterable<Class<?>> var1, ModifierContributor.ForMethod ... var2);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(List<? extends TypeDescription> var1, ModifierContributor.ForMethod ... var2);

        public MatchedMethodInterception<T> method(MethodMatcher var1);

        public MatchedMethodInterception<T> constructor(MethodMatcher var1);

        public MatchedMethodInterception<T> invokable(MethodMatcher var1);

        public Unloaded<T> make();

        public static abstract class AbstractBase<S>
        implements Builder<S> {
            protected final List<FieldToken> fieldTokens;
            protected final List<MethodToken> methodTokens;

            protected AbstractBase(List<FieldToken> fieldTokens, List<MethodToken> methodTokens) {
                this.fieldTokens = fieldTokens;
                this.methodTokens = methodTokens;
            }

            private static TypeDescription considerSubstitution(TypeDescription type, TypeDescription instrumentedType) {
                return type.represents(TargetType.class) ? instrumentedType : type;
            }

            protected InstrumentedType applyRecordedMembersTo(InstrumentedType instrumentedType) {
                for (FieldToken fieldToken : this.fieldTokens) {
                    instrumentedType = instrumentedType.withField(fieldToken.name, fieldToken.resolveFieldType(instrumentedType), fieldToken.modifiers);
                }
                for (MethodToken methodToken : this.methodTokens) {
                    instrumentedType = instrumentedType.withMethod(methodToken.internalName, methodToken.resolveReturnType(instrumentedType), methodToken.resolveParameterTypes(instrumentedType), methodToken.resolveExceptionTypes(), methodToken.modifiers);
                }
                return instrumentedType;
            }

            @Override
            public OptionalMatchedMethodInterception<S> implement(Class<?> ... interfaceType) {
                TypeDescription[] typeDescription = new TypeDescription[interfaceType.length];
                int index = 0;
                for (Class<?> type : interfaceType) {
                    typeDescription[index++] = new TypeDescription.ForLoadedType(type);
                }
                return this.implement(typeDescription);
            }

            @Override
            public FieldValueTarget<S> defineField(String name, Class<?> fieldType, ModifierContributor.ForField ... modifier) {
                return this.defineField(name, new TypeDescription.ForLoadedType(fieldType), modifier);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(String name, Class<?> returnType, List<Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                return this.defineMethod(name, new TypeDescription.ForLoadedType(returnType), new TypeList.ForLoadedType(parameterTypes), modifier);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(Iterable<Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                ArrayList parameterTypesList;
                if (parameterTypes instanceof List) {
                    parameterTypesList = (ArrayList)parameterTypes;
                } else {
                    parameterTypesList = new ArrayList();
                    for (Class<?> parameterType : parameterTypes) {
                        parameterTypesList.add(parameterType);
                    }
                }
                return this.defineConstructor(new TypeList.ForLoadedType(parameterTypesList), modifier);
            }

            protected abstract class AbstractDelegatingBuilder<U>
            implements Builder<U> {
                protected AbstractDelegatingBuilder() {
                }

                @Override
                public Builder<U> classFileVersion(ClassFileVersion classFileVersion) {
                    return this.materialize().classFileVersion(classFileVersion);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(Class<?> ... interfaceType) {
                    return this.materialize().implement(interfaceType);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(TypeDescription ... interfaceType) {
                    return this.materialize().implement(interfaceType);
                }

                @Override
                public Builder<U> name(String name) {
                    return this.materialize().name(name);
                }

                @Override
                public Builder<U> modifiers(ModifierContributor.ForType ... modifier) {
                    return this.materialize().modifiers(modifier);
                }

                @Override
                public Builder<U> ignoreMethods(MethodMatcher ignoredMethods) {
                    return this.materialize().ignoreMethods(ignoredMethods);
                }

                @Override
                public Builder<U> attribute(TypeAttributeAppender attributeAppender) {
                    return this.materialize().attribute(attributeAppender);
                }

                @Override
                public Builder<U> annotateType(Annotation ... annotation) {
                    return this.materialize().annotateType(annotation);
                }

                @Override
                public Builder<U> classVisitor(ClassVisitorWrapper classVisitorWrapper) {
                    return this.materialize().classVisitor(classVisitorWrapper);
                }

                @Override
                public Builder<U> methodLookupEngine(MethodLookupEngine.Factory methodLookupEngineFactory) {
                    return this.materialize().methodLookupEngine(methodLookupEngineFactory);
                }

                @Override
                public Builder<U> bridgeMethodResolverFactory(BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                    return this.materialize().bridgeMethodResolverFactory(bridgeMethodResolverFactory);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, Class<?> fieldType, ModifierContributor.ForField ... modifier) {
                    return this.materialize().defineField(name, fieldType, modifier);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, TypeDescription fieldTypeDescription, ModifierContributor.ForField ... modifier) {
                    return this.materialize().defineField(name, fieldTypeDescription, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, Class<?> returnType, List<Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(Iterable<Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineConstructor(parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineConstructor(parameterTypes, modifier);
                }

                @Override
                public MatchedMethodInterception<U> method(MethodMatcher methodMatcher) {
                    return this.materialize().method(methodMatcher);
                }

                @Override
                public MatchedMethodInterception<U> constructor(MethodMatcher methodMatcher) {
                    return this.materialize().constructor(methodMatcher);
                }

                @Override
                public MatchedMethodInterception<U> invokable(MethodMatcher methodMatcher) {
                    return this.materialize().invokable(methodMatcher);
                }

                @Override
                public Unloaded<U> make() {
                    return this.materialize().make();
                }

                protected abstract Builder<U> materialize();
            }

            protected static class FieldToken
            implements FieldRegistry.LatentFieldMatcher {
                protected final String name;
                protected final TypeDescription fieldType;
                protected final int modifiers;

                public FieldToken(String name, TypeDescription fieldType, int modifiers) {
                    this.name = name;
                    this.fieldType = fieldType;
                    this.modifiers = modifiers;
                }

                protected TypeDescription resolveFieldType(TypeDescription instrumentedType) {
                    return AbstractBase.considerSubstitution(this.fieldType, instrumentedType);
                }

                public String getName() {
                    return this.name;
                }

                public TypeDescription getFieldType() {
                    return this.fieldType;
                }

                public int getModifiers() {
                    return this.modifiers;
                }

                @Override
                public String getFieldName() {
                    return this.name;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((FieldToken)other).name);
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "FieldToken{internalName='" + this.name + '\'' + ", fieldType=" + this.fieldType + ", modifiers=" + this.modifiers + '}';
                }
            }

            protected static class MethodToken
            implements MethodRegistry.LatentMethodMatcher {
                protected final String internalName;
                protected final TypeDescription returnType;
                protected final List<TypeDescription> parameterTypes;
                protected final List<TypeDescription> exceptionTypes;
                protected final int modifiers;

                public MethodToken(List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                    this((modifiers & 8) != 0 ? "<clinit>" : "<init>", new TypeDescription.ForLoadedType(Void.TYPE), (modifiers & 8) != 0 ? ByteBuddyCommons.isEmpty(parameterTypes, "A static constructor must not define parameters") : parameterTypes, exceptionTypes, modifiers);
                }

                public MethodToken(String internalName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                    this.internalName = internalName;
                    this.returnType = returnType;
                    this.parameterTypes = Collections.unmodifiableList(new ArrayList<TypeDescription>(parameterTypes));
                    this.exceptionTypes = Collections.unmodifiableList(new ArrayList<TypeDescription>(exceptionTypes));
                    this.modifiers = modifiers;
                }

                @Override
                public MethodMatcher manifest(TypeDescription instrumentedType) {
                    return ("<init>".equals(this.internalName) || "<clinit>".equals(this.internalName) ? MethodMatchers.isConstructor() : MethodMatchers.named(this.internalName)).and(MethodMatchers.returns(this.resolveReturnType(instrumentedType))).and(MethodMatchers.takesArguments(this.resolveParameterTypes(instrumentedType)));
                }

                protected TypeDescription resolveReturnType(TypeDescription instrumentedType) {
                    return AbstractBase.considerSubstitution(this.returnType, instrumentedType);
                }

                protected List<TypeDescription> resolveParameterTypes(TypeDescription instrumentedType) {
                    ArrayList<TypeDescription> parameterTypes = new ArrayList<TypeDescription>(this.parameterTypes.size());
                    for (TypeDescription parameterType : this.parameterTypes) {
                        parameterTypes.add(AbstractBase.considerSubstitution(parameterType, instrumentedType));
                    }
                    return parameterTypes;
                }

                protected List<TypeDescription> resolveExceptionTypes() {
                    return this.exceptionTypes;
                }

                public String getInternalName() {
                    return this.internalName;
                }

                public TypeDescription getReturnType() {
                    return this.returnType;
                }

                public List<TypeDescription> getParameterTypes() {
                    return this.parameterTypes;
                }

                public List<TypeDescription> getExceptionTypes() {
                    return this.exceptionTypes;
                }

                public int getModifiers() {
                    return this.modifiers;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.internalName.equals(((MethodToken)other).internalName) && this.parameterTypes.equals(((MethodToken)other).parameterTypes) && this.returnType.equals(((MethodToken)other).returnType);
                }

                public int hashCode() {
                    int result = this.internalName.hashCode();
                    result = 31 * result + this.returnType.hashCode();
                    result = 31 * result + this.parameterTypes.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodToken{internalName='" + this.internalName + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + ", exceptionTypes=" + this.exceptionTypes + ", modifiers=" + this.modifiers + '}';
                }
            }
        }

        public static interface FieldAnnotationTarget<S>
        extends Builder<S> {
            public FieldAnnotationTarget<S> attribute(FieldAttributeAppender.Factory var1);

            public FieldAnnotationTarget<S> annotateField(Annotation ... var1);
        }

        public static interface FieldValueTarget<S>
        extends FieldAnnotationTarget<S> {
            public FieldAnnotationTarget<S> value(boolean var1);

            public FieldAnnotationTarget<S> value(int var1);

            public FieldAnnotationTarget<S> value(long var1);

            public FieldAnnotationTarget<S> value(float var1);

            public FieldAnnotationTarget<S> value(double var1);

            public FieldAnnotationTarget<S> value(String var1);

            public static enum NumericRangeValidator {
                BOOLEAN(0, 1),
                BYTE(-128, 127),
                SHORT(Short.MIN_VALUE, Short.MAX_VALUE),
                CHARACTER(0, 65535),
                INTEGER(Integer.MIN_VALUE, Integer.MAX_VALUE),
                LONG(Integer.MIN_VALUE, Integer.MAX_VALUE){

                    @Override
                    public Object validate(int value) {
                        return (long)value;
                    }
                };

                private final int minimum;
                private final int maximum;

                private NumericRangeValidator(int minimum, int maximum) {
                    this.minimum = minimum;
                    this.maximum = maximum;
                }

                public static NumericRangeValidator of(TypeDescription typeDescription) {
                    if (typeDescription.represents(Boolean.TYPE)) {
                        return BOOLEAN;
                    }
                    if (typeDescription.represents(Byte.TYPE)) {
                        return BYTE;
                    }
                    if (typeDescription.represents(Short.TYPE)) {
                        return SHORT;
                    }
                    if (typeDescription.represents(Character.TYPE)) {
                        return CHARACTER;
                    }
                    if (typeDescription.represents(Integer.TYPE)) {
                        return INTEGER;
                    }
                    if (typeDescription.represents(Long.TYPE)) {
                        return LONG;
                    }
                    throw new IllegalStateException(String.format("A field of type %s does not permit an integer-typed default value", typeDescription));
                }

                public Object validate(int value) {
                    if (value < this.minimum || value > this.maximum) {
                        throw new IllegalArgumentException(String.format("The value %d overflows for %s", new Object[]{value, this}));
                    }
                    return value;
                }
            }
        }

        public static interface MethodAnnotationTarget<S>
        extends Builder<S> {
            public MethodAnnotationTarget<S> attribute(MethodAttributeAppender.Factory var1);

            public MethodAnnotationTarget<S> annotateMethod(Annotation ... var1);

            public MethodAnnotationTarget<S> annotateParameter(int var1, Annotation ... var2);
        }

        public static interface OptionalMatchedMethodInterception<S>
        extends MatchedMethodInterception<S>,
        Builder<S> {
        }

        public static interface ExceptionDeclarableMethodInterception<S>
        extends MatchedMethodInterception<S> {
            public MatchedMethodInterception<S> throwing(Class<?> ... var1);

            public MatchedMethodInterception<S> throwing(TypeDescription ... var1);
        }

        public static interface MatchedMethodInterception<T> {
            public MethodAnnotationTarget<T> intercept(Instrumentation var1);

            public MethodAnnotationTarget<T> withoutCode();
        }
    }
}

