/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ByteArrayClassLoader
extends ClassLoader {
    private final Map<String, byte[]> typeDefinitions;

    public ByteArrayClassLoader(ClassLoader parent, Map<String, byte[]> typeDefinitions) {
        super(parent);
        this.typeDefinitions = new HashMap<String, byte[]>(typeDefinitions);
    }

    public ByteArrayClassLoader(Map<TypeDescription, byte[]> typeDefinitions, ClassLoader parent) {
        super(parent);
        this.typeDefinitions = new HashMap<String, byte[]>(typeDefinitions.size());
        for (Map.Entry<TypeDescription, byte[]> entry : typeDefinitions.entrySet()) {
            this.typeDefinitions.put(entry.getKey().getName(), entry.getValue());
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] javaType = this.typeDefinitions.remove(name);
        if (javaType != null) {
            return this.defineClass(name, javaType, 0, javaType.length);
        }
        return super.findClass(name);
    }

    public String toString() {
        return "ByteArrayClassLoader{typeDefinitions=" + this.typeDefinitions + " (unloaded)}";
    }
}

