/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.TypeInitializer;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface MethodRegistry {
    public MethodRegistry prepend(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public MethodRegistry append(LatentMethodMatcher var1, Instrumentation var2, MethodAttributeAppender.Factory var3);

    public Compiled compile(InstrumentedType var1, MethodLookupEngine var2, Instrumentation.Target.Factory var3, TypeWriter.MethodPool.Entry var4);

    public static class Default
    implements MethodRegistry {
        private static final int AT_BEGINNING = 0;
        private final List<Entry> entries;

        public Default() {
            this.entries = Collections.emptyList();
        }

        private Default(List<Entry> entries) {
            this.entries = entries;
        }

        @Override
        public MethodRegistry append(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(this.entries, new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory)));
        }

        @Override
        public MethodRegistry prepend(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
            return new Default(ByteBuddyCommons.join(new Entry(latentMethodMatcher, instrumentation, attributeAppenderFactory), this.entries));
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled compile(InstrumentedType instrumentedType, MethodLookupEngine methodLookupEngine, Instrumentation.Target.Factory instrumentationTargetFactory, TypeWriter.MethodPool.Entry fallback) {
            LinkedList<Entry> additionalEntries = new LinkedList<Entry>();
            instrumentedType = this.prepareInstrumentedType(instrumentedType, additionalEntries);
            MethodLookupEngine.Finding finding = methodLookupEngine.process(instrumentedType.detach());
            return new Compiled(finding, instrumentedType.getTypeInitializer(), this.compileEntries(additionalEntries, instrumentationTargetFactory.make(finding)), fallback);
        }

        private InstrumentedType prepareInstrumentedType(InstrumentedType instrumentedType, List<Entry> additionalEntries) {
            HashSet<Instrumentation> instrumentations = new HashSet<Instrumentation>(this.entries.size());
            for (Entry entry : this.entries) {
                if (!instrumentations.add(entry.instrumentation)) continue;
                MethodList beforePreparation = instrumentedType.getDeclaredMethods();
                instrumentedType = entry.instrumentation.prepare(instrumentedType);
                if (beforePreparation.size() >= instrumentedType.getDeclaredMethods().size()) continue;
                additionalEntries.add(new Entry(new ListDifferenceMethodMatcher(beforePreparation, instrumentedType.getDeclaredMethods()), entry.instrumentation, MethodAttributeAppender.NoOp.INSTANCE));
            }
            return instrumentedType;
        }

        private List<Compiled.Entry> compileEntries(List<Entry> additionalEntries, Instrumentation.Target instrumentationTarget) {
            HashMap<Instrumentation, ByteCodeAppender> byteCodeAppenders = new HashMap<Instrumentation, ByteCodeAppender>(this.entries.size());
            LinkedList<Compiled.Entry> compiledEntries = new LinkedList<Compiled.Entry>();
            for (Entry entry : this.entries) {
                if (!byteCodeAppenders.containsKey(entry.instrumentation)) {
                    byteCodeAppenders.put(entry.instrumentation, entry.instrumentation.appender(instrumentationTarget));
                }
                compiledEntries.add(new Compiled.Entry(entry.latentMethodMatcher.manifest(instrumentationTarget.getTypeDescription()), (ByteCodeAppender)byteCodeAppenders.get(entry.instrumentation), entry.attributeAppenderFactory.make(instrumentationTarget.getTypeDescription())));
            }
            for (Entry entry : additionalEntries) {
                compiledEntries.add(0, new Compiled.Entry(entry.latentMethodMatcher.manifest(instrumentationTarget.getTypeDescription()), (ByteCodeAppender)byteCodeAppenders.get(entry.instrumentation), entry.attributeAppenderFactory.make(instrumentationTarget.getTypeDescription())));
            }
            return new ArrayList<Compiled.Entry>(compiledEntries);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "MethodRegistry.Default{entries=" + this.entries + '}';
        }

        private static class ListDifferenceMethodMatcher
        implements MethodMatcher,
        LatentMethodMatcher {
            private final MethodList matchedMethods;

            private ListDifferenceMethodMatcher(MethodList beforeMethods, MethodList afterMethods) {
                this.matchedMethods = afterMethods.subList(beforeMethods.size(), afterMethods.size());
            }

            @Override
            public boolean matches(MethodDescription methodDescription) {
                return this.matchedMethods.filter(MethodMatchers.is(methodDescription)).size() == 1;
            }

            @Override
            public MethodMatcher manifest(TypeDescription typeDescription) {
                return this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.matchedMethods.equals(((ListDifferenceMethodMatcher)other).matchedMethods);
            }

            public int hashCode() {
                return this.matchedMethods.hashCode();
            }

            public String toString() {
                return "oneOf(" + this.matchedMethods + ')';
            }
        }

        private static class Entry {
            private final LatentMethodMatcher latentMethodMatcher;
            private final Instrumentation instrumentation;
            private final MethodAttributeAppender.Factory attributeAppenderFactory;

            private Entry(LatentMethodMatcher latentMethodMatcher, Instrumentation instrumentation, MethodAttributeAppender.Factory attributeAppenderFactory) {
                this.latentMethodMatcher = latentMethodMatcher;
                this.instrumentation = instrumentation;
                this.attributeAppenderFactory = attributeAppenderFactory;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && this.instrumentation.equals(entry.instrumentation) && this.latentMethodMatcher.equals(entry.latentMethodMatcher);
            }

            public int hashCode() {
                int result = this.latentMethodMatcher.hashCode();
                result = 31 * result + this.instrumentation.hashCode();
                result = 31 * result + this.attributeAppenderFactory.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Entry{latentMethodMatcher=" + this.latentMethodMatcher + ", instrumentation=" + this.instrumentation + ", attributeAppenderFactory=" + this.attributeAppenderFactory + '}';
            }
        }

        private static class Compiled
        implements net.bytebuddy.dynamic.scaffold.MethodRegistry$Compiled {
            private final MethodLookupEngine.Finding finding;
            private final TypeInitializer typeInitializer;
            private final List<Entry> entries;
            private final TypeWriter.MethodPool.Entry fallback;

            private Compiled(MethodLookupEngine.Finding finding, TypeInitializer typeInitializer, List<Entry> entries, TypeWriter.MethodPool.Entry fallback) {
                this.finding = finding;
                this.typeInitializer = typeInitializer;
                this.entries = entries;
                this.fallback = fallback;
            }

            @Override
            public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
                for (Entry entry : this.entries) {
                    if (!entry.matches(methodDescription)) continue;
                    return entry;
                }
                return this.fallback;
            }

            @Override
            public MethodLookupEngine.Finding getFinding() {
                return this.finding;
            }

            @Override
            public TypeInitializer getTypeInitializer() {
                return this.typeInitializer;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Compiled compiled = (Compiled)other;
                return this.entries.equals(compiled.entries) && this.fallback.equals(compiled.fallback) && this.finding.equals(compiled.finding) && this.typeInitializer.equals(compiled.typeInitializer);
            }

            public int hashCode() {
                int result = this.finding.hashCode();
                result = 31 * result + this.typeInitializer.hashCode();
                result = 31 * result + this.entries.hashCode();
                result = 31 * result + this.fallback.hashCode();
                return result;
            }

            public String toString() {
                return "MethodRegistry.Default.Compiled{finding=" + this.finding + ", typeInitializer=" + this.typeInitializer + ", entries=" + this.entries + ", fallback=" + this.fallback + '}';
            }

            private static class Entry
            implements TypeWriter.MethodPool.Entry,
            MethodMatcher {
                private final MethodMatcher methodMatcher;
                private final ByteCodeAppender byteCodeAppender;
                private final MethodAttributeAppender attributeAppender;

                private Entry(MethodMatcher methodMatcher, ByteCodeAppender byteCodeAppender, MethodAttributeAppender attributeAppender) {
                    this.methodMatcher = methodMatcher;
                    this.byteCodeAppender = byteCodeAppender;
                    this.attributeAppender = attributeAppender;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this.byteCodeAppender;
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return this.attributeAppender;
                }

                @Override
                public boolean matches(MethodDescription methodDescription) {
                    return this.methodMatcher.matches(methodDescription);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Entry entry = (Entry)other;
                    return this.attributeAppender.equals(entry.attributeAppender) && this.byteCodeAppender.equals(entry.byteCodeAppender) && this.methodMatcher.equals(entry.methodMatcher);
                }

                public int hashCode() {
                    int result = this.methodMatcher.hashCode();
                    result = 31 * result + this.byteCodeAppender.hashCode();
                    result = 31 * result + this.attributeAppender.hashCode();
                    return result;
                }

                public String toString() {
                    return "MethodRegistry.Default.Compiled.Entry{methodMatcher=" + this.methodMatcher + ", byteCodeAppender=" + this.byteCodeAppender + ", attributeAppender=" + this.attributeAppender + '}';
                }
            }
        }
    }

    public static interface LatentMethodMatcher {
        public MethodMatcher manifest(TypeDescription var1);

        public static class Simple
        implements LatentMethodMatcher {
            private final MethodMatcher methodMatcher;

            public Simple(MethodMatcher methodMatcher) {
                this.methodMatcher = methodMatcher;
            }

            @Override
            public MethodMatcher manifest(TypeDescription instrumentedType) {
                return this.methodMatcher;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.methodMatcher.equals(((Simple)other).methodMatcher);
            }

            public int hashCode() {
                return this.methodMatcher.hashCode();
            }

            public String toString() {
                return "MethodRegistry.LatentMethodMatcher.Simple{methodMatcher=" + this.methodMatcher + '}';
            }
        }
    }

    public static interface Compiled
    extends TypeWriter.MethodPool {
        public MethodLookupEngine.Finding getFinding();

        public TypeInitializer getTypeInitializer();
    }
}

