/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;

public class TypeExtensionDelegate
implements Instrumentation.Context.ExtractableView,
AuxiliaryType.MethodAccessorFactory,
TypeWriter.MethodPool {
    private static final String DEFAULT_ACCESSOR_METHOD_SUFFIX = "accessor";
    private final TypeDescription instrumentedType;
    private final ClassFileVersion classFileVersion;
    private final String accessorMethodSuffix;
    private final AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy;
    private final Map<Instrumentation.SpecialMethodInvocation, MethodDescription> registeredAccessorMethods;
    private final List<MethodDescription> orderedAccessorMethods;
    private final Map<MethodDescription, TypeWriter.MethodPool.Entry> accessorMethodEntries;
    private final Map<AuxiliaryType, DynamicType> auxiliaryTypes;
    private final Random random;

    public TypeExtensionDelegate(TypeDescription instrumentedType, ClassFileVersion classFileVersion) {
        this(instrumentedType, classFileVersion, DEFAULT_ACCESSOR_METHOD_SUFFIX, new AuxiliaryTypeNamingStrategy.SuffixingRandom(DEFAULT_ACCESSOR_METHOD_SUFFIX));
    }

    public TypeExtensionDelegate(TypeDescription instrumentedType, ClassFileVersion classFileVersion, String accessorMethodSuffix, AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy) {
        this.instrumentedType = instrumentedType;
        this.classFileVersion = classFileVersion;
        this.accessorMethodSuffix = accessorMethodSuffix;
        this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
        this.registeredAccessorMethods = new HashMap<Instrumentation.SpecialMethodInvocation, MethodDescription>();
        this.orderedAccessorMethods = new LinkedList<MethodDescription>();
        this.accessorMethodEntries = new HashMap<MethodDescription, TypeWriter.MethodPool.Entry>();
        this.auxiliaryTypes = new HashMap<AuxiliaryType, DynamicType>();
        this.random = new Random();
    }

    @Override
    public MethodDescription registerAccessorFor(Instrumentation.SpecialMethodInvocation specialMethodInvocation) {
        MethodDescription accessorMethod = this.registeredAccessorMethods.get(specialMethodInvocation);
        if (accessorMethod == null) {
            String name = String.format("%s$%s$%d", specialMethodInvocation.getMethodDescription().getInternalName(), this.accessorMethodSuffix, Math.abs(this.random.nextInt()));
            accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, specialMethodInvocation.getMethodDescription().getReturnType(), specialMethodInvocation.getMethodDescription().getParameterTypes(), 4112);
            this.registerAccessor(specialMethodInvocation, accessorMethod);
        }
        return accessorMethod;
    }

    private void registerAccessor(Instrumentation.SpecialMethodInvocation specialMethodInvocation, MethodDescription accessorMethod) {
        this.registeredAccessorMethods.put(specialMethodInvocation, accessorMethod);
        this.orderedAccessorMethods.add(accessorMethod);
        this.accessorMethodEntries.put(accessorMethod, new AccessorMethodDelegation(specialMethodInvocation));
    }

    public Iterable<MethodDescription> getRegisteredAccessors() {
        return new SameThreadCoModifiableIterable<MethodDescription>(this.orderedAccessorMethods);
    }

    @Override
    public TypeWriter.MethodPool.Entry target(MethodDescription methodDescription) {
        TypeWriter.MethodPool.Entry targetMethodCall = this.accessorMethodEntries.get(methodDescription);
        if (targetMethodCall == null) {
            throw new IllegalArgumentException("Unknown accessor method: " + methodDescription);
        }
        return targetMethodCall;
    }

    @Override
    public TypeDescription register(AuxiliaryType auxiliaryType) {
        DynamicType dynamicType = this.auxiliaryTypes.get(auxiliaryType);
        if (dynamicType == null) {
            dynamicType = auxiliaryType.make(this.auxiliaryTypeNamingStrategy.name(auxiliaryType, this.instrumentedType), this.classFileVersion, this);
            this.auxiliaryTypes.put(auxiliaryType, dynamicType);
        }
        return dynamicType.getDescription();
    }

    public List<DynamicType> getRegisteredAuxiliaryTypes() {
        return new ArrayList<DynamicType>(this.auxiliaryTypes.values());
    }

    public String toString() {
        return "TypeExtensionDelegate{instrumentedType=" + this.instrumentedType + ", classFileVersion=" + this.classFileVersion + ", accessorMethodSuffix='" + this.accessorMethodSuffix + '\'' + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", registeredAccessorMethods=" + this.registeredAccessorMethods + ", orderedAccessorMethods=" + this.orderedAccessorMethods + ", accessorMethodEntries=" + this.accessorMethodEntries + ", auxiliaryTypes=" + this.auxiliaryTypes + ", random=" + this.random + '}';
    }

    private static class AccessorMethodDelegation
    implements TypeWriter.MethodPool.Entry,
    ByteCodeAppender {
        private final StackManipulation accessorMethodInvocation;

        private AccessorMethodDelegation(StackManipulation accessorMethodInvocation) {
            this.accessorMethodInvocation = accessorMethodInvocation;
        }

        @Override
        public ByteCodeAppender getByteCodeAppender() {
            return this;
        }

        @Override
        public boolean isDefineMethod() {
            return true;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), this.accessorMethodInvocation, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        @Override
        public MethodAttributeAppender getAttributeAppender() {
            return MethodAttributeAppender.NoOp.INSTANCE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.accessorMethodInvocation.equals(((AccessorMethodDelegation)other).accessorMethodInvocation);
        }

        public int hashCode() {
            return this.accessorMethodInvocation.hashCode();
        }

        public String toString() {
            return "TypeExtensionDelegate.AccessorMethodDelegation{accessorMethodInvocation=" + this.accessorMethodInvocation + '}';
        }
    }

    public static class SameThreadCoModifiableIterable<S>
    implements Iterable<S> {
        private final List<? extends S> elements;

        public SameThreadCoModifiableIterable(List<? extends S> elements) {
            this.elements = elements;
        }

        @Override
        public java.util.Iterator<S> iterator() {
            return new Iterator();
        }

        public String toString() {
            return "TypeExtensionDelegate.SameThreadCoModifiableIterable{elements=" + this.elements + '}';
        }

        private class Iterator
        implements java.util.Iterator<S> {
            private int index = 0;

            private Iterator() {
            }

            @Override
            public boolean hasNext() {
                return this.index < SameThreadCoModifiableIterable.this.elements.size();
            }

            @Override
            public S next() {
                return SameThreadCoModifiableIterable.this.elements.get(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return "TypeExtensionDelegate.SameThreadCoModifiableIterable.Iterator{iterable=" + SameThreadCoModifiableIterable.this + ", index=" + this.index + '}';
            }
        }
    }

    public static interface AuxiliaryTypeNamingStrategy {
        public String name(AuxiliaryType var1, TypeDescription var2);

        public static class SuffixingRandom
        implements AuxiliaryTypeNamingStrategy {
            private final String suffix;
            private final Random random;

            public SuffixingRandom(String suffix) {
                this.suffix = suffix;
                this.random = new Random();
            }

            @Override
            public String name(AuxiliaryType auxiliaryType, TypeDescription instrumentedType) {
                return String.format("%s$%s$%d", instrumentedType.getName(), this.suffix, Math.abs(this.random.nextInt()));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((SuffixingRandom)other).suffix);
            }

            public int hashCode() {
                return this.suffix.hashCode();
            }

            public String toString() {
                return "TypeExtensionDelegate.AuxiliaryTypeNamingStrategySuffixingRandom{suffix='" + this.suffix + '\'' + '}';
            }
        }
    }
}

