/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.TypeInitializer;
import net.bytebuddy.instrumentation.attribute.FieldAttributeAppender;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.attribute.TypeAttributeAppender;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface TypeWriter<T> {
    public static final int ASM_MANUAL_FLAG = 0;

    public DynamicType.Unloaded<T> make();

    public static class Builder<T> {
        private final TypeDescription instrumentedType;
        private final TypeInitializer typeInitializer;
        private final Instrumentation.Context.ExtractableView instrumentationContext;
        private final ClassFileVersion classFileVersion;

        public Builder(TypeDescription instrumentedType, TypeInitializer typeInitializer, Instrumentation.Context.ExtractableView instrumentationContext, ClassFileVersion classFileVersion) {
            this.instrumentedType = instrumentedType;
            this.typeInitializer = typeInitializer;
            this.instrumentationContext = instrumentationContext;
            this.classFileVersion = classFileVersion;
        }

        private static int overrideModifiers(MethodDescription methodDescription, boolean appendsCode) {
            if (appendsCode && (methodDescription.isAbstract() || methodDescription.isNative())) {
                return methodDescription.getModifiers() & 0xFFFFFAFF;
            }
            if (!(appendsCode || methodDescription.isAbstract() || methodDescription.isNative())) {
                return methodDescription.getModifiers() | 0x400;
            }
            return methodDescription.getModifiers();
        }

        public InGeneralPhase<T> build(ClassVisitorWrapper classVisitorWrapper) {
            ClassWriter classWriter = new ClassWriter(0);
            ClassVisitor classVisitor = classVisitorWrapper.wrap(classWriter);
            classVisitor.visit(this.classFileVersion.getVersionNumber(), this.instrumentedType.getModifiers(), this.instrumentedType.getInternalName(), null, this.instrumentedType.getSupertype() == null ? null : this.instrumentedType.getSupertype().getInternalName(), this.instrumentedType.getInterfaces().toInternalNames());
            return new Handler(classWriter, classVisitor);
        }

        public String toString() {
            return "TypeWriter.Builder{instrumentedType=" + this.instrumentedType + ", typeInitializer=" + this.typeInitializer + ", instrumentationContext=" + this.instrumentationContext + ", classFileVersion=" + this.classFileVersion + '}';
        }

        private class Handler<S>
        implements TypeWriter<S>,
        InGeneralPhase<S>,
        InFieldPhase<S>,
        InMethodPhase<S> {
            protected final ClassWriter classWriter;
            protected final ClassVisitor classVisitor;

            protected Handler(ClassWriter classWriter, ClassVisitor classVisitor) {
                this.classWriter = classWriter;
                this.classVisitor = classVisitor;
            }

            @Override
            public InFieldPhase<S> write(Iterable<? extends FieldDescription> fieldDescriptions, FieldPool fieldPool) {
                for (FieldDescription fieldDescription : fieldDescriptions) {
                    FieldPool.Entry entry = fieldPool.target(fieldDescription);
                    FieldVisitor fieldVisitor = this.classVisitor.visitField(fieldDescription.getModifiers(), fieldDescription.getInternalName(), fieldDescription.getDescriptor(), null, entry.getDefaultValue());
                    entry.getFieldAppenderFactory().make(Builder.this.instrumentedType).apply(fieldVisitor, fieldDescription);
                    fieldVisitor.visitEnd();
                }
                return this;
            }

            @Override
            public InGeneralPhase<S> attributeType(TypeAttributeAppender typeAttributeAppender) {
                typeAttributeAppender.apply(this.classVisitor, Builder.this.instrumentedType);
                return this;
            }

            @Override
            public InFieldPhase<S> fields() {
                return this;
            }

            @Override
            public InMethodPhase<S> methods() {
                return this;
            }

            @Override
            public InMethodPhase<S> write(Iterable<? extends MethodDescription> methodDescriptions, MethodPool methodPool) {
                for (MethodDescription methodDescription : methodDescriptions) {
                    MethodPool.Entry entry = methodPool.target(methodDescription);
                    if (!entry.isDefineMethod()) continue;
                    boolean appendsCode = entry.getByteCodeAppender().appendsCode();
                    MethodVisitor methodVisitor = this.classVisitor.visitMethod(Builder.overrideModifiers(methodDescription, appendsCode), methodDescription.getInternalName(), methodDescription.getDescriptor(), null, methodDescription.getExceptionTypes().toInternalNames());
                    entry.getAttributeAppender().apply(methodVisitor, methodDescription);
                    if (appendsCode) {
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = entry.getByteCodeAppender().apply(methodVisitor, Builder.this.instrumentationContext, methodDescription);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    }
                    methodVisitor.visitEnd();
                }
                return this;
            }

            @Override
            public DynamicType.Unloaded<S> make() {
                this.classVisitor.visitEnd();
                return new DynamicType.Default.Unloaded(Builder.this.instrumentedType, this.classWriter.toByteArray(), Builder.this.typeInitializer, Builder.this.instrumentationContext.getRegisteredAuxiliaryTypes());
            }

            public String toString() {
                return "TypeWriter.Builder.Handler{builder=" + Builder.this + ", classWriter=" + this.classWriter + ", classVisitor=" + this.classVisitor + '}';
            }
        }
    }

    public static interface InMethodPhase<T>
    extends TypeWriter<T> {
        public InMethodPhase<T> write(Iterable<? extends MethodDescription> var1, MethodPool var2);
    }

    public static interface InFieldPhase<T>
    extends TypeWriter<T>,
    MethodPhaseTransitional<T> {
        public InFieldPhase<T> write(Iterable<? extends FieldDescription> var1, FieldPool var2);
    }

    public static interface InGeneralPhase<T>
    extends TypeWriter<T>,
    FieldPhaseTransitional<T>,
    MethodPhaseTransitional<T> {
        public InGeneralPhase<T> attributeType(TypeAttributeAppender var1);
    }

    public static interface MethodPhaseTransitional<T> {
        public InMethodPhase<T> methods();
    }

    public static interface FieldPhaseTransitional<T> {
        public InFieldPhase<T> fields();
    }

    public static interface MethodPool {
        public Entry target(MethodDescription var1);

        public static interface Entry {
            public boolean isDefineMethod();

            public ByteCodeAppender getByteCodeAppender();

            public MethodAttributeAppender getAttributeAppender();

            public static class Simple
            implements Entry {
                private final ByteCodeAppender byteCodeAppender;
                private final MethodAttributeAppender methodAttributeAppender;

                public Simple(ByteCodeAppender byteCodeAppender, MethodAttributeAppender methodAttributeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                    this.methodAttributeAppender = methodAttributeAppender;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this.byteCodeAppender;
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return this.methodAttributeAppender;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Simple)other).byteCodeAppender) && this.methodAttributeAppender.equals(((Simple)other).methodAttributeAppender);
                }

                public int hashCode() {
                    return 31 * this.byteCodeAppender.hashCode() + this.methodAttributeAppender.hashCode();
                }

                public String toString() {
                    return "TypeWriter.MethodPool.Entry.Simple{byteCodeAppender=" + this.byteCodeAppender + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                }
            }

            public static enum Skip implements Entry
            {
                INSTANCE;


                @Override
                public boolean isDefineMethod() {
                    return false;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    throw new IllegalStateException();
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public static interface FieldPool {
        public Entry target(FieldDescription var1);

        public static interface Entry {
            public FieldAttributeAppender.Factory getFieldAppenderFactory();

            public Object getDefaultValue();

            public static class Simple
            implements Entry {
                private final FieldAttributeAppender.Factory attributeAppenderFactory;
                private final Object defaultValue;

                public Simple(FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
                    this.attributeAppenderFactory = attributeAppenderFactory;
                    this.defaultValue = defaultValue;
                }

                @Override
                public FieldAttributeAppender.Factory getFieldAppenderFactory() {
                    return this.attributeAppenderFactory;
                }

                @Override
                public Object getDefaultValue() {
                    return this.defaultValue;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Simple simple = (Simple)other;
                    return this.attributeAppenderFactory.equals(simple.attributeAppenderFactory) && !(this.defaultValue == null ? simple.defaultValue != null : !this.defaultValue.equals(simple.defaultValue));
                }

                public int hashCode() {
                    return 31 * this.attributeAppenderFactory.hashCode() + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                }

                public String toString() {
                    return "TypeWriter.FieldPool.Entry.Simple{attributeAppenderFactory=" + this.attributeAppenderFactory + ", defaultValue=" + this.defaultValue + '}';
                }
            }

            public static enum NoOp implements Entry
            {
                INSTANCE;


                @Override
                public FieldAttributeAppender.Factory getFieldAppenderFactory() {
                    return FieldAttributeAppender.NoOp.INSTANCE;
                }

                @Override
                public Object getDefaultValue() {
                    return null;
                }
            }
        }
    }
}

