/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.subclass;

import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.TypeList;

public class SubclassInstrumentationTarget
extends Instrumentation.Target.AbstractBase {
    private final Map<TypeList, MethodDescription> superConstructors;

    protected SubclassInstrumentationTarget(MethodLookupEngine.Finding finding, BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
        super(finding, bridgeMethodResolverFactory);
        MethodList superConstructors = finding.getTypeDescription().getSupertype().getDeclaredMethods().filter(MethodMatchers.isConstructor());
        this.superConstructors = new HashMap<TypeList, MethodDescription>(superConstructors.size());
        for (MethodDescription superConstructor : superConstructors) {
            this.superConstructors.put(superConstructor.getParameterTypes(), superConstructor);
        }
    }

    @Override
    protected Instrumentation.SpecialMethodInvocation invokeSuper(MethodDescription methodDescription) {
        if (methodDescription.isConstructor() && (methodDescription = this.superConstructors.get(methodDescription.getParameterTypes())) == null) {
            return Instrumentation.SpecialMethodInvocation.Illegal.INSTANCE;
        }
        return Instrumentation.SpecialMethodInvocation.Simple.of(methodDescription, this.typeDescription.getSupertype());
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && super.equals(other);
    }

    @Override
    public int hashCode() {
        return 7 * super.hashCode();
    }

    public String toString() {
        return "SubclassInstrumentationTarget{typeDescription=" + this.typeDescription + ", defaultMethods=" + this.defaultMethods + ", bridgeMethodResolver=" + this.bridgeMethodResolver + '}';
    }

    public static class Factory
    implements Instrumentation.Target.Factory {
        private final BridgeMethodResolver.Factory bridgeMethodResolverFactory;

        public Factory(BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
            this.bridgeMethodResolverFactory = bridgeMethodResolverFactory;
        }

        @Override
        public Instrumentation.Target make(MethodLookupEngine.Finding methodLookupEngineFinding) {
            return new SubclassInstrumentationTarget(methodLookupEngineFinding, this.bridgeMethodResolverFactory);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.bridgeMethodResolverFactory.equals(((Factory)other).bridgeMethodResolverFactory);
        }

        public int hashCode() {
            return this.bridgeMethodResolverFactory.hashCode();
        }

        public String toString() {
            return "SubclassInstrumentationTarget.Factory{bridgeMethodResolverFactory=" + this.bridgeMethodResolverFactory + '}';
        }
    }
}

