/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface Instrumentation {
    public InstrumentedType prepare(InstrumentedType var1);

    public ByteCodeAppender appender(Target var1);

    public static class Compound
    implements Instrumentation {
        private final Instrumentation[] instrumentation;

        public Compound(Instrumentation ... instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            for (Instrumentation instrumentation : this.instrumentation) {
                instrumentedType = instrumentation.prepare(instrumentedType);
            }
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target instrumentationTarget) {
            ByteCodeAppender[] byteCodeAppender = new ByteCodeAppender[this.instrumentation.length];
            int index = 0;
            for (Instrumentation instrumentation : this.instrumentation) {
                byteCodeAppender[index++] = instrumentation.appender(instrumentationTarget);
            }
            return new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.instrumentation, ((Compound)o).instrumentation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.instrumentation);
        }

        public String toString() {
            return "Compound{" + Arrays.toString(this.instrumentation) + '}';
        }
    }

    public static interface Context {
        public TypeDescription register(AuxiliaryType var1);

        public static interface ExtractableView
        extends Context {
            public List<? extends DynamicType> getRegisteredAuxiliaryTypes();
        }
    }

    public static interface Target {
        public TypeDescription getTypeDescription();

        public SpecialMethodInvocation invokeSuper(MethodDescription var1, MethodLookup var2);

        public SpecialMethodInvocation invokeDefault(TypeDescription var1, String var2);

        public static abstract class AbstractBase
        implements Target {
            protected final TypeDescription typeDescription;
            protected final Map<String, MethodDescription> invokableMethods;
            protected final Map<TypeDescription, Map<String, MethodDescription>> defaultMethods;
            protected final BridgeMethodResolver bridgeMethodResolver;

            protected AbstractBase(MethodLookupEngine.Finding finding, BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                this.bridgeMethodResolver = bridgeMethodResolverFactory.make(finding.getInvokableMethods());
                this.typeDescription = finding.getTypeDescription();
                this.invokableMethods = new HashMap<String, MethodDescription>(finding.getInvokableMethods().size());
                for (MethodDescription methodDescription : finding.getInvokableMethods()) {
                    this.invokableMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                }
                this.defaultMethods = new HashMap<TypeDescription, Map<String, MethodDescription>>(finding.getInvokableDefaultMethods().size());
                for (Map.Entry entry : finding.getInvokableDefaultMethods().entrySet()) {
                    HashMap<String, MethodDescription> defaultMethods = new HashMap<String, MethodDescription>(((Set)entry.getValue()).size());
                    for (MethodDescription methodDescription : (Set)entry.getValue()) {
                        defaultMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                    }
                    this.defaultMethods.put((TypeDescription)entry.getKey(), (Map<String, MethodDescription>)defaultMethods);
                }
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public SpecialMethodInvocation invokeSuper(MethodDescription methodDescription, MethodLookup methodLookup) {
                return this.invokeSuper(methodLookup.resolve(methodDescription, this.invokableMethods, this.bridgeMethodResolver));
            }

            protected abstract SpecialMethodInvocation invokeSuper(MethodDescription var1);

            @Override
            public SpecialMethodInvocation invokeDefault(TypeDescription targetType, String uniqueMethodSignature) {
                MethodDescription defaultMethod;
                Map<String, MethodDescription> defaultMethods = this.defaultMethods.get(targetType);
                if (defaultMethods != null && (defaultMethod = defaultMethods.get(uniqueMethodSignature)) != null) {
                    return SpecialMethodInvocation.Simple.of(defaultMethod, targetType);
                }
                return SpecialMethodInvocation.Illegal.INSTANCE;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AbstractBase that = (AbstractBase)other;
                return this.bridgeMethodResolver.equals(that.bridgeMethodResolver) && this.defaultMethods.equals(that.defaultMethods) && this.typeDescription.equals(that.typeDescription);
            }

            public int hashCode() {
                int result = this.typeDescription.hashCode();
                result = 31 * result + this.defaultMethods.hashCode();
                result = 31 * result + this.bridgeMethodResolver.hashCode();
                return result;
            }
        }

        public static interface Factory {
            public Target make(MethodLookupEngine.Finding var1);
        }

        public static interface MethodLookup {
            public MethodDescription resolve(MethodDescription var1, Map<String, MethodDescription> var2, BridgeMethodResolver var3);

            public static enum Default implements MethodLookup
            {
                EXACT{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return methodDescription;
                    }
                }
                ,
                MOST_SPECIFIC{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return bridgeMethodResolver.resolve(invokableMethods.get(methodDescription.getUniqueSignature()));
                    }
                };

            }
        }
    }

    public static interface SpecialMethodInvocation
    extends StackManipulation {
        public MethodDescription getMethodDescription();

        public TypeDescription getTypeDescription();

        public static class Simple
        implements SpecialMethodInvocation {
            private final MethodDescription methodDescription;
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            private Simple(MethodDescription methodDescription, TypeDescription typeDescription, StackManipulation stackManipulation) {
                this.methodDescription = methodDescription;
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            public static SpecialMethodInvocation of(MethodDescription methodDescription, TypeDescription typeDescription) {
                StackManipulation stackManipulation = MethodInvocation.invoke(methodDescription).special(typeDescription);
                return stackManipulation.isValid() ? new Simple(methodDescription, typeDescription, stackManipulation) : Illegal.INSTANCE;
            }

            @Override
            public MethodDescription getMethodDescription() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public boolean isValid() {
                return this.stackManipulation.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context instrumentationContext) {
                return this.stackManipulation.apply(methodVisitor, instrumentationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                SpecialMethodInvocation specialMethodInvocation = (SpecialMethodInvocation)other;
                return this.isValid() == specialMethodInvocation.isValid() && this.typeDescription.equals(specialMethodInvocation.getTypeDescription()) && this.methodDescription.getInternalName().equals(specialMethodInvocation.getMethodDescription().getInternalName()) && this.methodDescription.getParameterTypes().equals(specialMethodInvocation.getMethodDescription().getParameterTypes()) && this.methodDescription.getReturnType().equals(specialMethodInvocation.getMethodDescription().getReturnType());
            }

            public int hashCode() {
                int result = this.methodDescription.getInternalName().hashCode();
                result = 31 * result + this.methodDescription.getParameterTypes().hashCode();
                result = 31 * result + this.methodDescription.getReturnType().hashCode();
                result = 31 * result + this.typeDescription.hashCode();
                return result;
            }

            public String toString() {
                return "Instrumentation.SpecialMethodInvocation.Legal{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum Illegal implements SpecialMethodInvocation
        {
            INSTANCE;


            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context instrumentationContext) {
                throw new IllegalStateException();
            }

            @Override
            public MethodDescription getMethodDescription() {
                throw new IllegalStateException();
            }

            @Override
            public TypeDescription getTypeDescription() {
                throw new IllegalStateException();
            }
        }
    }

    public static enum ForAbstractMethod implements Instrumentation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target instrumentationTarget) {
            return this;
        }

        @Override
        public boolean appendsCode() {
            return false;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context instrumentationContext, MethodDescription instrumentedMethod) {
            throw new IllegalStateException();
        }
    }
}

