/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public interface TypeInitializer {
    public void onLoad(Class<?> var1);

    public boolean isAlive();

    public static class Compound
    implements TypeInitializer,
    Serializable {
        private final TypeInitializer[] typeInitializer;

        public Compound(TypeInitializer ... typeInitializer) {
            this.typeInitializer = typeInitializer;
        }

        public Compound(List<? extends TypeInitializer> typeInitializers) {
            this.typeInitializer = typeInitializers.toArray(new TypeInitializer[typeInitializers.size()]);
        }

        @Override
        public void onLoad(Class<?> type) {
            for (TypeInitializer typeInitializer : this.typeInitializer) {
                typeInitializer.onLoad(type);
            }
        }

        @Override
        public boolean isAlive() {
            for (TypeInitializer typeInitializer : this.typeInitializer) {
                if (!typeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.typeInitializer, ((Compound)other).typeInitializer);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeInitializer);
        }

        public String toString() {
            return "TypeInitializer.Compound{typeInitializer=" + Arrays.toString(this.typeInitializer) + '}';
        }
    }

    public static class ForStaticField<T>
    implements TypeInitializer,
    Serializable {
        private static final Object STATIC_FIELD = null;
        private final String fieldName;
        private final T value;
        private final boolean makeAccessible;

        protected ForStaticField(String fieldName, T value, boolean makeAccessible) {
            this.fieldName = fieldName;
            this.value = value;
            this.makeAccessible = makeAccessible;
        }

        public static TypeInitializer accessible(String fieldName, Object value) {
            return new ForStaticField<Object>(fieldName, value, false);
        }

        public static TypeInitializer nonAccessible(String fieldName, Object value) {
            return new ForStaticField<Object>(fieldName, value, true);
        }

        @Override
        public void onLoad(Class<?> type) {
            try {
                Field field = type.getDeclaredField(this.fieldName);
                if (this.makeAccessible) {
                    field.setAccessible(true);
                }
                field.set(STATIC_FIELD, this.value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Could not access field %s on %s", this.fieldName, type), e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException(String.format("There is no field %s defined for %s", this.fieldName, type), e);
            }
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ForStaticField that = (ForStaticField)other;
            return this.makeAccessible == that.makeAccessible && this.fieldName.equals(that.fieldName) && this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.value.hashCode();
            result = 31 * result + (this.makeAccessible ? 1 : 0);
            return result;
        }

        public String toString() {
            return "TypeInitializer.ForStaticField{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + ", makeAccessible=" + this.makeAccessible + '}';
        }
    }

    public static enum NoOp implements TypeInitializer
    {
        INSTANCE;


        @Override
        public void onLoad(Class<?> type) {
        }

        @Override
        public boolean isAlive() {
            return false;
        }
    }
}

