/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationAppender;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.FieldVisitor;

public interface FieldAttributeAppender {
    public void apply(FieldVisitor var1, FieldDescription var2);

    public static class Compound
    implements FieldAttributeAppender {
        private final FieldAttributeAppender[] fieldAttributeAppender;

        public Compound(FieldAttributeAppender ... fieldAttributeAppender) {
            this.fieldAttributeAppender = fieldAttributeAppender;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            for (FieldAttributeAppender fieldAttributeAppender : this.fieldAttributeAppender) {
                fieldAttributeAppender.apply(fieldVisitor, fieldDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.fieldAttributeAppender, ((Compound)other).fieldAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.fieldAttributeAppender);
        }

        public String toString() {
            return "FieldAttributeAppenderCompound{" + Arrays.toString(this.fieldAttributeAppender) + '}';
        }
    }

    public static class ForLoadedField
    implements FieldAttributeAppender,
    Factory {
        private final Field field;

        public ForLoadedField(Field field) {
            this.field = field;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            for (Annotation annotation : this.field.getAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.RUNTIME);
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.field.equals(((ForLoadedField)other).field);
        }

        public int hashCode() {
            return this.field.hashCode();
        }

        public String toString() {
            return "FieldAttributeAppender.ForLoadedField{field=" + this.field + '}';
        }
    }

    public static class ForAnnotation
    implements FieldAttributeAppender,
    Factory {
        private final Annotation[] annotation;

        public ForAnnotation(Annotation ... annotation) {
            this.annotation = annotation;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnField(fieldVisitor));
            for (Annotation annotation : this.annotation) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.annotation, ((ForAnnotation)other).annotation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.annotation);
        }

        public String toString() {
            return "FieldAttributeAppender.ForAnnotation{annotation=" + Arrays.toString(this.annotation) + '}';
        }
    }

    public static interface Factory {
        public FieldAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final Factory[] factory;

            public Compound(Factory ... factory) {
                this.factory = factory;
            }

            @Override
            public FieldAttributeAppender make(TypeDescription typeDescription) {
                FieldAttributeAppender[] fieldAttributeAppender = new FieldAttributeAppender[this.factory.length];
                int index = 0;
                for (Factory factory : this.factory) {
                    fieldAttributeAppender[index++] = factory.make(typeDescription);
                }
                return new net.bytebuddy.instrumentation.attribute.FieldAttributeAppender$Compound(fieldAttributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.factory, ((Compound)other).factory);
            }

            public int hashCode() {
                return Arrays.hashCode(this.factory);
            }

            public String toString() {
                return "FieldAttributeAppender.Factory.Compound{" + Arrays.toString(this.factory) + '}';
            }
        }
    }

    public static enum NoOp implements FieldAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public FieldAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(FieldVisitor fieldVisitor, FieldDescription fieldDescription) {
        }
    }
}

