/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationAppender;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2);

    public static class Compound
    implements MethodAttributeAppender {
        private final MethodAttributeAppender[] methodAttributeAppender;

        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this.methodAttributeAppender = methodAttributeAppender;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppender) {
                methodAttributeAppender.apply(methodVisitor, methodDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.methodAttributeAppender, ((Compound)other).methodAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.methodAttributeAppender);
        }

        public String toString() {
            return "MethodAttributeAppender.Compound{" + Arrays.toString(this.methodAttributeAppender) + '}';
        }
    }

    public static class ForLoadedConstructor
    implements MethodAttributeAppender,
    Factory {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            if (this.constructor.getParameterTypes().length > methodDescription.getParameterTypes().size()) {
                throw new IllegalArgumentException("The constructor " + this.constructor + " has more parameters than the " + "instrumented method " + methodDescription);
            }
            ForInstrumentedMethod.INSTANCE.apply(methodVisitor, new MethodDescription.ForLoadedConstructor(this.constructor));
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.constructor.equals(((ForLoadedConstructor)other).constructor);
        }

        public int hashCode() {
            return this.constructor.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForLoadedConstructor{constructor=" + this.constructor + '}';
        }
    }

    public static class ForLoadedMethod
    implements MethodAttributeAppender,
    Factory {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            if (this.method.getParameterTypes().length > methodDescription.getParameterTypes().size()) {
                throw new IllegalArgumentException("The constructor " + this.method + " has more parameters than the " + "instrumented method " + methodDescription);
            }
            ForInstrumentedMethod.INSTANCE.apply(methodVisitor, new MethodDescription.ForLoadedMethod(this.method));
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.method.equals(((ForLoadedMethod)other).method);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForLoadedMethod{method=" + this.method + '}';
        }
    }

    public static class ForAnnotation
    implements MethodAttributeAppender,
    Factory {
        private final Annotation[] annotation;
        private final Target target;

        public ForAnnotation(Annotation ... annotation) {
            this.annotation = annotation;
            this.target = Target.OnMethod.INSTANCE;
        }

        public ForAnnotation(int parameterIndex, Annotation ... annotation) {
            this.annotation = annotation;
            this.target = new Target.OnMethodParameter(parameterIndex);
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            AnnotationAppender.Default appender = new AnnotationAppender.Default(this.target.make(methodVisitor, methodDescription));
            for (Annotation annotation : this.annotation) {
                appender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.annotation, ((ForAnnotation)other).annotation) && this.target.equals(((ForAnnotation)other).target);
        }

        public int hashCode() {
            return 31 * Arrays.hashCode(this.annotation) + this.target.hashCode();
        }

        public String toString() {
            return "MethodAttributeAppender.ForAnnotation{annotation=" + Arrays.toString(this.annotation) + ", target=" + this.target + '}';
        }

        private static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                public OnMethodParameter(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    if (this.parameterIndex >= methodDescription.getParameterTypes().size()) {
                        throw new IllegalArgumentException("Method " + methodDescription + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter(methodVisitor, this.parameterIndex);
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((OnMethodParameter)other).parameterIndex;
                }

                public int hashCode() {
                    return this.parameterIndex;
                }

                public String toString() {
                    return "Target.OnMethodParameter{parameterIndex=" + this.parameterIndex + '}';
                }
            }

            public static enum OnMethod implements Target
            {
                INSTANCE;


                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    return new AnnotationAppender.Target.OnMethod(methodVisitor);
                }
            }
        }
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final Factory[] factory;

            public Compound(Factory ... factory) {
                this.factory = factory;
            }

            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                MethodAttributeAppender[] methodAttributeAppender = new MethodAttributeAppender[this.factory.length];
                int index = 0;
                for (Factory factory : this.factory) {
                    methodAttributeAppender[index++] = factory.make(typeDescription);
                }
                return new net.bytebuddy.instrumentation.attribute.MethodAttributeAppender$Compound(methodAttributeAppender);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.factory, ((Compound)other).factory);
            }

            public int hashCode() {
                return Arrays.hashCode(this.factory);
            }

            public String toString() {
                return "MethodAttributeAppender.Factory.Compound{" + Arrays.toString(this.factory) + '}';
            }
        }
    }

    public static enum ForInstrumentedMethod implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
            AnnotationAppender.Default methodAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor));
            for (Annotation annotation : methodDescription.getAnnotations()) {
                methodAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
            int i = 0;
            for (Annotation[] annotations : methodDescription.getParameterAnnotations()) {
                AnnotationAppender.Default parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, i++));
                for (Annotation annotation : annotations) {
                    parameterAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
                }
            }
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }
    }

    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription) {
        }
    }
}

