/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationAppender;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface TypeAttributeAppender {
    public void apply(ClassVisitor var1, TypeDescription var2);

    public static class Compound
    implements TypeAttributeAppender {
        private final TypeAttributeAppender[] typeAttributeAppender;

        public Compound(TypeAttributeAppender ... typeAttributeAppender) {
            this.typeAttributeAppender = typeAttributeAppender;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            for (TypeAttributeAppender typeAttributeAppender : this.typeAttributeAppender) {
                typeAttributeAppender.apply(classVisitor, typeDescription);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.typeAttributeAppender, ((Compound)other).typeAttributeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.typeAttributeAppender);
        }

        public String toString() {
            return "TypeAttributeAppender.Compound{" + Arrays.toString(this.typeAttributeAppender) + '}';
        }
    }

    public static class ForLoadedType
    implements TypeAttributeAppender {
        private final Class<?> type;

        public ForLoadedType(Class<?> type) {
            this.type = type;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (Annotation annotation : this.type.getAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.RUNTIME);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.type.equals(((ForLoadedType)other).type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return "TypeAttributeAppender.ForLoadedType{type=" + this.type + '}';
        }
    }

    public static class ForAnnotation
    implements TypeAttributeAppender {
        private final Annotation[] annotation;

        public ForAnnotation(Annotation ... annotation) {
            this.annotation = annotation;
        }

        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (Annotation annotation : this.annotation) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.annotation, ((ForAnnotation)other).annotation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.annotation);
        }

        public String toString() {
            return "TypeAttributeAppender.ForAnnotation{annotation=" + Arrays.toString(this.annotation) + '}';
        }
    }

    public static enum ForSuperType implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
            AnnotationAppender.Default annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnType(classVisitor));
            for (Annotation annotation : typeDescription.getSupertype().getAnnotations()) {
                annotationAppender.append(annotation, AnnotationAppender.AnnotationVisibility.of(annotation));
            }
        }
    }

    public static enum NoOp implements TypeAttributeAppender
    {
        INSTANCE;


        @Override
        public void apply(ClassVisitor classVisitor, TypeDescription typeDescription) {
        }
    }
}

