/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.bytebuddy.jar.asm.AnnotationVisitor;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

public interface AnnotationAppender {
    public AnnotationAppender append(Annotation var1, AnnotationVisibility var2);

    public static class Default
    implements AnnotationAppender {
        private static final String ASM_IGNORE_NAME = null;
        private final Target target;

        public Default(Target target) {
            this.target = target;
        }

        @Override
        public AnnotationAppender append(Annotation annotation, AnnotationVisibility annotationVisibility) {
            if (!annotationVisibility.isSuppressed()) {
                try {
                    this.tryAppend(annotation, annotationVisibility.isVisible());
                }
                catch (InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke method of " + annotation + " reflectively", e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Could not access method of " + annotation, e);
                }
            }
            return this;
        }

        private void tryAppend(Annotation annotation, boolean visible) throws InvocationTargetException, IllegalAccessException {
            this.handle(this.target.visit(Type.getDescriptor(annotation.annotationType()), visible), annotation);
        }

        private void handle(AnnotationVisitor annotationVisitor, Annotation annotation) throws InvocationTargetException, IllegalAccessException {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                this.apply(annotationVisitor, method.getReturnType(), method.getName(), method.invoke((Object)annotation, new Object[0]));
            }
            annotationVisitor.visitEnd();
        }

        private void apply(AnnotationVisitor annotationVisitor, Class<?> valueType, String name, Object value) throws InvocationTargetException, IllegalAccessException {
            if (valueType.isAnnotation()) {
                this.handle(annotationVisitor.visitAnnotation(name, Type.getDescriptor(valueType)), (Annotation)value);
            } else if (valueType.isEnum()) {
                annotationVisitor.visitEnum(name, Type.getDescriptor(valueType), ((Enum)value).name());
            } else if (valueType.isArray()) {
                AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                int length = Array.getLength(value);
                Class<?> componentType = valueType.getComponentType();
                for (int index = 0; index < length; ++index) {
                    this.apply(arrayVisitor, componentType, ASM_IGNORE_NAME, Array.get(value, index));
                }
                arrayVisitor.visitEnd();
            } else if (valueType == Class.class) {
                annotationVisitor.visit(name, Type.getType((Class)value));
            } else {
                annotationVisitor.visit(name, value);
            }
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.target.equals(((Default)other).target);
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return "AnnotationAppender.Default{target=" + this.target + '}';
        }
    }

    public static interface Target {
        public AnnotationVisitor visit(String var1, boolean var2);

        public static class OnField
        implements Target {
            private final FieldVisitor fieldVisitor;

            public OnField(FieldVisitor fieldVisitor) {
                this.fieldVisitor = fieldVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.fieldVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public String toString() {
                return "AnnotationAppender.Target.OnField{fieldVisitor=" + this.fieldVisitor + '}';
            }
        }

        public static class OnMethodParameter
        implements Target {
            private final MethodVisitor methodVisitor;
            private final int parameterIndex;

            public OnMethodParameter(MethodVisitor methodVisitor, int parameterIndex) {
                this.methodVisitor = methodVisitor;
                this.parameterIndex = parameterIndex;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitParameterAnnotation(this.parameterIndex, annotationTypeDescriptor, visible);
            }

            public String toString() {
                return "AnnotationAppender.Target.OnMethodParameter{methodVisitor=" + this.methodVisitor + ", parameterIndex=" + this.parameterIndex + '}';
            }
        }

        public static class OnMethod
        implements Target {
            private final MethodVisitor methodVisitor;

            public OnMethod(MethodVisitor methodVisitor) {
                this.methodVisitor = methodVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.methodVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public String toString() {
                return "AnnotationAppender.Target.OnMethod{methodVisitor=" + this.methodVisitor + '}';
            }
        }

        public static class OnType
        implements Target {
            private final ClassVisitor classVisitor;

            public OnType(ClassVisitor classVisitor) {
                this.classVisitor = classVisitor;
            }

            @Override
            public AnnotationVisitor visit(String annotationTypeDescriptor, boolean visible) {
                return this.classVisitor.visitAnnotation(annotationTypeDescriptor, visible);
            }

            public String toString() {
                return "AnnotationAppender.Target.OnType{classVisitor=" + this.classVisitor + '}';
            }
        }
    }

    public static enum AnnotationVisibility {
        RUNTIME(true, false),
        CLASS_FILE(false, false),
        INVISIBLE(false, true);

        private final boolean visible;
        private final boolean suppressed;

        private AnnotationVisibility(boolean visible, boolean suppressed) {
            this.visible = visible;
            this.suppressed = suppressed;
        }

        public static AnnotationVisibility of(Annotation annotation) {
            Retention retention = annotation.annotationType().getAnnotation(Retention.class);
            if (retention == null || retention.value() == RetentionPolicy.SOURCE) {
                return INVISIBLE;
            }
            if (retention.value() == RetentionPolicy.CLASS) {
                return CLASS_FILE;
            }
            return RUNTIME;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean isSuppressed() {
            return this.suppressed;
        }
    }
}

