/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.field;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import net.bytebuddy.instrumentation.ByteCodeElement;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.type.DeclaredInType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.Type;

public interface FieldDescription
extends ModifierReviewable,
ByteCodeElement,
DeclaredInType,
AnnotatedElement {
    public TypeDescription getFieldType();

    public static class ForLoadedField
    extends AbstractFieldDescription {
        private final Field field;

        public ForLoadedField(Field field) {
            this.field = field;
        }

        @Override
        public TypeDescription getFieldType() {
            return new TypeDescription.ForLoadedType(this.field.getType());
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
            return this.field.isAnnotationPresent(annotationClass);
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.field.getAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.field.getDeclaredAnnotations();
        }

        @Override
        public String getName() {
            return this.field.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getDescriptor(this.field.getType());
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.field.getDeclaringClass());
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.field.isSynthetic();
        }
    }

    public static abstract class AbstractFieldDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements FieldDescription {
        @Override
        public String getInternalName() {
            return this.getName();
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.getPackageName().equals(this.getDeclaringType().getPackageName());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof FieldDescription && this.getName().equals(((FieldDescription)other).getName()) && this.getDeclaringType().equals(((FieldDescription)other).getDeclaringType());
        }

        public int hashCode() {
            return (this.getDeclaringType().getInternalName() + "." + this.getName()).hashCode();
        }
    }
}

