/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode;

import java.util.Arrays;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface ByteCodeAppender {
    public boolean appendsCode();

    public Size apply(MethodVisitor var1, Instrumentation.Context var2, MethodDescription var3);

    public static class Compound
    implements ByteCodeAppender {
        private final ByteCodeAppender[] byteCodeAppender;

        public Compound(ByteCodeAppender ... byteCodeAppender) {
            this.byteCodeAppender = byteCodeAppender;
        }

        @Override
        public boolean appendsCode() {
            for (ByteCodeAppender byteCodeAppender : this.byteCodeAppender) {
                if (!byteCodeAppender.appendsCode()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            Size size = new Size(0, instrumentedMethod.getStackSize());
            for (ByteCodeAppender byteCodeAppender : this.byteCodeAppender) {
                size = size.merge(byteCodeAppender.apply(methodVisitor, instrumentationContext, instrumentedMethod));
            }
            return size;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.byteCodeAppender, ((Compound)other).byteCodeAppender);
        }

        public int hashCode() {
            return Arrays.hashCode(this.byteCodeAppender);
        }

        public String toString() {
            return "ByteCodeAppender.Compound{" + Arrays.toString(this.byteCodeAppender) + '}';
        }
    }

    public static class Size {
        private final int operandStackSize;
        private final int localVariableSize;

        public Size(int operandStackSize, int localVariableSize) {
            this.operandStackSize = operandStackSize;
            this.localVariableSize = localVariableSize;
        }

        public int getOperandStackSize() {
            return this.operandStackSize;
        }

        public int getLocalVariableSize() {
            return this.localVariableSize;
        }

        public Size merge(Size other) {
            return new Size(Math.max(this.operandStackSize, other.operandStackSize), Math.max(this.localVariableSize, other.localVariableSize));
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.localVariableSize == ((Size)other).localVariableSize && this.operandStackSize == ((Size)other).operandStackSize;
        }

        public int hashCode() {
            return 31 * this.operandStackSize + this.localVariableSize;
        }

        public String toString() {
            return "ByteCodeAppender.Size{operandStackSize=" + this.operandStackSize + ", localVariableSize=" + this.localVariableSize + '}';
        }
    }
}

