/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum Duplication implements StackManipulation
{
    ZERO(StackSize.ZERO, 0),
    SINGLE(StackSize.SINGLE, 89),
    DOUBLE(StackSize.DOUBLE, 92);

    private final StackManipulation.Size size;
    private final int opcode;

    private Duplication(StackSize stackSize, int opcode) {
        this.size = stackSize.toIncreasingSize();
        this.opcode = opcode;
    }

    public static StackManipulation duplicate(TypeDescription typeDescription) {
        switch (typeDescription.getStackSize()) {
            case SINGLE: {
                return SINGLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case ZERO: {
                return ZERO;
            }
        }
        throw new AssertionError();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitInsn(this.opcode);
        return this.size;
    }
}

