/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ByteArrayClassLoader
extends ClassLoader {
    protected final Map<String, byte[]> typeDefinitions;
    protected final PersistenceHandler persistenceHandler;
    protected final AccessControlContext accessControlContext;
    protected final ProtectionDomain protectionDomain;

    public ByteArrayClassLoader(ClassLoader parent, Map<String, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler) {
        super(parent);
        this.typeDefinitions = new HashMap<String, byte[]>(typeDefinitions);
        this.protectionDomain = protectionDomain;
        this.persistenceHandler = persistenceHandler;
        this.accessControlContext = AccessController.getContext();
    }

    public static ClassLoader of(ClassLoader parent, Map<TypeDescription, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, boolean childFirst) {
        HashMap<String, byte[]> rawTypeDefinitions = new HashMap<String, byte[]>(typeDefinitions.size());
        for (Map.Entry<TypeDescription, byte[]> entry : typeDefinitions.entrySet()) {
            rawTypeDefinitions.put(entry.getKey().getName(), entry.getValue());
        }
        return childFirst ? new ChildFirst(parent, rawTypeDefinitions, protectionDomain, persistenceHandler) : new ByteArrayClassLoader(parent, rawTypeDefinitions, protectionDomain, persistenceHandler);
    }

    public static Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler, boolean childFirst) {
        LinkedHashMap loadedTypes = new LinkedHashMap(types.size());
        classLoader = ByteArrayClassLoader.of(classLoader, types, protectionDomain, persistenceHandler, childFirst);
        for (TypeDescription typeDescription : types.keySet()) {
            try {
                loadedTypes.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load class " + typeDescription, e);
            }
        }
        return loadedTypes;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new ClassLoadingAction(name), this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream != null) {
            return inputStream;
        }
        return this.persistenceHandler.inputStream(name, this.typeDefinitions);
    }

    public String toString() {
        return "ByteArrayClassLoader{parent=" + this.getParent() + ", typeDefinitions=" + this.typeDefinitions + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", protectionDomain=" + this.protectionDomain + ", accessControlContext=" + this.accessControlContext + '}';
    }

    private class ClassLoadingAction
    implements PrivilegedExceptionAction<Class<?>> {
        private static final int FROM_BEGINNING = 0;
        private final String name;

        private ClassLoadingAction(String name) {
            this.name = name;
        }

        @Override
        public Class<?> run() throws ClassNotFoundException {
            byte[] javaType = ByteArrayClassLoader.this.persistenceHandler.lookup(this.name, ByteArrayClassLoader.this.typeDefinitions);
            if (javaType != null) {
                return ByteArrayClassLoader.this.defineClass(this.name, javaType, 0, javaType.length, ByteArrayClassLoader.this.protectionDomain);
            }
            throw new ClassNotFoundException(this.name);
        }

        public String toString() {
            return "ByteArrayClassLoader.ClassLoadingAction{classLoader=" + ByteArrayClassLoader.this + ", name='" + this.name + "'}";
        }
    }

    public static class ChildFirst
    extends ByteArrayClassLoader {
        private static final String CLASS_FILE_SUFFIX = ".class";

        public ChildFirst(ClassLoader parent, Map<String, byte[]> typeDefinitions, ProtectionDomain protectionDomain, PersistenceHandler persistenceHandler) {
            super(parent, typeDefinitions, protectionDomain, persistenceHandler);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> type = this.findLoadedClass(name);
            if (type != null) {
                return type;
            }
            try {
                type = this.findClass(name);
                if (resolve) {
                    this.resolveClass(type);
                }
                return type;
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream inputStream = this.persistenceHandler.inputStream(name, this.typeDefinitions);
            if (inputStream != null || !this.persistenceHandler.isManifest() && this.isSelfDefined(name)) {
                return inputStream;
            }
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException ignored) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isSelfDefined(String resourceName) {
            if (!resourceName.endsWith(CLASS_FILE_SUFFIX)) {
                return false;
            }
            ChildFirst childFirst = this;
            synchronized (childFirst) {
                String typeName = resourceName.replace('/', '.').substring(0, resourceName.length() - CLASS_FILE_SUFFIX.length());
                if (this.typeDefinitions.containsKey(typeName)) {
                    return true;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl10 : MonitorExitStatement: MONITOREXIT : var2_2
                Class<?> loadedClass = this.findLoadedClass(typeName);
                return loadedClass != null && loadedClass.getClassLoader() == this;
            }
        }

        @Override
        public String toString() {
            return "ByteArrayClassLoader.ChildFirst{parent=" + this.getParent() + ", typeDefinitions=" + this.typeDefinitions + ", protectionDomain=" + this.protectionDomain + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", accessControlContext=" + this.accessControlContext + '}';
        }
    }

    public static enum PersistenceHandler {
        MANIFEST(true){

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.get(name);
            }

            @Override
            protected InputStream inputStream(String resourceName, Map<String, byte[]> typeDefinitions) {
                if (!resourceName.endsWith(PersistenceHandler.CLASS_FILE_SUFFIX)) {
                    return null;
                }
                byte[] binaryRepresentation = typeDefinitions.get(resourceName.replace('/', '.').substring(0, resourceName.length() - PersistenceHandler.CLASS_FILE_SUFFIX.length()));
                return binaryRepresentation == null ? null : new ByteArrayInputStream(binaryRepresentation);
            }
        }
        ,
        LATENT(false){

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.remove(name);
            }

            @Override
            protected InputStream inputStream(String resourceName, Map<String, byte[]> typeDefinitions) {
                return null;
            }
        };

        private static final String CLASS_FILE_SUFFIX = ".class";
        private final boolean manifest;

        private PersistenceHandler(boolean manifest) {
            this.manifest = manifest;
        }

        public boolean isManifest() {
            return this.manifest;
        }

        protected abstract byte[] lookup(String var1, Map<String, byte[]> var2);

        protected abstract InputStream inputStream(String var1, Map<String, byte[]> var2);
    }
}

