/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ClassLoaderByteArrayInjector {
    private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;
    private static final int FROM_BEGINNING = 0;
    private static final ReflectionStore REFLECTION_STORE;
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;

    public ClassLoaderByteArrayInjector(ClassLoader classLoader) {
        this(classLoader, DEFAULT_PROTECTION_DOMAIN);
    }

    public ClassLoaderByteArrayInjector(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        this.classLoader = classLoader;
        this.protectionDomain = protectionDomain;
    }

    public static Map<TypeDescription, Class<?>> inject(ClassLoaderByteArrayInjector classLoaderByteArrayInjector, Map<TypeDescription, byte[]> types) {
        LinkedHashMap loadedTypes = new LinkedHashMap(types.size());
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            loadedTypes.put(entry.getKey(), classLoaderByteArrayInjector.inject(entry.getKey().getName(), entry.getValue()));
        }
        return loadedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> inject(String name, byte[] binaryRepresentation) {
        try {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                Class type = (Class)REFLECTION_STORE.getFindLoadedClassMethod().invoke((Object)this.classLoader, name);
                if (type != null) {
                    return type;
                }
                return (Class)REFLECTION_STORE.getLoadByteArrayMethod().invoke((Object)this.classLoader, name, binaryRepresentation, 0, binaryRepresentation.length, this.protectionDomain);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access injection method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception on invoking loader method", e.getCause());
        }
    }

    public String toString() {
        return "ClassLoaderByteArrayInjector{classLoader=" + this.classLoader + '}';
    }

    static {
        ReflectionStore reflectionStore;
        DEFAULT_PROTECTION_DOMAIN = null;
        try {
            Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClassMethod.setAccessible(true);
            Method loadByteArrayMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            loadByteArrayMethod.setAccessible(true);
            reflectionStore = new ReflectionStore.Resolved(findLoadedClassMethod, loadByteArrayMethod);
        }
        catch (Exception e) {
            reflectionStore = new ReflectionStore.Faulty(e);
        }
        REFLECTION_STORE = reflectionStore;
    }

    private static interface ReflectionStore {
        public Method getFindLoadedClassMethod();

        public Method getLoadByteArrayMethod();

        public static class Faulty
        implements ReflectionStore {
            private final RuntimeException exception;

            private Faulty(Exception exception) {
                this.exception = new RuntimeException("Could not execute reflective lookup", exception);
            }

            @Override
            public Method getFindLoadedClassMethod() {
                throw this.exception;
            }

            @Override
            public Method getLoadByteArrayMethod() {
                throw this.exception;
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Faulty{exception=" + this.exception + '}';
            }
        }

        public static class Resolved
        implements ReflectionStore {
            private final Method findLoadedClassMethod;
            private final Method loadByteArrayMethod;

            private Resolved(Method findLoadedClassMethod, Method loadByteArrayMethod) {
                this.findLoadedClassMethod = findLoadedClassMethod;
                this.loadByteArrayMethod = loadByteArrayMethod;
            }

            @Override
            public Method getFindLoadedClassMethod() {
                return this.findLoadedClassMethod;
            }

            @Override
            public Method getLoadByteArrayMethod() {
                return this.loadByteArrayMethod;
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Resolved{findLoadedClassMethod=" + this.findLoadedClassMethod + ", loadByteArrayMethod=" + this.loadByteArrayMethod + '}';
            }
        }
    }
}

