/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.bytebuddy.dynamic.ClassLoadingStrategy;
import net.bytebuddy.dynamic.loading.ClassLoaderByteArrayInjector;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ClassReloadingStrategy
implements ClassLoadingStrategy {
    private static final int BUFFER_SIZE = 1024;
    private static final int END_OF_STREAM = -1;
    private static final int FIRST_INDEX = 0;
    private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
    private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
    private static final Object STATIC_METHOD = null;
    private static final String CLASS_FILE_EXTENSION = ".class";
    private final Instrumentation instrumentation;
    private final Engine engine;

    public ClassReloadingStrategy(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
        if (instrumentation.isRedefineClassesSupported()) {
            this.engine = Engine.REDEFINITION;
        } else if (instrumentation.isRetransformClassesSupported()) {
            this.engine = Engine.RETRANSFORMATION;
        } else {
            throw new IllegalArgumentException("Instrumentation does not support class redefinition: " + instrumentation);
        }
    }

    public ClassReloadingStrategy(Instrumentation instrumentation, Engine engine) {
        this.instrumentation = instrumentation;
        this.engine = engine;
    }

    public static ClassReloadingStrategy fromInstalledAgent() {
        try {
            return new ClassReloadingStrategy((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]));
        }
        catch (Exception e) {
            throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", e);
        }
    }

    private static byte[] drain(InputStream inputStream) throws IOException {
        int currentRead;
        LinkedList<byte[]> previousBytes = new LinkedList<byte[]>();
        byte[] currentArray = new byte[1024];
        int currentIndex = 0;
        do {
            if ((currentIndex += (currentRead = inputStream.read(currentArray, currentIndex, 1024 - currentIndex)) > 0 ? currentRead : 0) != 1024) continue;
            previousBytes.add(currentArray);
            currentArray = new byte[1024];
            currentIndex = 0;
        } while (currentRead != -1);
        byte[] result = new byte[previousBytes.size() * 1024 + currentIndex];
        int arrayIndex = 0;
        for (byte[] previousByte : previousBytes) {
            System.arraycopy(previousByte, 0, result, arrayIndex++ * 1024, 1024);
        }
        System.arraycopy(currentArray, 0, result, arrayIndex * 1024, currentIndex);
        return result;
    }

    @Override
    public Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types) {
        HashMap loadedClasses = new HashMap(types.size());
        ClassLoaderByteArrayInjector classLoaderByteArrayInjector = new ClassLoaderByteArrayInjector(classLoader);
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap(types.size());
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            Class<?> type;
            try {
                type = classLoader.loadClass(entry.getKey().getName());
                classDefinitions.put(type, new ClassDefinition(type, entry.getValue()));
            }
            catch (ClassNotFoundException ignored) {
                type = classLoaderByteArrayInjector.inject(entry.getKey().getName(), entry.getValue());
            }
            loadedClasses.put(entry.getKey(), type);
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not locate classes for redefinition", e);
        }
        catch (UnmodifiableClassException e) {
            throw new IllegalStateException("Cannot redefine specified class", e);
        }
        return loadedClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassReloadingStrategy reset(Class<?> ... type) {
        ConcurrentHashMap classDefinitions = new ConcurrentHashMap(type.length);
        try {
            for (Class<?> aType : type) {
                InputStream inputStream = aType.getClassLoader().getResourceAsStream(aType.getName().replace('.', '/') + CLASS_FILE_EXTENSION);
                try {
                    classDefinitions.put(aType, new ClassDefinition(aType, ClassReloadingStrategy.drain(inputStream)));
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception while resetting types " + Arrays.toString(type), e);
        }
        try {
            this.engine.apply(this.instrumentation, classDefinitions);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot locate types " + Arrays.toString(type), e);
        }
        catch (UnmodifiableClassException e) {
            throw new IllegalStateException("Cannot reset types " + Arrays.toString(type), e);
        }
        return this;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.engine == ((ClassReloadingStrategy)other).engine && this.instrumentation.equals(((ClassReloadingStrategy)other).instrumentation);
    }

    public int hashCode() {
        return 31 * this.instrumentation.hashCode() + this.engine.hashCode();
    }

    public String toString() {
        return "ClassReloadingStrategy{instrumentation=" + this.instrumentation + ", engine=" + (Object)((Object)this.engine) + '}';
    }

    public static enum Engine {
        REDEFINITION(true){

            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException, ClassNotFoundException {
                instrumentation.redefineClasses(classDefinitions.values().toArray(new ClassDefinition[classDefinitions.size()]));
            }
        }
        ,
        RETRANSFORMATION(false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void apply(Instrumentation instrumentation, Map<Class<?>, ClassDefinition> classDefinitions) throws UnmodifiableClassException {
                ClassRedefinitionTransformer classRedefinitionTransformer = new ClassRedefinitionTransformer(classDefinitions);
                Instrumentation instrumentation2 = instrumentation;
                synchronized (instrumentation2) {
                    instrumentation.addTransformer(classRedefinitionTransformer, true);
                    try {
                        instrumentation.retransformClasses(classDefinitions.keySet().toArray(new Class[classDefinitions.size()]));
                    }
                    finally {
                        instrumentation.removeTransformer(classRedefinitionTransformer);
                    }
                }
                classRedefinitionTransformer.assertTransformation();
            }
        };

        private static final boolean REDEFINE_CLASSES = true;
        private final boolean redefinition;

        private Engine(boolean redefinition) {
            this.redefinition = redefinition;
        }

        protected abstract void apply(Instrumentation var1, Map<Class<?>, ClassDefinition> var2) throws UnmodifiableClassException, ClassNotFoundException;

        public boolean isRedefinition() {
            return this.redefinition;
        }

        private static class ClassRedefinitionTransformer
        implements ClassFileTransformer {
            private final Map<Class<?>, ClassDefinition> redefinedClasses;

            private ClassRedefinitionTransformer(Map<Class<?>, ClassDefinition> redefinedClasses) {
                this.redefinedClasses = redefinedClasses;
            }

            @Override
            public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
                ClassDefinition redefinedClass = this.redefinedClasses.remove(classBeingRedefined);
                if (redefinedClass == null) {
                    throw new IllegalArgumentException("Encountered class without redefinition information");
                }
                return redefinedClass.getDefinitionClassFile();
            }

            public void assertTransformation() {
                if (this.redefinedClasses.size() > 0) {
                    throw new IllegalStateException("Could not transform: " + this.redefinedClasses.keySet());
                }
            }

            public String toString() {
                return "ClassReloadingStrategy.Engine.ClassRedefinitionTransformer{redefinedClasses=" + this.redefinedClasses + '}';
            }
        }
    }
}

