/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.io.InputStream;
import java.util.Arrays;
import net.bytebuddy.instrumentation.type.TypeDescription;

public interface ClassFileLocator {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public InputStream classFileFor(TypeDescription var1);

    public static class Compound
    implements ClassFileLocator {
        private final ClassFileLocator[] classFileLocator;

        public Compound(ClassFileLocator ... classFileLocator) {
            this.classFileLocator = classFileLocator;
        }

        public static ClassFileLocator makeDefault() {
            return new Compound(Default.ATTACHED, Default.CLASS_PATH);
        }

        @Override
        public InputStream classFileFor(TypeDescription typeDescription) {
            for (ClassFileLocator classFileLocator : this.classFileLocator) {
                InputStream inputStream = classFileLocator.classFileFor(typeDescription);
                if (inputStream == null) continue;
                return inputStream;
            }
            return null;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.classFileLocator, ((Compound)other).classFileLocator);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classFileLocator);
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocator=" + Arrays.toString(this.classFileLocator) + '}';
        }
    }

    public static enum Default implements ClassFileLocator
    {
        CLASS_PATH{

            @Override
            public InputStream classFileFor(TypeDescription typeDescription) {
                return ClassLoader.getSystemResourceAsStream(typeDescription.getInternalName() + ClassFileLocator.CLASS_FILE_EXTENSION);
            }
        }
        ,
        ATTACHED{

            @Override
            public InputStream classFileFor(TypeDescription typeDescription) {
                ClassLoader classLoader = typeDescription.getClassLoader();
                return classLoader != null ? classLoader.getResourceAsStream(typeDescription.getInternalName() + ClassFileLocator.CLASS_FILE_EXTENSION) : null;
            }
        };

    }
}

