/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.TypeProxy;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface Super {
    public Instantiation strategy() default Instantiation.CONSTRUCTOR;

    public boolean ignoreFinalizer() default true;

    public boolean serializableProxy() default false;

    public Class<?>[] constructorParameters() default {};

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<Super>
    {
        INSTANCE;


        @Override
        public Class<Super> getHandledType() {
            return Super.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(Super annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            TypeDescription parameterType = (TypeDescription)target.getParameterTypes().get(targetParameterIndex);
            if (source.isStatic() || !instrumentationTarget.getTypeDescription().isAssignableTo(parameterType)) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            return new MethodDelegationBinder.ParameterBinding.Anonymous(annotation.strategy().proxyFor(parameterType, instrumentationTarget, annotation));
        }
    }

    public static enum Instantiation {
        CONSTRUCTOR{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Instrumentation.Target instrumentationTarget, Super annotation) {
                ArrayList<TypeDescription> typeDescriptions = new ArrayList<TypeDescription>(annotation.constructorParameters().length);
                for (Class<?> constructorParameter : annotation.constructorParameters()) {
                    typeDescriptions.add(constructorParameter == TargetType.class ? TargetType.DESCRIPTION : new TypeDescription.ForLoadedType(constructorParameter));
                }
                return new TypeProxy.ByConstructor(parameterType, instrumentationTarget, typeDescriptions, annotation.ignoreFinalizer(), annotation.serializableProxy());
            }
        }
        ,
        UNSAFE{

            @Override
            protected StackManipulation proxyFor(TypeDescription parameterType, Instrumentation.Target instrumentationTarget, Super annotation) {
                return new TypeProxy.ByReflectionFactory(parameterType, instrumentationTarget, annotation.ignoreFinalizer(), annotation.serializableProxy());
            }
        };


        protected abstract StackManipulation proxyFor(TypeDescription var1, Instrumentation.Target var2, Super var3);
    }
}

