/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.collection;

import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.collection.CollectionFactory;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.IntegerConstant;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public class ArrayFactory
implements CollectionFactory {
    private final TypeDescription componentType;
    private final ArrayCreator arrayCreator;
    private final StackManipulation.Size sizeDecrease;

    protected ArrayFactory(TypeDescription componentType, ArrayCreator arrayCreator) {
        this.componentType = componentType;
        this.arrayCreator = arrayCreator;
        this.sizeDecrease = StackSize.DOUBLE.toDecreasingSize().aggregate(componentType.getStackSize().toDecreasingSize());
    }

    public static ArrayFactory targeting(TypeDescription componentType) {
        return new ArrayFactory(componentType, ArrayFactory.makeArrayCreatorFor(componentType));
    }

    private static ArrayCreator makeArrayCreatorFor(TypeDescription componentType) {
        if (componentType.isPrimitive()) {
            if (componentType.represents(Boolean.TYPE)) {
                return ArrayCreator.Primitive.BOOLEAN;
            }
            if (componentType.represents(Byte.TYPE)) {
                return ArrayCreator.Primitive.BYTE;
            }
            if (componentType.represents(Short.TYPE)) {
                return ArrayCreator.Primitive.SHORT;
            }
            if (componentType.represents(Character.TYPE)) {
                return ArrayCreator.Primitive.CHARACTER;
            }
            if (componentType.represents(Integer.TYPE)) {
                return ArrayCreator.Primitive.INTEGER;
            }
            if (componentType.represents(Long.TYPE)) {
                return ArrayCreator.Primitive.LONG;
            }
            if (componentType.represents(Float.TYPE)) {
                return ArrayCreator.Primitive.FLOAT;
            }
            if (componentType.represents(Double.TYPE)) {
                return ArrayCreator.Primitive.DOUBLE;
            }
            throw new IllegalArgumentException("Cannot create array of type " + componentType);
        }
        return new ArrayCreator.Reference(componentType);
    }

    @Override
    public StackManipulation withValues(List<StackManipulation> stackManipulations) {
        return new ArrayStackManipulation(stackManipulations);
    }

    @Override
    public TypeDescription getComponentType() {
        return this.componentType;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.componentType.equals(((ArrayFactory)other).componentType);
    }

    public int hashCode() {
        return this.componentType.hashCode();
    }

    public String toString() {
        return "ArrayFactory{componentType=" + this.componentType + ", arrayCreator=" + this.arrayCreator + ", sizeDecrease=" + this.sizeDecrease + '}';
    }

    private class ArrayStackManipulation
    implements StackManipulation {
        private final List<StackManipulation> stackManipulations;

        public ArrayStackManipulation(List<StackManipulation> stackManipulations) {
            this.stackManipulations = stackManipulations;
        }

        @Override
        public boolean isValid() {
            for (StackManipulation stackManipulation : this.stackManipulations) {
                if (stackManipulation.isValid()) continue;
                return false;
            }
            return ArrayFactory.this.arrayCreator.isValid();
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            StackManipulation.Size size = IntegerConstant.forValue(this.stackManipulations.size()).apply(methodVisitor, instrumentationContext);
            size = size.aggregate(ArrayFactory.this.arrayCreator.apply(methodVisitor, instrumentationContext));
            int index = 0;
            for (StackManipulation stackManipulation : this.stackManipulations) {
                methodVisitor.visitInsn(89);
                size = size.aggregate(StackSize.SINGLE.toIncreasingSize());
                size = size.aggregate(IntegerConstant.forValue(index++).apply(methodVisitor, instrumentationContext));
                size = size.aggregate(stackManipulation.apply(methodVisitor, instrumentationContext));
                methodVisitor.visitInsn(ArrayFactory.this.arrayCreator.getStorageOpcode());
                size = size.aggregate(ArrayFactory.this.sizeDecrease);
            }
            return size;
        }

        private ArrayFactory getArrayFactory() {
            return ArrayFactory.this;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && ArrayFactory.this.equals(((ArrayStackManipulation)other).getArrayFactory()) && this.stackManipulations.equals(((ArrayStackManipulation)other).stackManipulations);
        }

        public int hashCode() {
            return this.stackManipulations.hashCode();
        }

        public String toString() {
            return "ArrayFactory.ArrayStackManipulation{arrayFactory=" + ArrayFactory.this + "stackManipulations=" + this.stackManipulations + '}';
        }
    }

    protected static interface ArrayCreator
    extends StackManipulation {
        public static final StackManipulation.Size ARRAY_CREATION_SIZE_CHANGE = StackSize.ZERO.toDecreasingSize();

        public int getStorageOpcode();

        public static class Reference
        implements ArrayCreator {
            private final String internalTypeName;

            private Reference(TypeDescription referenceType) {
                this.internalTypeName = referenceType.getInternalName();
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                methodVisitor.visitTypeInsn(189, this.internalTypeName);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            @Override
            public int getStorageOpcode() {
                return 83;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.internalTypeName.equals(((Reference)other).internalTypeName);
            }

            public int hashCode() {
                return this.internalTypeName.hashCode();
            }

            public String toString() {
                return "ArrayFactory.ArrayCreator.Reference{internalTypeName='" + this.internalTypeName + '\'' + '}';
            }
        }

        public static enum Primitive implements ArrayCreator
        {
            BOOLEAN(4, 84),
            BYTE(8, 84),
            SHORT(9, 86),
            CHARACTER(5, 85),
            INTEGER(10, 79),
            LONG(11, 80),
            FLOAT(6, 81),
            DOUBLE(7, 82);

            private final int creationOpcode;
            private final int storageOpcode;

            private Primitive(int creationOpcode, int storageOpcode) {
                this.creationOpcode = creationOpcode;
                this.storageOpcode = storageOpcode;
            }

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
                methodVisitor.visitIntInsn(188, this.creationOpcode);
                return ARRAY_CREATION_SIZE_CHANGE;
            }

            @Override
            public int getStorageOpcode() {
                return this.storageOpcode;
            }
        }
    }
}

