/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy;

import java.util.Collection;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.modifier.SyntheticState;
import net.bytebuddy.modifier.TypeManifestation;
import net.bytebuddy.modifier.Visibility;
import net.bytebuddy.utility.RandomString;

public interface NamingStrategy {
    public String name(UnnamedType var1);

    public static class Fixed
    implements NamingStrategy {
        private final String name;

        public Fixed(String name) {
            this.name = name;
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return this.name;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.name.equals(((Fixed)other).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "NamingStrategy.Fixed{name='" + this.name + '\'' + '}';
        }
    }

    public static class PrefixingRandom
    implements NamingStrategy {
        private final String prefix;
        private final RandomString randomString;

        public PrefixingRandom(String prefix) {
            this.prefix = prefix;
            this.randomString = new RandomString();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            return String.format("%s.%s$%s", this.prefix, unnamedType.getSuperClass().getName(), this.randomString.nextString());
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prefix.equals(((PrefixingRandom)other).prefix);
        }

        public int hashCode() {
            return this.prefix.hashCode();
        }

        public String toString() {
            return "NamingStrategy.PrefixingRandom{prefix='" + this.prefix + '\'' + ", randomString=" + this.randomString + '}';
        }
    }

    public static class SuffixingRandom
    implements NamingStrategy {
        private static final String JAVA_PACKAGE = "java.";
        private static final String BYTE_BUDDY_RENAME_PACKAGE = "net.bytebuddy.renamed";
        private final String suffix;
        private final String javaLangPackagePrefix;
        private final RandomString randomString;

        public SuffixingRandom(String suffix) {
            this(suffix, BYTE_BUDDY_RENAME_PACKAGE);
        }

        public SuffixingRandom(String suffix, String javaLangPackagePrefix) {
            this.suffix = suffix;
            this.javaLangPackagePrefix = javaLangPackagePrefix;
            this.randomString = new RandomString();
        }

        @Override
        public String name(UnnamedType unnamedType) {
            String superClassName = unnamedType.getSuperClass().getName();
            if (superClassName.startsWith(JAVA_PACKAGE) || unnamedType.getSuperClass().isSealed()) {
                superClassName = this.javaLangPackagePrefix + "." + superClassName;
            }
            return String.format("%s$%s$%s", superClassName, this.suffix, this.randomString.nextString());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SuffixingRandom that = (SuffixingRandom)other;
            return this.javaLangPackagePrefix.equals(that.javaLangPackagePrefix) && this.suffix.equals(that.suffix);
        }

        public int hashCode() {
            int result = this.suffix.hashCode();
            result = 31 * result + this.javaLangPackagePrefix.hashCode();
            return result;
        }

        public String toString() {
            return "NamingStrategy.SuffixingRandom{suffix='" + this.suffix + '\'' + ", javaLangPackagePrefix='" + this.javaLangPackagePrefix + '\'' + ", randomString=" + this.randomString + '}';
        }
    }

    public static interface UnnamedType {
        public TypeDescription getSuperClass();

        public Collection<TypeDescription> getDeclaredInterfaces();

        public Visibility getVisibility();

        public TypeManifestation getTypeManifestation();

        public SyntheticState getSyntheticState();

        public ClassFileVersion getClassFileVersion();

        public static class Default
        implements UnnamedType {
            private final TypeDescription superClass;
            private final List<TypeDescription> interfaces;
            private final int modifiers;
            private final ClassFileVersion classFileVersion;

            public Default(TypeDescription superClass, List<TypeDescription> interfaces, int modifiers, ClassFileVersion classFileVersion) {
                this.superClass = superClass;
                this.interfaces = interfaces;
                this.modifiers = modifiers;
                this.classFileVersion = classFileVersion;
            }

            @Override
            public TypeDescription getSuperClass() {
                return this.superClass;
            }

            public List<TypeDescription> getDeclaredInterfaces() {
                return this.interfaces;
            }

            @Override
            public Visibility getVisibility() {
                switch (this.modifiers & 7) {
                    case 1: {
                        return Visibility.PUBLIC;
                    }
                    case 4: {
                        return Visibility.PROTECTED;
                    }
                    case 2: {
                        return Visibility.PRIVATE;
                    }
                    case 0: {
                        return Visibility.PACKAGE_PRIVATE;
                    }
                }
                throw new IllegalStateException("Ambiguous modifier: " + this.modifiers);
            }

            @Override
            public TypeManifestation getTypeManifestation() {
                if ((this.modifiers & 0x10) != 0) {
                    return (this.modifiers & 0x4000) != 0 ? TypeManifestation.ENUM : TypeManifestation.FINAL;
                }
                if ((this.modifiers & 0x200) != 0) {
                    return TypeManifestation.INTERFACE;
                }
                if ((this.modifiers & 0x400) != 0) {
                    return (this.modifiers & 0x4000) != 0 ? TypeManifestation.ABSTRACT_ENUM : TypeManifestation.ABSTRACT;
                }
                return (this.modifiers & 0x4000) != 0 ? TypeManifestation.ENUM : TypeManifestation.PLAIN;
            }

            @Override
            public SyntheticState getSyntheticState() {
                return SyntheticState.is((this.modifiers & 0x1000) != 0);
            }

            @Override
            public ClassFileVersion getClassFileVersion() {
                return this.classFileVersion;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Default aDefault = (Default)other;
                return this.modifiers == aDefault.modifiers && this.classFileVersion.equals(aDefault.classFileVersion) && this.interfaces.equals(aDefault.interfaces) && this.superClass.equals(aDefault.superClass);
            }

            public int hashCode() {
                int result = this.superClass.hashCode();
                result = 31 * result + this.interfaces.hashCode();
                result = 31 * result + this.modifiers;
                result = 31 * result + this.classFileVersion.hashCode();
                return result;
            }

            public String toString() {
                return "NamingStrategy.UnnamedType.Default{superClass=" + this.superClass + ", interfaces=" + this.interfaces + ", modifiers=" + this.modifiers + ", classFileVersion=" + this.classFileVersion + '}';
            }
        }
    }
}

