/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ByteArrayClassLoader
extends ClassLoader {
    protected final Map<String, byte[]> typeDefinitions;
    protected final PersistenceHandler persistenceHandler;
    protected final AccessControlContext accessControlContext;

    public ByteArrayClassLoader(ClassLoader parent, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
        super(parent);
        this.typeDefinitions = new HashMap<String, byte[]>(typeDefinitions);
        this.persistenceHandler = persistenceHandler;
        this.accessControlContext = AccessController.getContext();
    }

    public static ClassLoader of(ClassLoader parent, Map<TypeDescription, byte[]> typeDefinitions, PersistenceHandler persistenceHandler, boolean childFirst) {
        HashMap<String, byte[]> rawTypeDefinitions = new HashMap<String, byte[]>(typeDefinitions.size());
        for (Map.Entry<TypeDescription, byte[]> entry : typeDefinitions.entrySet()) {
            rawTypeDefinitions.put(entry.getKey().getName(), entry.getValue());
        }
        return childFirst ? new ChildFirst(parent, rawTypeDefinitions, persistenceHandler) : new ByteArrayClassLoader(parent, rawTypeDefinitions, persistenceHandler);
    }

    public static Map<TypeDescription, Class<?>> load(ClassLoader classLoader, Map<TypeDescription, byte[]> types, PersistenceHandler persistenceHandler, boolean childFirst) {
        LinkedHashMap loadedTypes = new LinkedHashMap(types.size());
        classLoader = ByteArrayClassLoader.of(classLoader, types, persistenceHandler, childFirst);
        for (TypeDescription typeDescription : types.keySet()) {
            try {
                loadedTypes.put(typeDescription, classLoader.loadClass(typeDescription.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Cannot load class " + typeDescription, e);
            }
        }
        return loadedTypes;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new ClassLoadingAction(name), this.accessControlContext);
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getCause();
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream inputStream = super.getResourceAsStream(name);
        if (inputStream != null) {
            return inputStream;
        }
        return this.persistenceHandler.inputStream(name, this.typeDefinitions);
    }

    public String toString() {
        return "ByteArrayClassLoader{parent=" + this.getParent() + ", typeDefinitions=" + this.typeDefinitions + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", accessControlContext=" + this.accessControlContext + '}';
    }

    private class ClassLoadingAction
    implements PrivilegedExceptionAction<Class<?>> {
        private final String name;

        private ClassLoadingAction(String name) {
            this.name = name;
        }

        @Override
        public Class<?> run() throws ClassNotFoundException {
            byte[] javaType = ByteArrayClassLoader.this.persistenceHandler.lookup(this.name, ByteArrayClassLoader.this.typeDefinitions);
            if (javaType != null) {
                return ByteArrayClassLoader.this.defineClass(this.name, javaType, 0, javaType.length);
            }
            throw new ClassNotFoundException(this.name);
        }

        public String toString() {
            return "ByteArrayClassLoader.ClassLoadingAction{name='" + this.name + "'}";
        }
    }

    public static class ChildFirst
    extends ByteArrayClassLoader {
        public ChildFirst(ClassLoader parent, Map<String, byte[]> typeDefinitions, PersistenceHandler persistenceHandler) {
            super(parent, typeDefinitions, persistenceHandler);
        }

        @Override
        protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> type = this.findLoadedClass(name);
            if (type != null) {
                return type;
            }
            try {
                type = this.findClass(name);
                if (resolve) {
                    this.resolveClass(type);
                }
                return type;
            }
            catch (ClassNotFoundException e) {
                return super.loadClass(name, resolve);
            }
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream inputStream = this.persistenceHandler.inputStream(name, this.typeDefinitions);
            if (inputStream != null) {
                return inputStream;
            }
            URL url = this.getResource(name);
            try {
                return url != null ? url.openStream() : null;
            }
            catch (IOException ignored) {
                return null;
            }
        }

        @Override
        public String toString() {
            return "ByteArrayClassLoader.ChildFirst{parent=" + this.getParent() + ", typeDefinitions=" + this.typeDefinitions + ", persistenceHandler=" + (Object)((Object)this.persistenceHandler) + ", accessControlContext=" + this.accessControlContext + '}';
        }
    }

    public static enum PersistenceHandler {
        MANIFEST{

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.get(name);
            }

            @Override
            protected InputStream inputStream(String name, Map<String, byte[]> typeDefinitions) {
                byte[] binaryRepresentation = typeDefinitions.get(name);
                return binaryRepresentation == null ? null : new ByteArrayInputStream(binaryRepresentation);
            }
        }
        ,
        LATENT{

            @Override
            protected byte[] lookup(String name, Map<String, byte[]> typeDefinitions) {
                return typeDefinitions.remove(name);
            }

            @Override
            protected InputStream inputStream(String name, Map<String, byte[]> typeDefinitions) {
                return null;
            }
        };


        protected abstract byte[] lookup(String var1, Map<String, byte[]> var2);

        protected abstract InputStream inputStream(String var1, Map<String, byte[]> var2);
    }
}

