/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassLoaderByteArrayInjector {
    private static final int FROM_BEGINNING = 0;
    private static final ReflectionStore REFLECTION_STORE;
    private final ClassLoader classLoader;

    public ClassLoaderByteArrayInjector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> inject(String name, byte[] binaryRepresentation) {
        try {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                Class type = (Class)REFLECTION_STORE.getFindLoadedClassMethod().invoke((Object)this.classLoader, name);
                if (type != null) {
                    return type;
                }
                return (Class)REFLECTION_STORE.getLoadByteArrayMethod().invoke((Object)this.classLoader, name, binaryRepresentation, 0, binaryRepresentation.length);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access injection method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception on invoking loader method", e.getCause());
        }
    }

    public String toString() {
        return "ClassLoaderByteArrayInjector{classLoader=" + this.classLoader + '}';
    }

    static {
        ReflectionStore reflectionStore;
        try {
            Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClassMethod.setAccessible(true);
            Method loadByteArrayMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            loadByteArrayMethod.setAccessible(true);
            reflectionStore = new ReflectionStore.Resolved(findLoadedClassMethod, loadByteArrayMethod);
        }
        catch (Exception e) {
            reflectionStore = new ReflectionStore.Faulty(e);
        }
        REFLECTION_STORE = reflectionStore;
    }

    private static interface ReflectionStore {
        public Method getFindLoadedClassMethod();

        public Method getLoadByteArrayMethod();

        public static class Faulty
        implements ReflectionStore {
            private final RuntimeException exception;

            private Faulty(Exception exception) {
                this.exception = new RuntimeException("Could not execute reflective lookup", exception);
            }

            @Override
            public Method getFindLoadedClassMethod() {
                throw this.exception;
            }

            @Override
            public Method getLoadByteArrayMethod() {
                throw this.exception;
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Faulty{exception=" + this.exception + '}';
            }
        }

        public static class Resolved
        implements ReflectionStore {
            private final Method findLoadedClassMethod;
            private final Method loadByteArrayMethod;

            private Resolved(Method findLoadedClassMethod, Method loadByteArrayMethod) {
                this.findLoadedClassMethod = findLoadedClassMethod;
                this.loadByteArrayMethod = loadByteArrayMethod;
            }

            @Override
            public Method getFindLoadedClassMethod() {
                return this.findLoadedClassMethod;
            }

            @Override
            public Method getLoadByteArrayMethod() {
                return this.loadByteArrayMethod;
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Resolved{findLoadedClassMethod=" + this.findLoadedClassMethod + ", loadByteArrayMethod=" + this.loadByteArrayMethod + '}';
            }
        }
    }
}

