/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.utility.ByteBuddyCommons;

public class InlineInstrumentedType
extends InstrumentedType.AbstractBase {
    private final TypeDescription levelType;
    private final String name;
    private final int modifiers;
    private final List<TypeDescription> interfaces;

    public InlineInstrumentedType(ClassFileVersion classFileVersion, TypeDescription levelType, List<TypeDescription> interfaces, int modifiers, NamingStrategy namingStrategy) {
        super(LoadedTypeInitializer.NoOp.INSTANCE, levelType.getName(), levelType.getDeclaredFields(), levelType.getDeclaredMethods());
        this.levelType = levelType;
        this.modifiers = modifiers;
        HashSet<TypeDescription> interfaceTypes = new HashSet<TypeDescription>(levelType.getInterfaces());
        interfaceTypes.addAll(interfaces);
        this.interfaces = new ArrayList<TypeDescription>(interfaceTypes);
        this.name = ByteBuddyCommons.isValidTypeName(namingStrategy.name(new NamingStrategy.UnnamedType.Default(levelType.getSupertype(), interfaces, modifiers, classFileVersion)));
    }

    protected InlineInstrumentedType(TypeDescription levelType, String name, List<TypeDescription> interfaces, int modifiers, List<? extends FieldDescription> fieldDescriptions, List<? extends MethodDescription> methodDescriptions, LoadedTypeInitializer loadedTypeInitializer) {
        super(loadedTypeInitializer, name, fieldDescriptions, methodDescriptions);
        this.levelType = levelType;
        this.name = name;
        this.modifiers = modifiers;
        this.interfaces = interfaces;
    }

    @Override
    public InstrumentedType withField(String internalName, TypeDescription fieldType, int modifiers) {
        InstrumentedType.AbstractBase.FieldToken additionalField = new InstrumentedType.AbstractBase.FieldToken((InstrumentedType.AbstractBase)this, internalName, fieldType, modifiers);
        if (this.fieldDescriptions.contains(additionalField)) {
            throw new IllegalArgumentException("Field " + additionalField + " is already defined on " + this);
        }
        ArrayList<InstrumentedType.AbstractBase.FieldToken> fieldDescriptions = new ArrayList<InstrumentedType.AbstractBase.FieldToken>(this.fieldDescriptions);
        fieldDescriptions.add(additionalField);
        return new InlineInstrumentedType(this.levelType, this.name, this.interfaces, this.modifiers, fieldDescriptions, this.methodDescriptions, this.loadedTypeInitializer);
    }

    @Override
    public InstrumentedType withMethod(String internalName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
        InstrumentedType.AbstractBase.MethodToken additionalMethod = new InstrumentedType.AbstractBase.MethodToken(this, internalName, returnType, parameterTypes, exceptionTypes, modifiers);
        if (this.methodDescriptions.contains(additionalMethod)) {
            throw new IllegalArgumentException("Method " + additionalMethod + " is already defined on " + this);
        }
        ArrayList<InstrumentedType.AbstractBase.MethodToken> methodDescriptions = new ArrayList<InstrumentedType.AbstractBase.MethodToken>(this.methodDescriptions);
        methodDescriptions.add(additionalMethod);
        return new InlineInstrumentedType(this.levelType, this.name, this.interfaces, this.modifiers, this.fieldDescriptions, methodDescriptions, this.loadedTypeInitializer);
    }

    @Override
    public InstrumentedType withInitializer(LoadedTypeInitializer loadedTypeInitializer) {
        return new InlineInstrumentedType(this.levelType, this.name, this.interfaces, this.modifiers, this.fieldDescriptions, this.methodDescriptions, new LoadedTypeInitializer.Compound(this.loadedTypeInitializer, loadedTypeInitializer));
    }

    @Override
    public TypeDescription detach() {
        return new InlineInstrumentedType(this.levelType, this.name, this.interfaces, this.modifiers, this.fieldDescriptions, this.methodDescriptions, LoadedTypeInitializer.NoOp.INSTANCE);
    }

    @Override
    public TypeDescription getSupertype() {
        return this.levelType.getSupertype();
    }

    @Override
    public TypeList getInterfaces() {
        return new TypeList.Explicit(this.interfaces);
    }

    @Override
    public boolean isSealed() {
        return this.levelType.isSealed();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.levelType.getClassLoader();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return "InlineInstrumentedType{levelType=" + this.levelType + ", name='" + this.name + '\'' + ", modifiers=" + this.modifiers + ", interfaces=" + this.interfaces + '}';
    }
}

