/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public class DefaultMethodCall
implements Instrumentation {
    private final List<TypeDescription> prioritizedInterfaces;

    protected DefaultMethodCall(List<TypeDescription> prioritizedInterfaces) {
        for (TypeDescription typeDescription : prioritizedInterfaces) {
            ByteBuddyCommons.isInterface(typeDescription);
        }
        this.prioritizedInterfaces = prioritizedInterfaces;
    }

    public static Instrumentation prioritize(Class<?> ... prioritizedInterface) {
        return new DefaultMethodCall(new TypeList.ForLoadedType(prioritizedInterface));
    }

    public static Instrumentation unambiguousOnly() {
        return new DefaultMethodCall(new TypeList.Empty());
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        return new Appender(instrumentationTarget, this.filterRelevant(instrumentationTarget.getTypeDescription()));
    }

    private List<TypeDescription> filterRelevant(TypeDescription typeDescription) {
        ArrayList<TypeDescription> filtered = new ArrayList<TypeDescription>(this.prioritizedInterfaces.size());
        HashSet<TypeDescription> relevant = new HashSet<TypeDescription>(typeDescription.getInterfaces());
        for (TypeDescription prioritizedInterface : this.prioritizedInterfaces) {
            if (!relevant.remove(prioritizedInterface)) continue;
            filtered.add(prioritizedInterface);
        }
        return filtered;
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.prioritizedInterfaces.equals(((DefaultMethodCall)other).prioritizedInterfaces);
    }

    public int hashCode() {
        return this.prioritizedInterfaces.hashCode();
    }

    public String toString() {
        return "DefaultMethodCall{prioritizedInterfaces=" + this.prioritizedInterfaces + '}';
    }

    private static class Appender
    implements ByteCodeAppender {
        private final Instrumentation.Target instrumentationTarget;
        private final List<TypeDescription> prioritizedInterfaces;
        private final Set<TypeDescription> nonPrioritizedInterfaces;

        public Appender(Instrumentation.Target instrumentationTarget, List<TypeDescription> prioritizedInterfaces) {
            this.instrumentationTarget = instrumentationTarget;
            this.prioritizedInterfaces = prioritizedInterfaces;
            this.nonPrioritizedInterfaces = new HashSet<TypeDescription>(instrumentationTarget.getTypeDescription().getInterfaces());
            this.nonPrioritizedInterfaces.removeAll(prioritizedInterfaces);
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation defaultMethodInvocation = this.locateDefault(instrumentedMethod);
            if (!defaultMethodInvocation.isValid()) {
                throw new IllegalArgumentException("Cannot invoke default method on " + instrumentedMethod);
            }
            StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), defaultMethodInvocation, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        private StackManipulation locateDefault(MethodDescription methodDescription) {
            String uniqueMethodSignature = methodDescription.getUniqueSignature();
            Instrumentation.SpecialMethodInvocation specialMethodInvocation = Instrumentation.SpecialMethodInvocation.Illegal.INSTANCE;
            for (TypeDescription typeDescription : this.prioritizedInterfaces) {
                specialMethodInvocation = this.instrumentationTarget.invokeDefault(typeDescription, uniqueMethodSignature);
                if (!specialMethodInvocation.isValid()) continue;
                return specialMethodInvocation;
            }
            for (TypeDescription typeDescription : this.nonPrioritizedInterfaces) {
                Instrumentation.SpecialMethodInvocation other = this.instrumentationTarget.invokeDefault(typeDescription, uniqueMethodSignature);
                if (specialMethodInvocation.isValid() && other.isValid()) {
                    throw new IllegalArgumentException(methodDescription + " has an ambiguous default method with " + other.getMethodDescription() + " and " + specialMethodInvocation.getMethodDescription());
                }
                specialMethodInvocation = other;
            }
            return specialMethodInvocation;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.prioritizedInterfaces.equals(((Appender)other).prioritizedInterfaces) && this.instrumentationTarget.equals(((Appender)other).instrumentationTarget);
        }

        public int hashCode() {
            return 31 * this.instrumentationTarget.hashCode() + this.prioritizedInterfaces.hashCode();
        }

        public String toString() {
            return "DefaultMethodCall.Appender{instrumentationTarget=" + this.instrumentationTarget + ", prioritizedInterfaces=" + this.prioritizedInterfaces + ", nonPrioritizedInterfaces=" + this.nonPrioritizedInterfaces + '}';
        }
    }
}

