/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DoubleConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.FloatConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.IntegerConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.LongConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.NullConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class FixedValue
implements Instrumentation {
    protected final Assigner assigner;
    protected final boolean considerRuntimeType;

    protected FixedValue(Assigner assigner, boolean considerRuntimeType) {
        this.assigner = assigner;
        this.considerRuntimeType = considerRuntimeType;
    }

    public static Instrumentation nullValue() {
        return FixedValue.value(null);
    }

    public static AssignerConfigurable value(Object fixedValue) {
        if (fixedValue == null) {
            return new ForPoolValue((StackManipulation)NullConstant.INSTANCE, Object.class, FixedValue.defaultAssigner(), true);
        }
        Class<?> type = fixedValue.getClass();
        if (type == String.class) {
            return new ForPoolValue((StackManipulation)new TextConstant((String)fixedValue), String.class, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Boolean.class) {
            return new ForPoolValue(IntegerConstant.forValue((Boolean)fixedValue), Boolean.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Byte.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Byte)fixedValue).byteValue()), Byte.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Short.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Short)fixedValue).shortValue()), Short.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Character.class) {
            return new ForPoolValue(IntegerConstant.forValue(((Character)fixedValue).charValue()), Character.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Integer.class) {
            return new ForPoolValue(IntegerConstant.forValue((Integer)fixedValue), Integer.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Long.class) {
            return new ForPoolValue(LongConstant.forValue((Long)fixedValue), Long.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Float.class) {
            return new ForPoolValue(FloatConstant.forValue(((Float)fixedValue).floatValue()), Float.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        if (type == Double.class) {
            return new ForPoolValue(DoubleConstant.forValue((Double)fixedValue), Double.TYPE, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
        }
        return FixedValue.reference(fixedValue);
    }

    public static AssignerConfigurable reference(Object fixedValue) {
        if (fixedValue == null) {
            return new ForPoolValue((StackManipulation)NullConstant.INSTANCE, Object.class, FixedValue.defaultAssigner(), true);
        }
        return new ForStaticField(fixedValue, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
    }

    public static AssignerConfigurable reference(Object fixedValue, String fieldName) {
        if (fixedValue == null) {
            throw new IllegalArgumentException("The fixed value must not be null");
        }
        return new ForStaticField(fieldName, fixedValue, FixedValue.defaultAssigner(), FixedValue.defaultConsiderRuntimeType());
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE), false);
    }

    private static boolean defaultConsiderRuntimeType() {
        return false;
    }

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod, TypeDescription fixedValueType, StackManipulation valueLoadingInstruction) {
        StackManipulation assignment = this.assigner.assign(fixedValueType, instrumentedMethod.getReturnType(), this.considerRuntimeType);
        if (!assignment.isValid()) {
            throw new IllegalArgumentException("Cannot return value of type " + fixedValueType + " for " + instrumentedMethod);
        }
        StackManipulation.Size stackSize = new StackManipulation.Compound(valueLoadingInstruction, assignment, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FixedValue that = (FixedValue)other;
        return this.considerRuntimeType == that.considerRuntimeType && this.assigner.equals(that.assigner);
    }

    public int hashCode() {
        return 31 * this.assigner.hashCode() + (this.considerRuntimeType ? 1 : 0);
    }

    protected static class ForStaticField
    extends FixedValue
    implements AssignerConfigurable {
        private static final String PREFIX = "fixedValue";
        private final String fieldName;
        private final Object fixedValue;
        private final TypeDescription fieldType;

        protected ForStaticField(Object fixedValue, Assigner assigner, boolean considerRuntimeType) {
            this(String.format("%s$%d", PREFIX, Math.abs(fixedValue.hashCode())), fixedValue, assigner, considerRuntimeType);
        }

        protected ForStaticField(String fieldName, Object fixedValue, Assigner assigner, boolean considerRuntimeType) {
            super(assigner, considerRuntimeType);
            this.fieldName = fieldName;
            this.fixedValue = fixedValue;
            this.fieldType = new TypeDescription.ForLoadedType(fixedValue.getClass());
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner, boolean considerRuntimeType) {
            return new ForStaticField(this.fieldName, this.fixedValue, assigner, considerRuntimeType);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, this.fieldType, 4106).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.fixedValue));
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new StaticFieldByteCodeAppender(instrumentationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForStaticField)other).fieldName) && this.fixedValue.equals(((ForStaticField)other).fixedValue) && super.equals(other);
        }

        @Override
        public int hashCode() {
            return 961 * super.hashCode() + 31 * this.fieldName.hashCode() + this.fixedValue.hashCode();
        }

        public String toString() {
            return "FixedValue.ForStaticField{fieldName='" + this.fieldName + '\'' + ", fixedValue=" + this.fixedValue + ", assigner=" + this.assigner + ", considerRuntimeType=" + this.considerRuntimeType + '}';
        }

        private class StaticFieldByteCodeAppender
        implements ByteCodeAppender {
            private final StackManipulation fieldGetAccess;

            private StaticFieldByteCodeAppender(TypeDescription instrumentedType) {
                this.fieldGetAccess = FieldAccess.forField(instrumentedType.getDeclaredFields().named(ForStaticField.this.fieldName)).getter();
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForStaticField.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, ForStaticField.this.fieldType, this.fieldGetAccess);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldGetAccess.equals(((StaticFieldByteCodeAppender)other).fieldGetAccess);
            }

            public int hashCode() {
                return this.fieldGetAccess.hashCode();
            }

            public String toString() {
                return "StaticFieldByteCodeAppender{fieldGetAccess=" + this.fieldGetAccess + '}';
            }
        }
    }

    protected static class ForPoolValue
    extends FixedValue
    implements AssignerConfigurable,
    ByteCodeAppender {
        private final StackManipulation valueLoadInstruction;
        private final TypeDescription loadedType;

        protected ForPoolValue(StackManipulation valueLoadInstruction, Class<?> loadedType, Assigner assigner, boolean considerRuntimeType) {
            this(valueLoadInstruction, new TypeDescription.ForLoadedType(loadedType), assigner, considerRuntimeType);
        }

        private ForPoolValue(StackManipulation valueLoadInstruction, TypeDescription loadedType, Assigner assigner, boolean considerRuntimeType) {
            super(assigner, considerRuntimeType);
            this.valueLoadInstruction = valueLoadInstruction;
            this.loadedType = loadedType;
        }

        @Override
        public Instrumentation withAssigner(Assigner assigner, boolean considerRuntimeType) {
            return new ForPoolValue(this.valueLoadInstruction, this.loadedType, assigner, considerRuntimeType);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return this;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            return this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.loadedType, this.valueLoadInstruction);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.loadedType.equals(((ForPoolValue)other).loadedType) && this.valueLoadInstruction.equals(((ForPoolValue)other).valueLoadInstruction) && super.equals(other);
        }

        @Override
        public int hashCode() {
            return 961 * super.hashCode() + 31 * this.valueLoadInstruction.hashCode() + this.loadedType.hashCode();
        }

        public String toString() {
            return "FixedValue.ForPoolValue{valueLoadInstruction=" + this.valueLoadInstruction + ", loadedType=" + this.loadedType + ", assigner=" + this.assigner + ", considerRuntimeType=" + this.considerRuntimeType + '}';
        }
    }

    public static interface AssignerConfigurable
    extends Instrumentation {
        public Instrumentation withAssigner(Assigner var1, boolean var2);
    }
}

