/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.AuxiliaryType;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.RandomString;

public interface Instrumentation {
    public InstrumentedType prepare(InstrumentedType var1);

    public ByteCodeAppender appender(Target var1);

    public static class Compound
    implements Instrumentation {
        private final Instrumentation[] instrumentation;

        public Compound(Instrumentation ... instrumentation) {
            this.instrumentation = instrumentation;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            for (Instrumentation instrumentation : this.instrumentation) {
                instrumentedType = instrumentation.prepare(instrumentedType);
            }
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target instrumentationTarget) {
            ByteCodeAppender[] byteCodeAppender = new ByteCodeAppender[this.instrumentation.length];
            int index = 0;
            for (Instrumentation instrumentation : this.instrumentation) {
                byteCodeAppender[index++] = instrumentation.appender(instrumentationTarget);
            }
            return new ByteCodeAppender.Compound(byteCodeAppender);
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Arrays.equals(this.instrumentation, ((Compound)o).instrumentation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.instrumentation);
        }

        public String toString() {
            return "Compound{" + Arrays.toString(this.instrumentation) + '}';
        }
    }

    public static interface Context {
        public TypeDescription register(AuxiliaryType var1);

        public FieldDescription cache(StackManipulation var1, TypeDescription var2);

        public static class Default
        implements ExtractableView,
        AuxiliaryType.MethodAccessorFactory {
            private static final String DEFAULT_ACCESSOR_METHOD_SUFFIX = "accessor";
            private static final String DEFAULT_FIELD_CACHE_PREFIX = "cachedValue";
            private final TypeDescription instrumentedType;
            private final ClassFileVersion classFileVersion;
            private final String accessorMethodSuffix;
            private final String fieldCachePrefix;
            private final AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy;
            private final Map<SpecialMethodInvocation, MethodDescription> registeredAccessorMethods;
            private final Map<MethodDescription, TypeWriter.MethodPool.Entry> accessorMethodEntries;
            private final Map<AuxiliaryType, DynamicType> auxiliaryTypes;
            private final Map<FieldCacheEntry, FieldDescription> registeredFieldCacheEntries;
            private final RandomString randomString;
            private boolean canRegisterFieldCache;

            public Default(TypeDescription instrumentedType, ClassFileVersion classFileVersion) {
                this(instrumentedType, classFileVersion, DEFAULT_ACCESSOR_METHOD_SUFFIX, DEFAULT_FIELD_CACHE_PREFIX, new AuxiliaryTypeNamingStrategy.SuffixingRandom(DEFAULT_ACCESSOR_METHOD_SUFFIX));
            }

            public Default(TypeDescription instrumentedType, ClassFileVersion classFileVersion, String accessorMethodSuffix, String fieldCachePrefix, AuxiliaryTypeNamingStrategy auxiliaryTypeNamingStrategy) {
                this.instrumentedType = instrumentedType;
                this.classFileVersion = classFileVersion;
                this.accessorMethodSuffix = accessorMethodSuffix;
                this.fieldCachePrefix = fieldCachePrefix;
                this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
                this.registeredAccessorMethods = new HashMap<SpecialMethodInvocation, MethodDescription>();
                this.accessorMethodEntries = new HashMap<MethodDescription, TypeWriter.MethodPool.Entry>();
                this.auxiliaryTypes = new HashMap<AuxiliaryType, DynamicType>();
                this.registeredFieldCacheEntries = new HashMap<FieldCacheEntry, FieldDescription>();
                this.randomString = new RandomString();
                this.canRegisterFieldCache = true;
            }

            @Override
            public MethodDescription registerAccessorFor(SpecialMethodInvocation specialMethodInvocation) {
                MethodDescription accessorMethod = this.registeredAccessorMethods.get(specialMethodInvocation);
                if (accessorMethod == null) {
                    String name = String.format("%s$%s$%s", specialMethodInvocation.getMethodDescription().getInternalName(), this.accessorMethodSuffix, this.randomString.nextString());
                    accessorMethod = new MethodDescription.Latent(name, this.instrumentedType, specialMethodInvocation.getMethodDescription().getReturnType(), specialMethodInvocation.getMethodDescription().getParameterTypes(), 0x1010 | (specialMethodInvocation.getMethodDescription().isStatic() ? 8 : 0), specialMethodInvocation.getMethodDescription().getExceptionTypes());
                    this.registerAccessor(specialMethodInvocation, accessorMethod);
                }
                return accessorMethod;
            }

            private void registerAccessor(SpecialMethodInvocation specialMethodInvocation, MethodDescription accessorMethod) {
                this.registeredAccessorMethods.put(specialMethodInvocation, accessorMethod);
                this.accessorMethodEntries.put(accessorMethod, new AccessorMethodDelegation(specialMethodInvocation));
            }

            @Override
            public TypeDescription register(AuxiliaryType auxiliaryType) {
                DynamicType dynamicType = this.auxiliaryTypes.get(auxiliaryType);
                if (dynamicType == null) {
                    dynamicType = auxiliaryType.make(this.auxiliaryTypeNamingStrategy.name(auxiliaryType, this.instrumentedType), this.classFileVersion, this);
                    this.auxiliaryTypes.put(auxiliaryType, dynamicType);
                }
                return dynamicType.getTypeDescription();
            }

            @Override
            public List<DynamicType> getRegisteredAuxiliaryTypes() {
                return new ArrayList<DynamicType>(this.auxiliaryTypes.values());
            }

            @Override
            public FieldDescription cache(StackManipulation fieldValue, TypeDescription fieldType) {
                FieldCacheEntry fieldCacheEntry = new FieldCacheEntry(fieldValue, fieldType);
                FieldDescription fieldCache = this.registeredFieldCacheEntries.get(fieldCacheEntry);
                if (fieldCache != null) {
                    return fieldCache;
                }
                this.validateFieldCacheAccessibility();
                fieldCache = new FieldDescription.Latent(String.format("%s$%s", this.fieldCachePrefix, this.randomString.nextString()), this.instrumentedType, fieldType, 4120);
                this.registeredFieldCacheEntries.put(fieldCacheEntry, fieldCache);
                return fieldCache;
            }

            private void validateFieldCacheAccessibility() {
                if (!this.canRegisterFieldCache) {
                    throw new IllegalStateException("A field cache cannot be registered during or after the creation of a type initializer - instead, the field cache should be registered in the method that requires the cached value");
                }
            }

            @Override
            public void drain(ClassVisitor classVisitor, TypeWriter.MethodPool methodPool, ExtractableView.InjectedCode injectedCode) {
                this.canRegisterFieldCache = false;
                MethodDescription typeInitializer = MethodDescription.Latent.typeInitializerOf(this.instrumentedType);
                FieldCacheAppender.resolve(methodPool.target(typeInitializer), this.registeredFieldCacheEntries, injectedCode).apply(classVisitor, this, typeInitializer);
                for (FieldDescription fieldDescription : this.registeredFieldCacheEntries.values()) {
                    classVisitor.visitField(fieldDescription.getModifiers(), fieldDescription.getInternalName(), fieldDescription.getDescriptor(), fieldDescription.getGenericSignature(), null).visitEnd();
                }
                for (Map.Entry entry : this.accessorMethodEntries.entrySet()) {
                    ((TypeWriter.MethodPool.Entry)entry.getValue()).apply(classVisitor, this, (MethodDescription)entry.getKey());
                }
            }

            public String toString() {
                return "TypeExtensionDelegate{instrumentedType=" + this.instrumentedType + ", classFileVersion=" + this.classFileVersion + ", accessorMethodSuffix='" + this.accessorMethodSuffix + '\'' + ", fieldCachePrefix='" + this.fieldCachePrefix + '\'' + ", auxiliaryTypeNamingStrategy=" + this.auxiliaryTypeNamingStrategy + ", registeredAccessorMethods=" + this.registeredAccessorMethods + ", accessorMethodEntries=" + this.accessorMethodEntries + ", auxiliaryTypes=" + this.auxiliaryTypes + ", registeredFieldCacheEntries=" + this.registeredFieldCacheEntries + ", randomString=" + this.randomString + ", canRegisterFieldCache=" + this.canRegisterFieldCache + '}';
            }

            private static class AccessorMethodDelegation
            implements TypeWriter.MethodPool.Entry,
            ByteCodeAppender {
                private final StackManipulation accessorMethodInvocation;

                private AccessorMethodDelegation(StackManipulation accessorMethodInvocation) {
                    this.accessorMethodInvocation = accessorMethodInvocation;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public boolean appendsCode() {
                    return true;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context instrumentationContext, MethodDescription instrumentedMethod) {
                    StackManipulation.Size stackSize = new StackManipulation.Compound(MethodVariableAccess.loadThisReferenceAndArguments(instrumentedMethod), this.accessorMethodInvocation, MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                @Override
                public void apply(ClassVisitor classVisitor, Context instrumentationContext, MethodDescription methodDescription) {
                    MethodVisitor methodVisitor = classVisitor.visitMethod(methodDescription.getModifiers(), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getGenericSignature(), methodDescription.getExceptionTypes().toInternalNames());
                    methodVisitor.visitCode();
                    ByteCodeAppender.Size size = this.apply(methodVisitor, instrumentationContext, methodDescription);
                    methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    methodVisitor.visitEnd();
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return MethodAttributeAppender.NoOp.INSTANCE;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.accessorMethodInvocation.equals(((AccessorMethodDelegation)other).accessorMethodInvocation);
                }

                public int hashCode() {
                    return this.accessorMethodInvocation.hashCode();
                }

                public String toString() {
                    return "TypeExtensionDelegate.AccessorMethodDelegation{accessorMethodInvocation=" + this.accessorMethodInvocation + '}';
                }
            }

            private static class FieldCacheEntry {
                private final StackManipulation fieldValue;
                private final TypeDescription fieldType;

                private FieldCacheEntry(StackManipulation fieldValue, TypeDescription fieldType) {
                    this.fieldValue = fieldValue;
                    this.fieldType = fieldType;
                }

                public StackManipulation getFieldValue() {
                    return this.fieldValue;
                }

                public TypeDescription getFieldType() {
                    return this.fieldType;
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.fieldType.equals(((FieldCacheEntry)other).fieldType) && this.fieldValue.equals(((FieldCacheEntry)other).fieldValue);
                }

                public int hashCode() {
                    return 31 * this.fieldValue.hashCode() + this.fieldType.hashCode();
                }

                public String toString() {
                    return "TypeExtensionDelegate.FieldCacheEntry{fieldValue=" + this.fieldValue + ", fieldType=" + this.fieldType + '}';
                }
            }

            private static class FieldCacheAppender
            implements ByteCodeAppender {
                private final Map<FieldCacheEntry, FieldDescription> registeredFieldCacheEntries;

                private FieldCacheAppender(Map<FieldCacheEntry, FieldDescription> registeredFieldCacheEntries) {
                    this.registeredFieldCacheEntries = registeredFieldCacheEntries;
                }

                public static TypeWriter.MethodPool.Entry resolve(TypeWriter.MethodPool.Entry originalEntry, Map<FieldCacheEntry, FieldDescription> registeredFieldCacheEntries, ExtractableView.InjectedCode injectedCode) {
                    boolean defineMethod = originalEntry.isDefineMethod();
                    boolean injectCode = injectedCode.isInjected();
                    return registeredFieldCacheEntries.size() == 0 && !injectCode ? originalEntry : new TypeWriter.MethodPool.Entry.Simple(new ByteCodeAppender.Compound(new FieldCacheAppender(registeredFieldCacheEntries), new ByteCodeAppender.Simple(injectCode ? injectedCode.getInjectedCode() : StackManipulation.LegalTrivial.INSTANCE), defineMethod && originalEntry.getByteCodeAppender().appendsCode() ? originalEntry.getByteCodeAppender() : new ByteCodeAppender.Simple(MethodReturn.VOID)), defineMethod ? originalEntry.getAttributeAppender() : MethodAttributeAppender.NoOp.INSTANCE);
                }

                @Override
                public boolean appendsCode() {
                    return this.registeredFieldCacheEntries.size() > 0;
                }

                @Override
                public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context instrumentationContext, MethodDescription instrumentedMethod) {
                    StackManipulation[] fieldInitialization = new StackManipulation[this.registeredFieldCacheEntries.size()];
                    int currentIndex = 0;
                    for (Map.Entry<FieldCacheEntry, FieldDescription> entry : this.registeredFieldCacheEntries.entrySet()) {
                        fieldInitialization[currentIndex++] = new StackManipulation.Compound(entry.getKey().getFieldValue(), FieldAccess.forField(entry.getValue()).putter());
                    }
                    StackManipulation.Size stackSize = new StackManipulation.Compound(fieldInitialization).apply(methodVisitor, instrumentationContext);
                    return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.registeredFieldCacheEntries.equals(((FieldCacheAppender)other).registeredFieldCacheEntries);
                }

                public int hashCode() {
                    return this.registeredFieldCacheEntries.hashCode();
                }

                public String toString() {
                    return "TypeExtensionDelegate.FieldCacheAppender{registeredFieldCacheEntries=" + this.registeredFieldCacheEntries + '}';
                }
            }

            public static interface AuxiliaryTypeNamingStrategy {
                public String name(AuxiliaryType var1, TypeDescription var2);

                public static class SuffixingRandom
                implements AuxiliaryTypeNamingStrategy {
                    private final String suffix;
                    private final RandomString randomString;

                    public SuffixingRandom(String suffix) {
                        this.suffix = suffix;
                        this.randomString = new RandomString();
                    }

                    @Override
                    public String name(AuxiliaryType auxiliaryType, TypeDescription instrumentedType) {
                        return String.format("%s$%s$%s", instrumentedType.getName(), this.suffix, this.randomString.nextString());
                    }

                    public boolean equals(Object other) {
                        return this == other || other != null && this.getClass() == other.getClass() && this.suffix.equals(((SuffixingRandom)other).suffix);
                    }

                    public int hashCode() {
                        return this.suffix.hashCode();
                    }

                    public String toString() {
                        return "TypeExtensionDelegate.AuxiliaryTypeNamingStrategySuffixingRandom{suffix='" + this.suffix + '\'' + '}';
                    }
                }
            }
        }

        public static interface ExtractableView
        extends Context {
            public static final int FIELD_CACHE_MODIFIER = 4120;

            public List<DynamicType> getRegisteredAuxiliaryTypes();

            public void drain(ClassVisitor var1, TypeWriter.MethodPool var2, InjectedCode var3);

            public static interface InjectedCode {
                public StackManipulation getInjectedCode();

                public boolean isInjected();

                public static enum None implements InjectedCode
                {
                    INSTANCE;


                    @Override
                    public StackManipulation getInjectedCode() {
                        throw new IllegalStateException();
                    }

                    @Override
                    public boolean isInjected() {
                        return false;
                    }
                }
            }
        }
    }

    public static interface Target {
        public TypeDescription getTypeDescription();

        public TypeDescription getOriginType();

        public SpecialMethodInvocation invokeSuper(MethodDescription var1, MethodLookup var2);

        public SpecialMethodInvocation invokeDefault(TypeDescription var1, String var2);

        public static abstract class AbstractBase
        implements Target {
            protected final TypeDescription typeDescription;
            protected final Map<String, MethodDescription> invokableMethods;
            protected final Map<TypeDescription, Map<String, MethodDescription>> defaultMethods;
            protected final BridgeMethodResolver bridgeMethodResolver;

            protected AbstractBase(MethodLookupEngine.Finding finding, BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                this.bridgeMethodResolver = bridgeMethodResolverFactory.make(finding.getInvokableMethods());
                this.typeDescription = finding.getTypeDescription();
                this.invokableMethods = new HashMap<String, MethodDescription>(finding.getInvokableMethods().size());
                for (MethodDescription methodDescription : finding.getInvokableMethods()) {
                    this.invokableMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                }
                this.defaultMethods = new HashMap<TypeDescription, Map<String, MethodDescription>>(finding.getInvokableDefaultMethods().size());
                for (Map.Entry entry : finding.getInvokableDefaultMethods().entrySet()) {
                    HashMap<String, MethodDescription> defaultMethods = new HashMap<String, MethodDescription>(((Set)entry.getValue()).size());
                    for (MethodDescription methodDescription : (Set)entry.getValue()) {
                        defaultMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                    }
                    this.defaultMethods.put((TypeDescription)entry.getKey(), (Map<String, MethodDescription>)defaultMethods);
                }
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public SpecialMethodInvocation invokeSuper(MethodDescription methodDescription, MethodLookup methodLookup) {
                return this.invokeSuper(methodLookup.resolve(methodDescription, this.invokableMethods, this.bridgeMethodResolver));
            }

            protected abstract SpecialMethodInvocation invokeSuper(MethodDescription var1);

            @Override
            public SpecialMethodInvocation invokeDefault(TypeDescription targetType, String uniqueMethodSignature) {
                MethodDescription defaultMethod;
                Map<String, MethodDescription> defaultMethods = this.defaultMethods.get(targetType);
                if (defaultMethods != null && (defaultMethod = defaultMethods.get(uniqueMethodSignature)) != null) {
                    return SpecialMethodInvocation.Simple.of(defaultMethod, targetType);
                }
                return SpecialMethodInvocation.Illegal.INSTANCE;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AbstractBase that = (AbstractBase)other;
                return this.bridgeMethodResolver.equals(that.bridgeMethodResolver) && this.defaultMethods.equals(that.defaultMethods) && this.typeDescription.equals(that.typeDescription);
            }

            public int hashCode() {
                int result = this.typeDescription.hashCode();
                result = 31 * result + this.defaultMethods.hashCode();
                result = 31 * result + this.bridgeMethodResolver.hashCode();
                return result;
            }
        }

        public static interface Factory {
            public Target make(MethodLookupEngine.Finding var1);
        }

        public static interface MethodLookup {
            public MethodDescription resolve(MethodDescription var1, Map<String, MethodDescription> var2, BridgeMethodResolver var3);

            public static enum Default implements MethodLookup
            {
                EXACT{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return methodDescription;
                    }
                }
                ,
                MOST_SPECIFIC{

                    @Override
                    public MethodDescription resolve(MethodDescription methodDescription, Map<String, MethodDescription> invokableMethods, BridgeMethodResolver bridgeMethodResolver) {
                        return bridgeMethodResolver.resolve(invokableMethods.get(methodDescription.getUniqueSignature()));
                    }
                };

            }
        }
    }

    public static interface SpecialMethodInvocation
    extends StackManipulation {
        public MethodDescription getMethodDescription();

        public TypeDescription getTypeDescription();

        public static class Simple
        implements SpecialMethodInvocation {
            private final MethodDescription methodDescription;
            private final TypeDescription typeDescription;
            private final StackManipulation stackManipulation;

            private Simple(MethodDescription methodDescription, TypeDescription typeDescription, StackManipulation stackManipulation) {
                this.methodDescription = methodDescription;
                this.typeDescription = typeDescription;
                this.stackManipulation = stackManipulation;
            }

            public static SpecialMethodInvocation of(MethodDescription methodDescription, TypeDescription typeDescription) {
                StackManipulation stackManipulation = MethodInvocation.invoke(methodDescription).special(typeDescription);
                return stackManipulation.isValid() && !methodDescription.isAbstract() ? new Simple(methodDescription, typeDescription, stackManipulation) : Illegal.INSTANCE;
            }

            @Override
            public MethodDescription getMethodDescription() {
                return this.methodDescription;
            }

            @Override
            public TypeDescription getTypeDescription() {
                return this.typeDescription;
            }

            @Override
            public boolean isValid() {
                return this.stackManipulation.isValid();
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context instrumentationContext) {
                return this.stackManipulation.apply(methodVisitor, instrumentationContext);
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                SpecialMethodInvocation specialMethodInvocation = (SpecialMethodInvocation)other;
                return this.isValid() == specialMethodInvocation.isValid() && this.typeDescription.equals(specialMethodInvocation.getTypeDescription()) && this.methodDescription.getInternalName().equals(specialMethodInvocation.getMethodDescription().getInternalName()) && this.methodDescription.getParameterTypes().equals(specialMethodInvocation.getMethodDescription().getParameterTypes()) && this.methodDescription.getReturnType().equals(specialMethodInvocation.getMethodDescription().getReturnType());
            }

            public int hashCode() {
                int result = this.methodDescription.getInternalName().hashCode();
                result = 31 * result + this.methodDescription.getParameterTypes().hashCode();
                result = 31 * result + this.methodDescription.getReturnType().hashCode();
                result = 31 * result + this.typeDescription.hashCode();
                return result;
            }

            public String toString() {
                return "Instrumentation.SpecialMethodInvocation.Legal{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + '}';
            }
        }

        public static enum Illegal implements SpecialMethodInvocation
        {
            INSTANCE;


            @Override
            public boolean isValid() {
                return false;
            }

            @Override
            public StackManipulation.Size apply(MethodVisitor methodVisitor, Context instrumentationContext) {
                throw new IllegalStateException();
            }

            @Override
            public MethodDescription getMethodDescription() {
                throw new IllegalStateException();
            }

            @Override
            public TypeDescription getTypeDescription() {
                throw new IllegalStateException();
            }
        }
    }

    public static enum ForAbstractMethod implements Instrumentation,
    ByteCodeAppender
    {
        INSTANCE;


        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Target instrumentationTarget) {
            return this;
        }

        @Override
        public boolean appendsCode() {
            return false;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Context instrumentationContext, MethodDescription instrumentedMethod) {
            throw new IllegalStateException();
        }
    }
}

