/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.MethodLookupEngine;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodNameEqualityResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.MostSpecificTypeResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.ParameterLengthResolver;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.AllArguments;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Argument;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.BindingPriority;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.DefaultCall;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Origin;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.Super;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.SuperCall;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.This;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public class MethodDelegation
implements Instrumentation {
    private static final String NO_METHODS_ERROR_MESSAGE = "The target type does not define any methods for delegation";
    private final InstrumentationDelegate instrumentationDelegate;
    private final List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders;
    private final TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultsProvider;
    private final MethodDelegationBinder.AmbiguityResolver ambiguityResolver;
    private final Assigner assigner;
    private final MethodList targetMethodCandidates;

    protected MethodDelegation(InstrumentationDelegate instrumentationDelegate, List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> parameterBinders, TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultsProvider, MethodDelegationBinder.AmbiguityResolver ambiguityResolver, Assigner assigner, MethodList targetMethodCandidates) {
        this.instrumentationDelegate = instrumentationDelegate;
        this.parameterBinders = parameterBinders;
        this.defaultsProvider = defaultsProvider;
        this.ambiguityResolver = ambiguityResolver;
        this.assigner = assigner;
        this.targetMethodCandidates = ByteBuddyCommons.isNotEmpty(targetMethodCandidates, NO_METHODS_ERROR_MESSAGE);
    }

    public static MethodDelegation to(Class<?> type) {
        if (type == null) {
            throw new NullPointerException("Type must not be null");
        }
        if (type.isInterface()) {
            throw new IllegalArgumentException("Cannot delegate to interface " + type);
        }
        if (type.isArray()) {
            throw new IllegalArgumentException("Cannot delegate to array " + type);
        }
        if (type.isPrimitive()) {
            throw new IllegalArgumentException("Cannot delegate to primitive " + type);
        }
        return new MethodDelegation(InstrumentationDelegate.ForStaticMethod.INSTANCE, MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(type).getDeclaredMethods().filter(MethodMatchers.isStatic().and(MethodMatchers.not(MethodMatchers.isPrivate()))));
    }

    public static MethodDelegation to(Object delegate) {
        return MethodDelegation.to(delegate, MethodDelegation.defaultMethodLookupEngine());
    }

    public static MethodDelegation to(Object delegate, MethodLookupEngine methodLookupEngine) {
        return new MethodDelegation(new InstrumentationDelegate.ForStaticFieldInstance(ByteBuddyCommons.nonNull(delegate)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), methodLookupEngine.process(new TypeDescription.ForLoadedType(delegate.getClass())).getInvokableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation to(Object delegate, String fieldName) {
        return MethodDelegation.to(delegate, fieldName, MethodDelegation.defaultMethodLookupEngine());
    }

    public static MethodDelegation to(Object delegate, String fieldName, MethodLookupEngine methodLookupEngine) {
        return new MethodDelegation(new InstrumentationDelegate.ForStaticFieldInstance(ByteBuddyCommons.nonNull(delegate), ByteBuddyCommons.isValidIdentifier(fieldName)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), methodLookupEngine.process(new TypeDescription.ForLoadedType(delegate.getClass())).getInvokableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName) {
        return MethodDelegation.toInstanceField(type, fieldName, MethodDelegation.defaultMethodLookupEngine());
    }

    public static MethodDelegation toInstanceField(Class<?> type, String fieldName, MethodLookupEngine methodLookupEngine) {
        return new MethodDelegation(new InstrumentationDelegate.ForInstanceField(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type)), ByteBuddyCommons.isValidIdentifier(fieldName)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), methodLookupEngine.process(new TypeDescription.ForLoadedType(type)).getInvokableMethods().filter(MethodMatchers.not(MethodMatchers.isStatic().or(MethodMatchers.isPrivate()).or(MethodMatchers.isConstructor()))));
    }

    public static MethodDelegation toConstructor(Class<?> type) {
        return new MethodDelegation(new InstrumentationDelegate.ForConstruction(new TypeDescription.ForLoadedType(type)), MethodDelegation.defaultParameterBinders(), MethodDelegation.defaultDefaultsProvider(), MethodDelegation.defaultAmbiguityResolver(), MethodDelegation.defaultAssigner(), new TypeDescription.ForLoadedType(type).getDeclaredMethods().filter(MethodMatchers.isConstructor()));
    }

    private static List<TargetMethodAnnotationDrivenBinder.ParameterBinder<?>> defaultParameterBinders() {
        return Arrays.asList(Argument.Binder.INSTANCE, AllArguments.Binder.INSTANCE, Origin.Binder.INSTANCE, This.Binder.INSTANCE, Super.Binder.INSTANCE, SuperCall.Binder.INSTANCE, DefaultCall.Binder.INSTANCE);
    }

    private static TargetMethodAnnotationDrivenBinder.DefaultsProvider<?> defaultDefaultsProvider() {
        return Argument.NextUnboundAsDefaultsProvider.INSTANCE;
    }

    private static MethodDelegationBinder.AmbiguityResolver defaultAmbiguityResolver() {
        return MethodDelegationBinder.AmbiguityResolver.Chain.of(BindingPriority.Resolver.INSTANCE, MethodNameEqualityResolver.INSTANCE, MostSpecificTypeResolver.INSTANCE, ParameterLengthResolver.INSTANCE);
    }

    private static Assigner defaultAssigner() {
        return new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE), false);
    }

    private static MethodLookupEngine defaultMethodLookupEngine() {
        return new MethodLookupEngine.Default(MethodLookupEngine.Default.DefaultMethodLookup.DISABLED);
    }

    public MethodDelegation appendParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> parameterBinder) {
        return new MethodDelegation(this.instrumentationDelegate, ByteBuddyCommons.join(this.parameterBinders, ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.ambiguityResolver, this.assigner, this.targetMethodCandidates);
    }

    public MethodDelegation defineParameterBinder(TargetMethodAnnotationDrivenBinder.ParameterBinder<?> ... parameterBinder) {
        return new MethodDelegation(this.instrumentationDelegate, Arrays.asList((Object[])ByteBuddyCommons.nonNull(parameterBinder)), this.defaultsProvider, this.ambiguityResolver, this.assigner, this.targetMethodCandidates);
    }

    public MethodDelegation defaultsProvider(TargetMethodAnnotationDrivenBinder.DefaultsProvider defaultsProvider) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, ByteBuddyCommons.nonNull(defaultsProvider), this.ambiguityResolver, this.assigner, this.targetMethodCandidates);
    }

    public MethodDelegation appendAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ambiguityResolver) {
        return this.defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver.Chain.of(this.ambiguityResolver, ByteBuddyCommons.nonNull(ambiguityResolver)));
    }

    public MethodDelegation defineAmbiguityResolver(MethodDelegationBinder.AmbiguityResolver ... ambiguityResolver) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, MethodDelegationBinder.AmbiguityResolver.Chain.of(ByteBuddyCommons.nonNull(ambiguityResolver)), this.assigner, this.targetMethodCandidates);
    }

    public MethodDelegation assigner(Assigner assigner) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, this.ambiguityResolver, ByteBuddyCommons.nonNull(assigner), this.targetMethodCandidates);
    }

    public MethodDelegation filter(MethodMatcher methodMatcher) {
        return new MethodDelegation(this.instrumentationDelegate, this.parameterBinders, this.defaultsProvider, this.ambiguityResolver, this.assigner, ByteBuddyCommons.isNotEmpty(this.targetMethodCandidates.filter(ByteBuddyCommons.nonNull(methodMatcher)), NO_METHODS_ERROR_MESSAGE));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return this.instrumentationDelegate.prepare(instrumentedType);
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        MethodList methodList = this.targetMethodCandidates.filter(MethodMatchers.isVisibleTo(instrumentationTarget.getTypeDescription()));
        if (methodList.size() == 0) {
            throw new IllegalStateException("No bindable method is visible to " + instrumentationTarget.getTypeDescription());
        }
        return new MethodDelegationByteCodeAppender(this.instrumentationDelegate.getPreparingStackAssignment(instrumentationTarget.getTypeDescription()), instrumentationTarget, methodList, new MethodDelegationBinder.Processor(new TargetMethodAnnotationDrivenBinder(this.parameterBinders, this.defaultsProvider, this.assigner, this.instrumentationDelegate.getMethodInvoker(instrumentationTarget.getTypeDescription())), this.ambiguityResolver));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MethodDelegation that = (MethodDelegation)other;
        return this.ambiguityResolver.equals(that.ambiguityResolver) && this.assigner.equals(that.assigner) && this.defaultsProvider.equals(that.defaultsProvider) && this.instrumentationDelegate.equals(that.instrumentationDelegate) && this.targetMethodCandidates.equals(that.targetMethodCandidates) && this.parameterBinders.equals(that.parameterBinders);
    }

    public int hashCode() {
        int result = this.instrumentationDelegate.hashCode();
        result = 31 * result + this.parameterBinders.hashCode();
        result = 31 * result + this.defaultsProvider.hashCode();
        result = 31 * result + this.ambiguityResolver.hashCode();
        result = 31 * result + this.assigner.hashCode();
        result = 31 * result + this.targetMethodCandidates.hashCode();
        return result;
    }

    public String toString() {
        return "MethodDelegation{instrumentationDelegate=" + this.instrumentationDelegate + ", parameterBinders=" + this.parameterBinders + ", defaultsProvider=" + this.defaultsProvider + ", ambiguityResolver=" + this.ambiguityResolver + ", assigner=" + this.assigner + ", targetMethodCandidates=" + this.targetMethodCandidates + '}';
    }

    private static class MethodDelegationByteCodeAppender
    implements ByteCodeAppender {
        private final StackManipulation preparingStackAssignment;
        private final Instrumentation.Target instrumentationTarget;
        private final Iterable<? extends MethodDescription> targetMethods;
        private final MethodDelegationBinder.Processor processor;

        private MethodDelegationByteCodeAppender(StackManipulation preparingStackAssignment, Instrumentation.Target instrumentationTarget, Iterable<? extends MethodDescription> targetMethods, MethodDelegationBinder.Processor processor) {
            this.preparingStackAssignment = preparingStackAssignment;
            this.instrumentationTarget = instrumentationTarget;
            this.targetMethods = targetMethods;
            this.processor = processor;
        }

        @Override
        public boolean appendsCode() {
            return true;
        }

        @Override
        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
            StackManipulation.Size stackSize = new StackManipulation.Compound(this.preparingStackAssignment, this.processor.process(this.instrumentationTarget, instrumentedMethod, this.targetMethods), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
            return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MethodDelegationByteCodeAppender that = (MethodDelegationByteCodeAppender)other;
            return this.instrumentationTarget.equals(that.instrumentationTarget) && this.preparingStackAssignment.equals(that.preparingStackAssignment) && this.processor.equals(that.processor) && this.targetMethods.equals(that.targetMethods);
        }

        public int hashCode() {
            int result = this.preparingStackAssignment.hashCode();
            result = 31 * result + this.instrumentationTarget.hashCode();
            result = 31 * result + this.targetMethods.hashCode();
            result = 31 * result + this.processor.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDelegationByteCodeAppender{preparingStackAssignment=" + this.preparingStackAssignment + ", instrumentationTarget=" + this.instrumentationTarget + ", targetMethods=" + this.targetMethods + ", processor=" + this.processor + '}';
        }
    }

    protected static interface InstrumentationDelegate {
        public InstrumentedType prepare(InstrumentedType var1);

        public StackManipulation getPreparingStackAssignment(TypeDescription var1);

        public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription var1);

        public static class ForConstruction
        implements InstrumentationDelegate {
            private final TypeDescription typeDescription;

            public ForConstruction(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(TypeCreation.forType(this.typeDescription), Duplication.SINGLE);
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((ForConstruction)other).typeDescription);
            }

            public int hashCode() {
                return this.typeDescription.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForConstruction{typeDescription=" + this.typeDescription + '}';
            }
        }

        public static class ForInstanceField
        implements InstrumentationDelegate {
            private final String fieldName;
            private final TypeDescription fieldType;

            public ForInstanceField(TypeDescription fieldType, String fieldName) {
                this.fieldType = fieldType;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, this.fieldType, 1);
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return new StackManipulation.Compound(MethodVariableAccess.forType(instrumentedType).loadFromIndex(0), FieldAccess.forField(instrumentedType.getDeclaredFields().named(this.fieldName)).getter());
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(this.fieldType);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.fieldName.equals(((ForInstanceField)other).fieldName) && this.fieldType.equals(((ForInstanceField)other).fieldType);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.fieldType.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForInstanceField{fieldName='" + this.fieldName + '\'' + ", fieldType=" + this.fieldType + '}';
            }
        }

        public static class ForStaticFieldInstance
        implements InstrumentationDelegate {
            private static final String PREFIX = "methodDelegate";
            private final String fieldName;
            private final Object delegate;

            public ForStaticFieldInstance(Object delegate) {
                this(delegate, String.format("%s$%d", PREFIX, delegate.hashCode()));
            }

            public ForStaticFieldInstance(Object delegate, String fieldName) {
                this.delegate = delegate;
                this.fieldName = fieldName;
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(this.delegate.getClass()), 4106).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.delegate));
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return FieldAccess.forField(instrumentedType.getDeclaredFields().named(this.fieldName)).getter();
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return new MethodDelegationBinder.MethodInvoker.Virtual(new TypeDescription.ForLoadedType(this.delegate.getClass()));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.delegate.equals(((ForStaticFieldInstance)other).delegate) && this.fieldName.equals(((ForStaticFieldInstance)other).fieldName);
            }

            public int hashCode() {
                return 31 * this.fieldName.hashCode() + this.delegate.hashCode();
            }

            public String toString() {
                return "MethodDelegation.InstrumentationDelegate.ForStaticFieldInstance{fieldName='" + this.fieldName + '\'' + ", delegate=" + this.delegate + '}';
            }
        }

        public static enum ForStaticMethod implements InstrumentationDelegate
        {
            INSTANCE;


            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }

            @Override
            public StackManipulation getPreparingStackAssignment(TypeDescription instrumentedType) {
                return StackManipulation.LegalTrivial.INSTANCE;
            }

            @Override
            public MethodDelegationBinder.MethodInvoker getMethodInvoker(TypeDescription instrumentedType) {
                return MethodDelegationBinder.MethodInvoker.Simple.INSTANCE;
            }
        }
    }
}

