/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.field;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.List;
import java.util.NoSuchElementException;
import net.bytebuddy.instrumentation.field.FieldDescription;

public interface FieldList
extends List<FieldDescription> {
    public FieldDescription named(String var1);

    public static class Empty
    extends AbstractList<FieldDescription>
    implements FieldList {
        @Override
        public FieldDescription get(int index) {
            throw new NoSuchElementException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public FieldDescription named(String fieldName) {
            throw new IllegalArgumentException("Expected to find a field " + fieldName + " but found none");
        }
    }

    public static class Explicit
    extends AbstractList<FieldDescription>
    implements FieldList {
        private final List<? extends FieldDescription> fieldDescriptions;

        public Explicit(List<? extends FieldDescription> fieldDescriptions) {
            this.fieldDescriptions = fieldDescriptions;
        }

        @Override
        public FieldDescription get(int index) {
            return this.fieldDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.fieldDescriptions.size();
        }

        @Override
        public FieldDescription named(String fieldName) {
            for (FieldDescription fieldDescription : this.fieldDescriptions) {
                if (!fieldDescription.getInternalName().equals(fieldName)) continue;
                return fieldDescription;
            }
            throw new IllegalArgumentException("Expected to find a field " + fieldName);
        }
    }

    public static class ForLoadedField
    extends AbstractList<FieldDescription>
    implements FieldList {
        private final Field[] field;

        public ForLoadedField(Field[] field) {
            this.field = field;
        }

        @Override
        public FieldDescription get(int index) {
            return new FieldDescription.ForLoadedField(this.field[index]);
        }

        @Override
        public int size() {
            return this.field.length;
        }

        @Override
        public FieldDescription named(String fieldName) {
            for (Field field : this.field) {
                if (!field.getName().equals(fieldName)) continue;
                return new FieldDescription.ForLoadedField(field);
            }
            throw new IllegalArgumentException("Expected to find a field " + fieldName);
        }
    }
}

