/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind;

import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.type.TypeDescription;

public enum MostSpecificTypeResolver implements MethodDelegationBinder.AmbiguityResolver
{
    INSTANCE;


    private static MethodDelegationBinder.AmbiguityResolver.Resolution resolveRivalBinding(TypeDescription sourceParameterType, int leftParameterIndex, MethodDelegationBinder.MethodBinding left, int rightParameterIndex, MethodDelegationBinder.MethodBinding right) {
        TypeDescription rightParameterType;
        TypeDescription leftParameterType = (TypeDescription)left.getTarget().getParameterTypes().get(leftParameterIndex);
        if (!leftParameterType.equals(rightParameterType = (TypeDescription)right.getTarget().getParameterTypes().get(rightParameterIndex))) {
            if (leftParameterType.isPrimitive() && rightParameterType.isPrimitive()) {
                return PrimitiveTypePrecedence.forPrimitive(leftParameterType).resolve(PrimitiveTypePrecedence.forPrimitive(rightParameterType));
            }
            if (leftParameterType.isPrimitive()) {
                return sourceParameterType.isPrimitive() ? MethodDelegationBinder.AmbiguityResolver.Resolution.LEFT : MethodDelegationBinder.AmbiguityResolver.Resolution.RIGHT;
            }
            if (rightParameterType.isPrimitive()) {
                return sourceParameterType.isPrimitive() ? MethodDelegationBinder.AmbiguityResolver.Resolution.RIGHT : MethodDelegationBinder.AmbiguityResolver.Resolution.LEFT;
            }
            if (leftParameterType.isAssignableFrom(rightParameterType)) {
                return MethodDelegationBinder.AmbiguityResolver.Resolution.RIGHT;
            }
            if (rightParameterType.isAssignableFrom(leftParameterType)) {
                return MethodDelegationBinder.AmbiguityResolver.Resolution.LEFT;
            }
            return MethodDelegationBinder.AmbiguityResolver.Resolution.AMBIGUOUS;
        }
        return MethodDelegationBinder.AmbiguityResolver.Resolution.UNKNOWN;
    }

    private static MethodDelegationBinder.AmbiguityResolver.Resolution resolveByScore(int boundParameterScore) {
        if (boundParameterScore == 0) {
            return MethodDelegationBinder.AmbiguityResolver.Resolution.AMBIGUOUS;
        }
        if (boundParameterScore > 0) {
            return MethodDelegationBinder.AmbiguityResolver.Resolution.LEFT;
        }
        return MethodDelegationBinder.AmbiguityResolver.Resolution.RIGHT;
    }

    @Override
    public MethodDelegationBinder.AmbiguityResolver.Resolution resolve(MethodDescription source, MethodDelegationBinder.MethodBinding left, MethodDelegationBinder.MethodBinding right) {
        MethodDelegationBinder.AmbiguityResolver.Resolution resolution = MethodDelegationBinder.AmbiguityResolver.Resolution.UNKNOWN;
        int leftExtra = 0;
        int rightExtra = 0;
        for (int sourceParameterIndex = 0; sourceParameterIndex < source.getParameterTypes().size(); ++sourceParameterIndex) {
            ParameterIndexToken parameterIndexToken = new ParameterIndexToken(sourceParameterIndex);
            Integer leftParameterIndex = left.getTargetParameterIndex(parameterIndexToken);
            Integer rightParameterIndex = right.getTargetParameterIndex(parameterIndexToken);
            if (leftParameterIndex != null && rightParameterIndex != null) {
                resolution = resolution.merge(MostSpecificTypeResolver.resolveRivalBinding((TypeDescription)source.getParameterTypes().get(sourceParameterIndex), leftParameterIndex, left, rightParameterIndex, right));
                continue;
            }
            if (leftParameterIndex != null) {
                ++leftExtra;
                continue;
            }
            if (rightParameterIndex == null) continue;
            ++rightExtra;
        }
        return resolution == MethodDelegationBinder.AmbiguityResolver.Resolution.UNKNOWN ? MostSpecificTypeResolver.resolveByScore(leftExtra - rightExtra) : resolution;
    }

    public static class ParameterIndexToken {
        private final int parameterIndex;

        public ParameterIndexToken(int parameterIndex) {
            this.parameterIndex = parameterIndex;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.parameterIndex == ((ParameterIndexToken)other).parameterIndex;
        }

        public int hashCode() {
            return this.parameterIndex;
        }

        public String toString() {
            return "MostSpecificTypeResolver.ParameterIndexToken{" + this.parameterIndex + '}';
        }
    }

    private static enum PrimitiveTypePrecedence {
        BOOLEAN(0),
        BYTE(1),
        SHORT(2),
        INTEGER(3),
        CHARACTER(4),
        LONG(5),
        FLOAT(6),
        DOUBLE(7);

        private final int score;

        private PrimitiveTypePrecedence(int score) {
            this.score = score;
        }

        public static PrimitiveTypePrecedence forPrimitive(TypeDescription typeDescription) {
            if (typeDescription.represents(Boolean.TYPE)) {
                return BOOLEAN;
            }
            if (typeDescription.represents(Byte.TYPE)) {
                return BYTE;
            }
            if (typeDescription.represents(Short.TYPE)) {
                return SHORT;
            }
            if (typeDescription.represents(Integer.TYPE)) {
                return INTEGER;
            }
            if (typeDescription.represents(Character.TYPE)) {
                return CHARACTER;
            }
            if (typeDescription.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDescription.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDescription.represents(Double.TYPE)) {
                return DOUBLE;
            }
            throw new IllegalArgumentException("Not a non-void, primitive type " + typeDescription);
        }

        public MethodDelegationBinder.AmbiguityResolver.Resolution resolve(PrimitiveTypePrecedence right) {
            if (this.score - right.score == 0) {
                return MethodDelegationBinder.AmbiguityResolver.Resolution.UNKNOWN;
            }
            if (this.score - right.score > 0) {
                return MethodDelegationBinder.AmbiguityResolver.Resolution.RIGHT;
            }
            return MethodDelegationBinder.AmbiguityResolver.Resolution.LEFT;
        }
    }
}

