/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.DefaultValue;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public class VoidAwareAssigner
implements Assigner {
    private final Assigner nonVoidAwareAssigner;
    private final boolean returnDefaultValue;

    public VoidAwareAssigner(Assigner nonVoidAwareAssigner, boolean returnDefaultValue) {
        this.nonVoidAwareAssigner = nonVoidAwareAssigner;
        this.returnDefaultValue = returnDefaultValue;
    }

    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean considerRuntimeType) {
        if (sourceType.represents(Void.TYPE) && targetType.represents(Void.TYPE)) {
            return StackManipulation.LegalTrivial.INSTANCE;
        }
        if (sourceType.represents(Void.TYPE)) {
            return this.returnDefaultValue ? DefaultValue.of(targetType) : StackManipulation.Illegal.INSTANCE;
        }
        if (targetType.represents(Void.TYPE)) {
            return ValueRemovingStackManipulation.of(sourceType);
        }
        return this.nonVoidAwareAssigner.assign(sourceType, targetType, considerRuntimeType);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.returnDefaultValue == ((VoidAwareAssigner)other).returnDefaultValue && this.nonVoidAwareAssigner.equals(((VoidAwareAssigner)other).nonVoidAwareAssigner);
    }

    public int hashCode() {
        return 31 * this.nonVoidAwareAssigner.hashCode() + (this.returnDefaultValue ? 1 : 0);
    }

    public String toString() {
        return "VoidAwareAssigner{chained=" + this.nonVoidAwareAssigner + ", returnDefaultValue=" + this.returnDefaultValue + '}';
    }

    private static enum ValueRemovingStackManipulation implements StackManipulation
    {
        POP_ONE_FRAME(87, StackSize.SINGLE),
        POP_TWO_FRAMES(88, StackSize.DOUBLE);

        private final int removalOpcode;
        private final StackManipulation.Size sizeChange;

        private ValueRemovingStackManipulation(int removalOpcode, StackSize sizeChange) {
            this.removalOpcode = removalOpcode;
            this.sizeChange = sizeChange.toDecreasingSize();
        }

        public static StackManipulation of(TypeDescription typeDescription) {
            if (typeDescription.represents(Long.TYPE) || typeDescription.represents(Double.TYPE)) {
                return POP_TWO_FRAMES;
            }
            if (typeDescription.represents(Void.TYPE)) {
                throw new IllegalArgumentException("Cannot pop void type from stack");
            }
            return POP_ONE_FRAME;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitInsn(this.removalOpcode);
            return this.sizeChange;
        }
    }
}

