/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference;

import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.DownCasting;
import net.bytebuddy.instrumentation.type.TypeDescription;

public enum ReferenceTypeAwareAssigner implements Assigner
{
    INSTANCE;


    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, boolean considerRuntimeType) {
        if (sourceType.isPrimitive() || targetType.isPrimitive()) {
            if (sourceType.equals(targetType)) {
                return StackManipulation.LegalTrivial.INSTANCE;
            }
            return StackManipulation.Illegal.INSTANCE;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return StackManipulation.LegalTrivial.INSTANCE;
        }
        if (considerRuntimeType) {
            return new DownCasting(targetType);
        }
        return StackManipulation.Illegal.INSTANCE;
    }
}

