/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.constant;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum DoubleConstant implements StackManipulation
{
    ZERO(14),
    ONE(15);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private DoubleConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(double value) {
        if (value == 0.0) {
            return ZERO;
        }
        if (value == 1.0) {
            return ONE;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.DOUBLE.toIncreasingSize();
    }

    private static class ConstantPool
    implements StackManipulation {
        private final double value;

        private ConstantPool(double value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Double.compare(((ConstantPool)other).value, this.value) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value);
            return (int)(temp ^ temp >>> 32);
        }

        public String toString() {
            return "DoubleConstant.ConstantPool{value=" + this.value + '}';
        }
    }
}

