/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.constant;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum FloatConstant implements StackManipulation
{
    ZERO(11),
    ONE(12),
    TWO(13);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private FloatConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(float value) {
        if (value == 0.0f) {
            return ZERO;
        }
        if (value == 1.0f) {
            return ONE;
        }
        if (value == 2.0f) {
            return TWO;
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    private static class ConstantPool
    implements StackManipulation {
        private final float value;

        private ConstantPool(float value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitLdcInsn(Float.valueOf(this.value));
            return SIZE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Float.compare(((ConstantPool)other).value, this.value) == 0;
        }

        public int hashCode() {
            return this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        }

        public String toString() {
            return "ConstantPool.ConstantPool{value=" + this.value + '}';
        }
    }
}

