/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.stack.member;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum MethodInvocation {
    VIRTUAL(182),
    INTERFACE(185),
    STATIC(184),
    SPECIAL(183);

    private final int invocationOpcode;

    private MethodInvocation(int callOpcode) {
        this.invocationOpcode = callOpcode;
    }

    public static WithImplicitInvocationTargetType invoke(MethodDescription methodDescription) {
        if (methodDescription.isTypeInitializer()) {
            throw new IllegalArgumentException("The type initializer cannot be invoked explicitly");
        }
        if (methodDescription.isStatic()) {
            MethodInvocation methodInvocation = STATIC;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.isPrivate() || methodDescription.isConstructor() || methodDescription.isDefaultMethod()) {
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        if (methodDescription.getDeclaringType().isInterface()) {
            MethodInvocation methodInvocation = INTERFACE;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(methodDescription);
        }
        MethodInvocation methodInvocation = VIRTUAL;
        ((Object)((Object)methodInvocation)).getClass();
        return methodInvocation.new Invocation(methodDescription);
    }

    private class Invocation
    implements WithImplicitInvocationTargetType {
        private final TypeDescription typeDescription;
        private final MethodDescription methodDescription;
        private final StackManipulation.Size size;

        private Invocation(MethodDescription methodDescription) {
            this(methodDescription, methodDescription.getDeclaringType());
        }

        private Invocation(MethodDescription methodDescription, TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
            this.methodDescription = methodDescription;
            int parameterSize = methodDescription.getStackSize();
            int returnValueSize = methodDescription.getReturnType().getStackSize().getSize();
            this.size = new StackManipulation.Size(returnValueSize - parameterSize, Math.max(0, returnValueSize - parameterSize));
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext) {
            methodVisitor.visitMethodInsn(MethodInvocation.this.invocationOpcode, this.typeDescription.getInternalName(), this.methodDescription.getInternalName(), this.methodDescription.getDescriptor(), this.typeDescription.isInterface());
            return this.size;
        }

        @Override
        public StackManipulation virtual(TypeDescription invocationTarget) {
            if (this.methodDescription.isPrivate() || this.methodDescription.isConstructor() || this.methodDescription.isStatic()) {
                return StackManipulation.Illegal.INSTANCE;
            }
            if (invocationTarget.isInterface()) {
                MethodInvocation methodInvocation = INTERFACE;
                ((Object)((Object)methodInvocation)).getClass();
                return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
            }
            MethodInvocation methodInvocation = VIRTUAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        @Override
        public StackManipulation special(TypeDescription invocationTarget) {
            if (!this.methodDescription.isSpecializableFor(invocationTarget)) {
                return StackManipulation.Illegal.INSTANCE;
            }
            MethodInvocation methodInvocation = SPECIAL;
            ((Object)((Object)methodInvocation)).getClass();
            return methodInvocation.new Invocation(this.methodDescription, invocationTarget);
        }

        @Override
        public MethodInvocation getImplicitInvocationType() {
            return MethodInvocation.this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Invocation that = (Invocation)other;
            return MethodInvocation.this.equals((Object)((Invocation)other).getImplicitInvocationType()) && this.methodDescription.getInternalName().equals(that.methodDescription.getInternalName()) && this.methodDescription.getReturnType().equals(((Invocation)other).methodDescription.getReturnType()) && this.methodDescription.getParameterTypes().equals(((Invocation)other).methodDescription.getParameterTypes()) && this.typeDescription.equals(that.typeDescription);
        }

        public int hashCode() {
            int result = this.typeDescription.hashCode();
            result = 31 * result + MethodInvocation.this.hashCode();
            result = 31 * result + this.methodDescription.getInternalName().hashCode();
            result = 31 * result + this.methodDescription.getParameterTypes().hashCode();
            result = 31 * result + this.methodDescription.getReturnType().hashCode();
            return result;
        }

        public String toString() {
            return "MethodInvocation.Invocation{typeDescription=" + this.typeDescription + ", methodDescription=" + this.methodDescription + ", size=" + this.size + '}';
        }
    }

    public static interface WithImplicitInvocationTargetType
    extends StackManipulation {
        public StackManipulation virtual(TypeDescription var1);

        public StackManipulation special(TypeDescription var1);

        public MethodInvocation getImplicitInvocationType();
    }
}

