/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.loading;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bytebuddy.instrumentation.type.TypeDescription;

public class ClassLoaderByteArrayInjector {
    private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;
    private static final ReflectionStore REFLECTION_STORE;
    private final ClassLoader classLoader;
    private final ProtectionDomain protectionDomain;
    private final AccessControlContext accessControlContext;

    public ClassLoaderByteArrayInjector(ClassLoader classLoader) {
        this(classLoader, DEFAULT_PROTECTION_DOMAIN);
    }

    public ClassLoaderByteArrayInjector(ClassLoader classLoader, ProtectionDomain protectionDomain) {
        this.classLoader = classLoader;
        this.protectionDomain = protectionDomain;
        this.accessControlContext = AccessController.getContext();
    }

    public static Map<TypeDescription, Class<?>> inject(ClassLoaderByteArrayInjector classLoaderByteArrayInjector, Map<TypeDescription, byte[]> types) {
        LinkedHashMap loadedTypes = new LinkedHashMap(types.size());
        for (Map.Entry<TypeDescription, byte[]> entry : types.entrySet()) {
            loadedTypes.put(entry.getKey(), classLoaderByteArrayInjector.inject(entry.getKey().getName(), entry.getValue()));
        }
        return loadedTypes;
    }

    public Class<?> inject(String name, byte[] binaryRepresentation) {
        try {
            ClassLoader classLoader = this.classLoader;
            synchronized (classLoader) {
                Class type = (Class)REFLECTION_STORE.getFindLoadedClassMethod().invoke((Object)this.classLoader, name);
                if (type != null) {
                    return type;
                }
                try {
                    return (Class)AccessController.doPrivileged(new ClassLoadingAction(name, binaryRepresentation), this.accessControlContext);
                }
                catch (PrivilegedActionException e) {
                    if (e.getCause() instanceof IllegalAccessException) {
                        throw (IllegalAccessException)e.getCause();
                    }
                    if (e.getCause() instanceof InvocationTargetException) {
                        throw (InvocationTargetException)e.getCause();
                    }
                    throw (RuntimeException)e.getCause();
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not access injection method", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception on invoking loader method", e.getCause());
        }
    }

    public String toString() {
        return "ClassLoaderByteArrayInjector{protectionDomain=" + this.protectionDomain + "accessControlContext=" + this.accessControlContext + ", classLoader=" + this.classLoader + '}';
    }

    static {
        ReflectionStore reflectionStore;
        DEFAULT_PROTECTION_DOMAIN = null;
        try {
            Method findLoadedClassMethod = ClassLoader.class.getDeclaredMethod("findLoadedClass", String.class);
            findLoadedClassMethod.setAccessible(true);
            Method loadByteArrayMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
            loadByteArrayMethod.setAccessible(true);
            reflectionStore = new ReflectionStore.Resolved(findLoadedClassMethod, loadByteArrayMethod);
        }
        catch (Exception e) {
            reflectionStore = new ReflectionStore.Faulty(e);
        }
        REFLECTION_STORE = reflectionStore;
    }

    protected class ClassLoadingAction
    implements PrivilegedExceptionAction<Class<?>> {
        private static final int FROM_BEGINNING = 0;
        private final String name;
        private final byte[] binaryRepresentation;

        protected ClassLoadingAction(String name, byte[] binaryRepresentation) {
            this.name = name;
            this.binaryRepresentation = binaryRepresentation;
        }

        @Override
        public Class<?> run() throws IllegalAccessException, InvocationTargetException {
            return (Class)REFLECTION_STORE.getLoadByteArrayMethod().invoke((Object)ClassLoaderByteArrayInjector.this.classLoader, this.name, this.binaryRepresentation, 0, this.binaryRepresentation.length, ClassLoaderByteArrayInjector.this.protectionDomain);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            ClassLoadingAction that = (ClassLoadingAction)other;
            return Arrays.equals(this.binaryRepresentation, that.binaryRepresentation) && ClassLoaderByteArrayInjector.this.equals(that.getOuter()) && this.name.equals(that.name);
        }

        private ClassLoaderByteArrayInjector getOuter() {
            return ClassLoaderByteArrayInjector.this;
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + ClassLoaderByteArrayInjector.class.hashCode();
            result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
            return result;
        }

        public String toString() {
            return "ClassLoaderByteArrayInjector.ClassLoadingAction{injector=" + ClassLoaderByteArrayInjector.this + ", name='" + this.name + '\'' + ", binaryRepresentation=" + Arrays.toString(this.binaryRepresentation) + '}';
        }
    }

    protected static interface ReflectionStore {
        public Method getFindLoadedClassMethod();

        public Method getLoadByteArrayMethod();

        public static class Faulty
        implements ReflectionStore {
            private static final String MESSAGE = "Cannot access reflection API for class loading";
            private final Exception exception;

            protected Faulty(Exception exception) {
                this.exception = exception;
            }

            @Override
            public Method getFindLoadedClassMethod() {
                throw new RuntimeException(MESSAGE, this.exception);
            }

            @Override
            public Method getLoadByteArrayMethod() {
                throw new RuntimeException(MESSAGE, this.exception);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.exception.equals(((Faulty)other).exception);
            }

            public int hashCode() {
                return this.exception.hashCode();
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Faulty{exception=" + this.exception + '}';
            }
        }

        public static class Resolved
        implements ReflectionStore {
            private final Method findLoadedClassMethod;
            private final Method loadByteArrayMethod;

            protected Resolved(Method findLoadedClassMethod, Method loadByteArrayMethod) {
                this.findLoadedClassMethod = findLoadedClassMethod;
                this.loadByteArrayMethod = loadByteArrayMethod;
            }

            @Override
            public Method getFindLoadedClassMethod() {
                return this.findLoadedClassMethod;
            }

            @Override
            public Method getLoadByteArrayMethod() {
                return this.loadByteArrayMethod;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Resolved resolved = (Resolved)other;
                return this.findLoadedClassMethod.equals(resolved.findLoadedClassMethod) && this.loadByteArrayMethod.equals(resolved.loadByteArrayMethod);
            }

            public int hashCode() {
                int result = this.findLoadedClassMethod.hashCode();
                result = 31 * result + this.loadByteArrayMethod.hashCode();
                return result;
            }

            public String toString() {
                return "ClassLoaderByteArrayInjector.ReflectionStore.Resolved{findLoadedClassMethod=" + this.findLoadedClassMethod + ", loadByteArrayMethod=" + this.loadByteArrayMethod + '}';
            }
        }
    }
}

