/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.inline.ClassFileLocator;
import net.bytebuddy.dynamic.scaffold.inline.MethodRebaseResolver;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.attribute.FieldAttributeAppender;
import net.bytebuddy.instrumentation.attribute.MethodAttributeAppender;
import net.bytebuddy.instrumentation.attribute.TypeAttributeAppender;
import net.bytebuddy.instrumentation.field.FieldDescription;
import net.bytebuddy.instrumentation.field.FieldList;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.ClassWriter;
import net.bytebuddy.jar.asm.FieldVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.commons.RemappingClassAdapter;
import net.bytebuddy.jar.asm.commons.SimpleRemapper;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.RandomString;

public interface TypeWriter<T> {
    public DynamicType.Unloaded<T> make();

    public static class Default<S>
    implements TypeWriter<S> {
        private final TypeDescription instrumentedType;
        private final LoadedTypeInitializer loadedTypeInitializer;
        private final List<DynamicType> explicitAuxiliaryTypes;
        private final ClassFileVersion classFileVersion;
        private final Engine engine;

        public Default(TypeDescription instrumentedType, LoadedTypeInitializer loadedTypeInitializer, List<DynamicType> explicitAuxiliaryTypes, ClassFileVersion classFileVersion, Engine engine) {
            this.instrumentedType = instrumentedType;
            this.loadedTypeInitializer = loadedTypeInitializer;
            this.explicitAuxiliaryTypes = explicitAuxiliaryTypes;
            this.classFileVersion = classFileVersion;
            this.engine = engine;
        }

        @Override
        public DynamicType.Unloaded<S> make() {
            Instrumentation.Context.Default instrumentationContext = new Instrumentation.Context.Default(this.instrumentedType, this.classFileVersion);
            return new DynamicType.Default.Unloaded(this.instrumentedType, this.engine.create(instrumentationContext), this.loadedTypeInitializer, ByteBuddyCommons.join(this.explicitAuxiliaryTypes, instrumentationContext.getRegisteredAuxiliaryTypes()));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.engine.equals(aDefault.engine) && this.explicitAuxiliaryTypes.equals(aDefault.explicitAuxiliaryTypes) && this.instrumentedType.equals(aDefault.instrumentedType) && this.classFileVersion.equals(aDefault.classFileVersion) && this.loadedTypeInitializer.equals(aDefault.loadedTypeInitializer);
        }

        public int hashCode() {
            int result = this.instrumentedType.hashCode();
            result = 31 * result + this.loadedTypeInitializer.hashCode();
            result = 31 * result + this.explicitAuxiliaryTypes.hashCode();
            result = 31 * result + this.engine.hashCode();
            result = 31 * result + this.classFileVersion.hashCode();
            return result;
        }

        public String toString() {
            return "TypeWriter.Default{instrumentedType=" + this.instrumentedType + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", explicitAuxiliaryTypes=" + this.explicitAuxiliaryTypes + ", classFileVersion=" + this.classFileVersion + ", engine=" + this.engine + '}';
        }
    }

    public static interface MethodPool {
        public Entry target(MethodDescription var1);

        public static interface Entry {
            public boolean isDefineMethod();

            public ByteCodeAppender getByteCodeAppender();

            public MethodAttributeAppender getAttributeAppender();

            public void apply(ClassVisitor var1, Instrumentation.Context var2, MethodDescription var3);

            public static class Simple
            implements Entry {
                private final ByteCodeAppender byteCodeAppender;
                private final MethodAttributeAppender methodAttributeAppender;

                public Simple(ByteCodeAppender byteCodeAppender, MethodAttributeAppender methodAttributeAppender) {
                    this.byteCodeAppender = byteCodeAppender;
                    this.methodAttributeAppender = methodAttributeAppender;
                }

                @Override
                public boolean isDefineMethod() {
                    return true;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    return this.byteCodeAppender;
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    return this.methodAttributeAppender;
                }

                @Override
                public void apply(ClassVisitor classVisitor, Instrumentation.Context instrumentationContext, MethodDescription methodDescription) {
                    boolean appendsCode = this.byteCodeAppender.appendsCode();
                    MethodVisitor methodVisitor = classVisitor.visitMethod(methodDescription.getAdjustedModifiers(appendsCode), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getGenericSignature(), methodDescription.getExceptionTypes().toInternalNames());
                    this.methodAttributeAppender.apply(methodVisitor, methodDescription);
                    if (appendsCode) {
                        methodVisitor.visitCode();
                        ByteCodeAppender.Size size = this.byteCodeAppender.apply(methodVisitor, instrumentationContext, methodDescription);
                        methodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                    }
                    methodVisitor.visitEnd();
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Simple)other).byteCodeAppender) && this.methodAttributeAppender.equals(((Simple)other).methodAttributeAppender);
                }

                public int hashCode() {
                    return 31 * this.byteCodeAppender.hashCode() + this.methodAttributeAppender.hashCode();
                }

                public String toString() {
                    return "TypeWriter.MethodPool.Entry.Simple{byteCodeAppender=" + this.byteCodeAppender + ", methodAttributeAppender=" + this.methodAttributeAppender + '}';
                }
            }

            public static interface Factory {
                public Entry compile(Instrumentation.Target var1);
            }

            public static enum Skip implements Entry,
            Factory
            {
                INSTANCE;


                @Override
                public boolean isDefineMethod() {
                    return false;
                }

                @Override
                public ByteCodeAppender getByteCodeAppender() {
                    throw new IllegalStateException();
                }

                @Override
                public MethodAttributeAppender getAttributeAppender() {
                    throw new IllegalStateException();
                }

                @Override
                public void apply(ClassVisitor classVisitor, Instrumentation.Context instrumentationContext, MethodDescription methodDescription) {
                }

                @Override
                public Entry compile(Instrumentation.Target instrumentationTarget) {
                    return this;
                }
            }
        }
    }

    public static interface FieldPool {
        public Entry target(FieldDescription var1);

        public static interface Entry {
            public FieldAttributeAppender getFieldAppender();

            public Object getDefaultValue();

            public void apply(ClassVisitor var1, FieldDescription var2);

            public static class Simple
            implements Entry {
                private final FieldAttributeAppender attributeAppender;
                private final Object defaultValue;

                public Simple(FieldAttributeAppender attributeAppender, Object defaultValue) {
                    this.attributeAppender = attributeAppender;
                    this.defaultValue = defaultValue;
                }

                @Override
                public FieldAttributeAppender getFieldAppender() {
                    return this.attributeAppender;
                }

                @Override
                public Object getDefaultValue() {
                    return this.defaultValue;
                }

                @Override
                public void apply(ClassVisitor classVisitor, FieldDescription fieldDescription) {
                    FieldVisitor fieldVisitor = classVisitor.visitField(fieldDescription.getModifiers(), fieldDescription.getInternalName(), fieldDescription.getDescriptor(), fieldDescription.getGenericSignature(), this.defaultValue);
                    this.attributeAppender.apply(fieldVisitor, fieldDescription);
                    fieldVisitor.visitEnd();
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    Simple simple = (Simple)other;
                    return this.attributeAppender.equals(simple.attributeAppender) && !(this.defaultValue == null ? simple.defaultValue != null : !this.defaultValue.equals(simple.defaultValue));
                }

                public int hashCode() {
                    return 31 * this.attributeAppender.hashCode() + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                }

                public String toString() {
                    return "TypeWriter.FieldPool.Entry.Simple{attributeAppenderFactory=" + this.attributeAppender + ", defaultValue=" + this.defaultValue + '}';
                }
            }

            public static enum NoOp implements Entry
            {
                INSTANCE;


                @Override
                public FieldAttributeAppender getFieldAppender() {
                    return FieldAttributeAppender.NoOp.INSTANCE;
                }

                @Override
                public Object getDefaultValue() {
                    return null;
                }

                @Override
                public void apply(ClassVisitor classVisitor, FieldDescription fieldDescription) {
                    classVisitor.visitField(fieldDescription.getModifiers(), fieldDescription.getInternalName(), fieldDescription.getDescriptor(), fieldDescription.getGenericSignature(), null).visitEnd();
                }
            }
        }
    }

    public static interface Engine {
        public static final int ASM_MANUAL_FLAG = 0;
        public static final int ASM_API_VERSION = 327680;

        public byte[] create(Instrumentation.Context.ExtractableView var1);

        public static class ForCreation
        implements Engine {
            private final TypeDescription instrumentedType;
            private final ClassFileVersion classFileVersion;
            private final List<? extends MethodDescription> invokableMethods;
            private final ClassVisitorWrapper classVisitorWrapper;
            private final TypeAttributeAppender attributeAppender;
            private final FieldPool fieldPool;
            private final MethodPool methodPool;

            public ForCreation(TypeDescription instrumentedType, ClassFileVersion classFileVersion, List<? extends MethodDescription> invokableMethods, ClassVisitorWrapper classVisitorWrapper, TypeAttributeAppender attributeAppender, FieldPool fieldPool, MethodPool methodPool) {
                this.instrumentedType = instrumentedType;
                this.classFileVersion = classFileVersion;
                this.invokableMethods = invokableMethods;
                this.classVisitorWrapper = classVisitorWrapper;
                this.attributeAppender = attributeAppender;
                this.fieldPool = fieldPool;
                this.methodPool = methodPool;
            }

            @Override
            public byte[] create(Instrumentation.Context.ExtractableView instrumentationContext) {
                ClassWriter classWriter = new ClassWriter(0);
                ClassVisitor classVisitor = this.classVisitorWrapper.wrap(classWriter);
                classVisitor.visit(this.classFileVersion.getVersionNumber(), this.instrumentedType.getActualModifiers(true), this.instrumentedType.getInternalName(), this.instrumentedType.getGenericSignature(), this.instrumentedType.getSupertype().getInternalName(), this.instrumentedType.getInterfaces().toInternalNames());
                this.attributeAppender.apply(classVisitor, this.instrumentedType);
                for (FieldDescription fieldDescription : this.instrumentedType.getDeclaredFields()) {
                    this.fieldPool.target(fieldDescription).apply(classVisitor, fieldDescription);
                }
                for (MethodDescription methodDescription : this.invokableMethods) {
                    this.methodPool.target(methodDescription).apply(classVisitor, instrumentationContext, methodDescription);
                }
                instrumentationContext.drain(classVisitor, this.methodPool, Instrumentation.Context.ExtractableView.InjectedCode.None.INSTANCE);
                classVisitor.visitEnd();
                return classWriter.toByteArray();
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForCreation that = (ForCreation)other;
                return this.attributeAppender.equals(that.attributeAppender) && this.classFileVersion.equals(that.classFileVersion) && this.classVisitorWrapper.equals(that.classVisitorWrapper) && this.fieldPool.equals(that.fieldPool) && this.instrumentedType.equals(that.instrumentedType) && this.invokableMethods.equals(that.invokableMethods) && this.methodPool.equals(that.methodPool);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.classFileVersion.hashCode();
                result = 31 * result + this.invokableMethods.hashCode();
                result = 31 * result + this.classVisitorWrapper.hashCode();
                result = 31 * result + this.attributeAppender.hashCode();
                result = 31 * result + this.fieldPool.hashCode();
                result = 31 * result + this.methodPool.hashCode();
                return result;
            }

            public String toString() {
                return "TypeWriter.Engine.ForCreation{instrumentedType=" + this.instrumentedType + ", classFileVersion=" + this.classFileVersion + ", invokableMethods=" + this.invokableMethods + ", classVisitorWrapper=" + this.classVisitorWrapper + ", attributeAppender=" + this.attributeAppender + ", fieldPool=" + this.fieldPool + ", methodPool=" + this.methodPool + '}';
            }
        }

        public static class ForRedefinition
        implements Engine {
            private static final MethodVisitor IGNORE_METHOD = null;
            private final TypeDescription instrumentedType;
            private final TypeDescription targetType;
            private final ClassFileVersion classFileVersion;
            private final List<? extends MethodDescription> invokableMethods;
            private final ClassVisitorWrapper classVisitorWrapper;
            private final TypeAttributeAppender attributeAppender;
            private final FieldPool fieldPool;
            private final MethodPool methodPool;
            private final ClassFileLocator classFileLocator;
            private final MethodRebaseResolver methodRebaseResolver;

            public ForRedefinition(TypeDescription instrumentedType, TypeDescription targetType, ClassFileVersion classFileVersion, List<? extends MethodDescription> invokableMethods, ClassVisitorWrapper classVisitorWrapper, TypeAttributeAppender attributeAppender, FieldPool fieldPool, MethodPool methodPool, ClassFileLocator classFileLocator, MethodRebaseResolver methodRebaseResolver) {
                this.instrumentedType = instrumentedType;
                this.targetType = targetType;
                this.classFileVersion = classFileVersion;
                this.invokableMethods = invokableMethods;
                this.classVisitorWrapper = classVisitorWrapper;
                this.attributeAppender = attributeAppender;
                this.fieldPool = fieldPool;
                this.methodPool = methodPool;
                this.classFileLocator = classFileLocator;
                this.methodRebaseResolver = methodRebaseResolver;
            }

            @Override
            public byte[] create(Instrumentation.Context.ExtractableView instrumentationContext) {
                try {
                    TypeDescription.BinaryRepresentation binaryRepresentation = this.classFileLocator.classFileFor(this.targetType);
                    if (!binaryRepresentation.isValid()) {
                        throw new IllegalArgumentException("Cannot locate the class file for " + this.targetType + " using " + this.classFileLocator);
                    }
                    return this.doCreate(instrumentationContext, binaryRepresentation.getData());
                }
                catch (IOException e) {
                    throw new RuntimeException("The class file could not be written", e);
                }
            }

            private byte[] doCreate(Instrumentation.Context.ExtractableView instrumentationContext, byte[] binaryRepresentation) {
                ClassReader classReader = new ClassReader(binaryRepresentation);
                ClassWriter classWriter = new ClassWriter(classReader, 0);
                classReader.accept(this.writeTo(this.classVisitorWrapper.wrap(classWriter), instrumentationContext), 0);
                return classWriter.toByteArray();
            }

            private ClassVisitor writeTo(ClassVisitor classVisitor, Instrumentation.Context.ExtractableView instrumentationContext) {
                String originalName = this.targetType.getInternalName();
                String targetName = this.instrumentedType.getInternalName();
                RedefinitionClassVisitor targetClassVisitor = new RedefinitionClassVisitor(classVisitor, instrumentationContext);
                return originalName.equals(targetName) ? targetClassVisitor : new RemappingClassAdapter(targetClassVisitor, new SimpleRemapper(originalName, targetName));
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                ForRedefinition that = (ForRedefinition)other;
                return this.attributeAppender.equals(that.attributeAppender) && this.classFileLocator.equals(that.classFileLocator) && this.classFileVersion.equals(that.classFileVersion) && this.classVisitorWrapper.equals(that.classVisitorWrapper) && this.fieldPool.equals(that.fieldPool) && this.instrumentedType.equals(that.instrumentedType) && this.invokableMethods.equals(that.invokableMethods) && this.methodPool.equals(that.methodPool) && this.methodRebaseResolver.equals(that.methodRebaseResolver) && this.targetType.equals(that.targetType);
            }

            public int hashCode() {
                int result = this.instrumentedType.hashCode();
                result = 31 * result + this.targetType.hashCode();
                result = 31 * result + this.classFileVersion.hashCode();
                result = 31 * result + this.invokableMethods.hashCode();
                result = 31 * result + this.classVisitorWrapper.hashCode();
                result = 31 * result + this.attributeAppender.hashCode();
                result = 31 * result + this.fieldPool.hashCode();
                result = 31 * result + this.methodPool.hashCode();
                result = 31 * result + this.classFileLocator.hashCode();
                result = 31 * result + this.methodRebaseResolver.hashCode();
                return result;
            }

            public String toString() {
                return "TypeWriter.Engine.ForRedefinition{instrumentedType=" + this.instrumentedType + ", targetType=" + this.targetType + ", classFileVersion=" + this.classFileVersion + ", invokableMethods=" + this.invokableMethods + ", classVisitorWrapper=" + this.classVisitorWrapper + ", attributeAppender=" + this.attributeAppender + ", fieldPool=" + this.fieldPool + ", methodPool=" + this.methodPool + ", classFileLocator=" + this.classFileLocator + ", methodRebaseResolver=" + this.methodRebaseResolver + '}';
            }

            protected class RedefinitionClassVisitor
            extends ClassVisitor {
                private final Instrumentation.Context.ExtractableView instrumentationContext;
                private final Map<String, FieldDescription> declaredFields;
                private final Map<String, MethodDescription> declarableMethods;
                private Instrumentation.Context.ExtractableView.InjectedCode injectedCode;

                protected RedefinitionClassVisitor(ClassVisitor classVisitor, Instrumentation.Context.ExtractableView instrumentationContext) {
                    super(327680, classVisitor);
                    this.instrumentationContext = instrumentationContext;
                    FieldList fieldDescriptions = ForRedefinition.this.instrumentedType.getDeclaredFields();
                    this.declaredFields = new HashMap<String, FieldDescription>(fieldDescriptions.size());
                    for (FieldDescription fieldDescription : fieldDescriptions) {
                        this.declaredFields.put(fieldDescription.getInternalName(), fieldDescription);
                    }
                    this.declarableMethods = new HashMap<String, MethodDescription>(ForRedefinition.this.invokableMethods.size());
                    for (MethodDescription methodDescription : ForRedefinition.this.invokableMethods) {
                        this.declarableMethods.put(methodDescription.getUniqueSignature(), methodDescription);
                    }
                    this.injectedCode = Instrumentation.Context.ExtractableView.InjectedCode.None.INSTANCE;
                }

                @Override
                public void visit(int classFileVersionNumber, int modifiers, String internalName, String genericSignature, String superTypeInternalName, String[] interfaceTypeInternalName) {
                    ClassFileVersion originalClassFileVersion = new ClassFileVersion(classFileVersionNumber);
                    super.visit((ForRedefinition.this.classFileVersion.compareTo(originalClassFileVersion) > 0 ? ForRedefinition.this.classFileVersion : originalClassFileVersion).getVersionNumber(), ForRedefinition.this.instrumentedType.getActualModifiers((modifiers & 0x20) != 0), ForRedefinition.this.instrumentedType.getInternalName(), ForRedefinition.this.instrumentedType.getGenericSignature(), ForRedefinition.this.instrumentedType.getSupertype() == null ? null : ForRedefinition.this.instrumentedType.getSupertype().getInternalName(), ForRedefinition.this.instrumentedType.getInterfaces().toInternalNames());
                    ForRedefinition.this.attributeAppender.apply(this, ForRedefinition.this.instrumentedType);
                }

                @Override
                public FieldVisitor visitField(int modifiers, String internalName, String descriptor, String genericSignature, Object defaultValue) {
                    this.declaredFields.remove(internalName);
                    return super.visitField(modifiers, internalName, descriptor, genericSignature, defaultValue);
                }

                @Override
                public MethodVisitor visitMethod(int modifiers, String internalName, String descriptor, String genericSignature, String[] exceptionTypeInternalName) {
                    if (internalName.equals("<clinit>")) {
                        TypeInitializerInjection injectedCode = new TypeInitializerInjection();
                        this.injectedCode = injectedCode;
                        return super.visitMethod(injectedCode.getInjectorProxyMethod().getModifiers(), injectedCode.getInjectorProxyMethod().getInternalName(), injectedCode.getInjectorProxyMethod().getDescriptor(), injectedCode.getInjectorProxyMethod().getGenericSignature(), injectedCode.getInjectorProxyMethod().getExceptionTypes().toInternalNames());
                    }
                    MethodDescription methodDescription = this.declarableMethods.remove(internalName + descriptor);
                    return methodDescription == null ? super.visitMethod(modifiers, internalName, descriptor, genericSignature, exceptionTypeInternalName) : this.redefine(methodDescription, (modifiers & 0x400) != 0);
                }

                private MethodVisitor redefine(MethodDescription methodDescription, boolean abstractOrigin) {
                    MethodPool.Entry entry = ForRedefinition.this.methodPool.target(methodDescription);
                    if (!entry.isDefineMethod()) {
                        return super.visitMethod(methodDescription.getModifiers(), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getGenericSignature(), methodDescription.getExceptionTypes().toInternalNames());
                    }
                    MethodVisitor methodVisitor = super.visitMethod(methodDescription.getAdjustedModifiers(entry.getByteCodeAppender().appendsCode()), methodDescription.getInternalName(), methodDescription.getDescriptor(), methodDescription.getGenericSignature(), methodDescription.getExceptionTypes().toInternalNames());
                    entry.getAttributeAppender().apply(methodVisitor, methodDescription);
                    return abstractOrigin ? new AttributeObtainingMethodVisitor(methodVisitor, entry.getByteCodeAppender(), methodDescription) : new CodePreservingMethodVisitor(methodVisitor, entry.getByteCodeAppender(), methodDescription);
                }

                @Override
                public void visitEnd() {
                    for (FieldDescription fieldDescription : this.declaredFields.values()) {
                        ForRedefinition.this.fieldPool.target(fieldDescription).apply(this.cv, fieldDescription);
                    }
                    for (MethodDescription methodDescription : this.declarableMethods.values()) {
                        ForRedefinition.this.methodPool.target(methodDescription).apply(this.cv, this.instrumentationContext, methodDescription);
                    }
                    this.instrumentationContext.drain(this.cv, ForRedefinition.this.methodPool, this.injectedCode);
                    super.visitEnd();
                }

                private class TypeInitializerInjection
                implements Instrumentation.Context.ExtractableView.InjectedCode {
                    private static final int TYPE_INITIALIZER_PROXY_MODIFIERS = 4106;
                    private static final String TYPE_INITIALIZER_PROXY_PREFIX = "originalTypeInitializer";
                    private final MethodDescription injectorProxyMethod;

                    private TypeInitializerInjection() {
                        this.injectorProxyMethod = new MethodDescription.Latent(String.format("%s$%s", TYPE_INITIALIZER_PROXY_PREFIX, RandomString.make()), ForRedefinition.this.instrumentedType, new TypeDescription.ForLoadedType(Void.TYPE), new TypeList.Empty(), 4106, Collections.emptyList());
                    }

                    @Override
                    public StackManipulation getInjectedCode() {
                        return MethodInvocation.invoke(this.injectorProxyMethod);
                    }

                    @Override
                    public boolean isInjected() {
                        return true;
                    }

                    public MethodDescription getInjectorProxyMethod() {
                        return this.injectorProxyMethod;
                    }

                    public String toString() {
                        return "TypeWriter.Engine.ForRedefinition.RedefinitionClassVisitor.TypeInitializerInjection{injectorProxyMethod=" + this.injectorProxyMethod + '}';
                    }
                }

                private class AttributeObtainingMethodVisitor
                extends MethodVisitor {
                    private final MethodVisitor actualMethodVisitor;
                    private final ByteCodeAppender byteCodeAppender;
                    private final MethodDescription methodDescription;

                    public AttributeObtainingMethodVisitor(MethodVisitor actualMethodVisitor, ByteCodeAppender byteCodeAppender, MethodDescription methodDescription) {
                        super(327680, actualMethodVisitor);
                        this.actualMethodVisitor = actualMethodVisitor;
                        this.byteCodeAppender = byteCodeAppender;
                        this.methodDescription = methodDescription;
                    }

                    @Override
                    public void visitCode() {
                        this.mv = IGNORE_METHOD;
                    }

                    @Override
                    public void visitEnd() {
                        if (this.byteCodeAppender.appendsCode()) {
                            this.actualMethodVisitor.visitCode();
                            ByteCodeAppender.Size size = this.byteCodeAppender.apply(this.actualMethodVisitor, RedefinitionClassVisitor.this.instrumentationContext, this.methodDescription);
                            this.actualMethodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                        }
                        this.actualMethodVisitor.visitEnd();
                    }

                    public String toString() {
                        return "TypeWriter.Engine.ForRedefinition.RedefinitionClassVisitor.AttributeObtainingMethodVisitor{actualMethodVisitor=" + this.actualMethodVisitor + ", byteCodeAppender=" + this.byteCodeAppender + ", methodDescription=" + this.methodDescription + '}';
                    }
                }

                private class CodePreservingMethodVisitor
                extends MethodVisitor {
                    private final MethodVisitor actualMethodVisitor;
                    private final ByteCodeAppender byteCodeAppender;
                    private final MethodDescription methodDescription;
                    private final MethodRebaseResolver.Resolution resolution;

                    private CodePreservingMethodVisitor(MethodVisitor actualMethodVisitor, ByteCodeAppender byteCodeAppender, MethodDescription methodDescription) {
                        super(327680, actualMethodVisitor);
                        this.actualMethodVisitor = actualMethodVisitor;
                        this.byteCodeAppender = byteCodeAppender;
                        this.methodDescription = methodDescription;
                        this.resolution = ForRedefinition.this.methodRebaseResolver.resolve(methodDescription);
                    }

                    @Override
                    public void visitCode() {
                        if (this.byteCodeAppender.appendsCode()) {
                            this.actualMethodVisitor.visitCode();
                            ByteCodeAppender.Size size = this.byteCodeAppender.apply(this.actualMethodVisitor, RedefinitionClassVisitor.this.instrumentationContext, this.methodDescription);
                            this.actualMethodVisitor.visitMaxs(size.getOperandStackSize(), size.getLocalVariableSize());
                        }
                        this.actualMethodVisitor.visitEnd();
                        this.mv = this.resolution.isRebased() ? RedefinitionClassVisitor.this.cv.visitMethod(this.resolution.getResolvedMethod().getModifiers(), this.resolution.getResolvedMethod().getInternalName(), this.resolution.getResolvedMethod().getDescriptor(), this.resolution.getResolvedMethod().getGenericSignature(), this.resolution.getResolvedMethod().getExceptionTypes().toInternalNames()) : IGNORE_METHOD;
                        super.visitCode();
                    }

                    @Override
                    public void visitMaxs(int maxStack, int maxLocals) {
                        super.visitMaxs(maxStack, Math.max(maxLocals, this.resolution.getResolvedMethod().getStackSize()));
                    }

                    public String toString() {
                        return "TypeWriter.Engine.ForRedefinition.RedefinitionClassVisitor.CodePreservingMethodVisitor{actualMethodVisitor=" + this.actualMethodVisitor + ", byteCodeAppender=" + this.byteCodeAppender + ", methodDescription=" + this.methodDescription + ", resolution=" + this.resolution + '}';
                    }
                }
            }
        }
    }
}

