/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold.inline;

import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.Arrays;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.utility.ByteBuddyCommons;
import net.bytebuddy.utility.StreamDrainer;

public interface ClassFileLocator {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public TypeDescription.BinaryRepresentation classFileFor(TypeDescription var1) throws IOException;

    public static class Compound
    implements ClassFileLocator {
        private final ClassFileLocator[] classFileLocator;

        public Compound(ClassFileLocator ... classFileLocator) {
            this.classFileLocator = classFileLocator;
        }

        public static ClassFileLocator makeDefault() {
            return new Compound(Default.ATTACHED, Default.CLASS_PATH);
        }

        @Override
        public TypeDescription.BinaryRepresentation classFileFor(TypeDescription typeDescription) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocator) {
                TypeDescription.BinaryRepresentation binaryRepresentation = classFileLocator.classFileFor(typeDescription);
                if (!binaryRepresentation.isValid()) continue;
                return binaryRepresentation;
            }
            return null;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && Arrays.equals(this.classFileLocator, ((Compound)other).classFileLocator);
        }

        public int hashCode() {
            return Arrays.hashCode(this.classFileLocator);
        }

        public String toString() {
            return "ClassFileLocator.Compound{classFileLocator=" + Arrays.toString(this.classFileLocator) + '}';
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String BYTE_BUDDY_AGENT_TYPE = "net.bytebuddy.agent.ByteBuddyAgent";
        private static final String GET_INSTRUMENTATION_METHOD = "getInstrumentation";
        private static final Object STATIC_METHOD = null;
        private final Instrumentation instrumentation;
        private final ClassLoader classLoader;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoader = ByteBuddyCommons.nonNull(classLoader);
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                return new AgentBased((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(BYTE_BUDDY_AGENT_TYPE).getDeclaredMethod(GET_INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_METHOD, new Object[0]), classLoader);
            }
            catch (Exception e) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TypeDescription.BinaryRepresentation classFileFor(TypeDescription typeDescription) {
            TypeDescription.BinaryRepresentation binaryRepresentation;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoader, typeDescription);
            try {
                this.instrumentation.addTransformer(classFileTransformer, true);
                this.instrumentation.retransformClasses(this.classLoader.loadClass(typeDescription.getName()));
                byte[] binaryRepresentation2 = classFileTransformer.getClassFile();
                binaryRepresentation = binaryRepresentation2 == null ? TypeDescription.BinaryRepresentation.Illegal.INSTANCE : new TypeDescription.BinaryRepresentation.Explicit(binaryRepresentation2);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (Exception ignored) {
                    return null;
                }
            }
            return binaryRepresentation;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classLoader.equals(((AgentBased)other).classLoader) && this.instrumentation.equals(((AgentBased)other).instrumentation);
        }

        public int hashCode() {
            return 31 * this.instrumentation.hashCode() + this.classLoader.hashCode();
        }

        public String toString() {
            return "ClassFileLocator.AgentBased{instrumentation=" + this.instrumentation + ", classLoader=" + this.classLoader + '}';
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private final ClassLoader classLoader;
            private final TypeDescription typeDescription;
            private volatile byte[] classFile;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, TypeDescription typeDescription) {
                this.classLoader = classLoader;
                this.typeDescription = typeDescription;
            }

            @Override
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] classFile) throws IllegalClassFormatException {
                if (this.isChild(classLoader) && this.typeDescription.represents(redefinedType)) {
                    this.classFile = classFile;
                }
                return classFile;
            }

            private boolean isChild(ClassLoader classLoader) {
                if (this.classLoader == null) {
                    return true;
                }
                do {
                    if (classLoader != this.classLoader) continue;
                    return true;
                } while ((classLoader = classLoader.getParent()) != null);
                return false;
            }

            protected byte[] getClassFile() {
                return this.classFile;
            }

            public String toString() {
                return "ClassFileLocator.AgentBased.ExtractionClassFileTransformer{classLoader=" + this.classLoader + ", typeDescription=" + this.typeDescription + ", classFile=" + Arrays.toString(this.classFile) + '}';
            }
        }
    }

    public static enum Default implements ClassFileLocator
    {
        CLASS_PATH{

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TypeDescription.BinaryRepresentation classFileFor(TypeDescription typeDescription) throws IOException {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(typeDescription.getInternalName() + ClassFileLocator.CLASS_FILE_EXTENSION);
                if (inputStream != null) {
                    try {
                        TypeDescription.BinaryRepresentation.Explicit explicit = new TypeDescription.BinaryRepresentation.Explicit(new StreamDrainer().drain(inputStream));
                        return explicit;
                    }
                    finally {
                        inputStream.close();
                    }
                }
                return TypeDescription.BinaryRepresentation.Illegal.INSTANCE;
            }
        }
        ,
        ATTACHED{

            @Override
            public TypeDescription.BinaryRepresentation classFileFor(TypeDescription typeDescription) {
                return typeDescription.toBinary();
            }
        };

    }
}

