/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.Duplication;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.Throw;
import net.bytebuddy.instrumentation.method.bytecode.stack.TypeCreation;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.TextConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public class ExceptionMethod
implements Instrumentation,
ByteCodeAppender {
    private final TypeDescription throwableType;
    private final ConstructionDelegate constructionDelegate;

    public ExceptionMethod(TypeDescription throwableType, ConstructionDelegate constructionDelegate) {
        this.throwableType = throwableType;
        this.constructionDelegate = constructionDelegate;
    }

    public static Instrumentation throwing(Class<? extends Throwable> throwable) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(throwable)));
    }

    public static Instrumentation throwing(TypeDescription throwable) {
        if (!throwable.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(throwable + " does not extend throwable");
        }
        return new ExceptionMethod(ByteBuddyCommons.nonNull(throwable), new ConstructionDelegate.ForDefaultConstructor(throwable));
    }

    public static Instrumentation throwing(Class<? extends Throwable> exceptionType, String message) {
        return ExceptionMethod.throwing(new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(exceptionType)), message);
    }

    public static Instrumentation throwing(TypeDescription exceptionType, String message) {
        if (!exceptionType.isAssignableTo(Throwable.class)) {
            throw new IllegalArgumentException(exceptionType + " does not extend throwable");
        }
        return new ExceptionMethod(ByteBuddyCommons.nonNull(exceptionType), new ConstructionDelegate.ForStringConstructor(exceptionType, ByteBuddyCommons.nonNull(message)));
    }

    @Override
    public InstrumentedType prepare(InstrumentedType instrumentedType) {
        return instrumentedType;
    }

    @Override
    public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
        return this;
    }

    @Override
    public boolean appendsCode() {
        return true;
    }

    @Override
    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
        StackManipulation.Size stackSize = new StackManipulation.Compound(this.constructionDelegate.make(), Throw.INSTANCE).apply(methodVisitor, instrumentationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.constructionDelegate.equals(((ExceptionMethod)other).constructionDelegate) && this.throwableType.equals(((ExceptionMethod)other).throwableType);
    }

    public int hashCode() {
        return 31 * this.throwableType.hashCode() + this.constructionDelegate.hashCode();
    }

    public String toString() {
        return "ExceptionMethod{throwableType=" + this.throwableType + ", constructionDelegate=" + this.constructionDelegate + '}';
    }

    public static interface ConstructionDelegate {
        public StackManipulation make();

        public static class ForStringConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;
            private final String message;

            public ForStringConstructor(TypeDescription exceptionType, String message) {
                this.exceptionType = exceptionType;
                this.targetConstructor = exceptionType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.takesArguments(String.class))).getOnly();
                this.message = message;
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.forType(this.exceptionType), Duplication.SINGLE, new TextConstant(this.message), MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.message.equals(((ForStringConstructor)other).message) && this.exceptionType.equals(((ForStringConstructor)other).exceptionType);
            }

            public int hashCode() {
                return 31 * this.exceptionType.hashCode() + this.message.hashCode();
            }

            public String toString() {
                return "ExceptionMethod.ConstructionDelegate.ForStringConstructor{exceptionType=" + this.exceptionType + ", targetConstructor=" + this.targetConstructor + ", message='" + this.message + '\'' + '}';
            }
        }

        public static class ForDefaultConstructor
        implements ConstructionDelegate {
            private final TypeDescription exceptionType;
            private final MethodDescription targetConstructor;

            public ForDefaultConstructor(TypeDescription exceptionType) {
                this.exceptionType = exceptionType;
                this.targetConstructor = exceptionType.getDeclaredMethods().filter(MethodMatchers.isConstructor().and(MethodMatchers.takesArguments(0))).getOnly();
            }

            @Override
            public StackManipulation make() {
                return new StackManipulation.Compound(TypeCreation.forType(this.exceptionType), Duplication.SINGLE, MethodInvocation.invoke(this.targetConstructor));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.exceptionType.equals(((ForDefaultConstructor)other).exceptionType);
            }

            public int hashCode() {
                return this.exceptionType.hashCode();
            }

            public String toString() {
                return "ExceptionMethod.ConstructionDelegate.ForDefaultConstructor{exceptionType=" + this.exceptionType + ", targetConstructor=" + this.targetConstructor + '}';
            }
        }
    }
}

