/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.LoadedTypeInitializer;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.bytecode.ByteCodeAppender;
import net.bytebuddy.instrumentation.method.bytecode.stack.StackManipulation;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.PrimitiveTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.primitive.VoidAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.instrumentation.method.bytecode.stack.collection.ArrayFactory;
import net.bytebuddy.instrumentation.method.bytecode.stack.constant.MethodConstant;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.FieldAccess;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodInvocation;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodReturn;
import net.bytebuddy.instrumentation.method.bytecode.stack.member.MethodVariableAccess;
import net.bytebuddy.instrumentation.type.InstrumentedType;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.utility.ByteBuddyCommons;

public abstract class InvocationHandlerAdapter
implements Instrumentation {
    private static final String PREFIX = "invocationHandler";
    protected final String fieldName;
    protected final Assigner assigner;
    protected final boolean cacheMethods;

    protected InvocationHandlerAdapter(String fieldName, boolean cacheMethods) {
        this.fieldName = fieldName;
        this.cacheMethods = cacheMethods;
        this.assigner = new VoidAwareAssigner(new PrimitiveTypeAwareAssigner(ReferenceTypeAwareAssigner.INSTANCE), true);
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler) {
        return InvocationHandlerAdapter.of(invocationHandler, String.format("%s$%d", PREFIX, Math.abs(invocationHandler.hashCode())));
    }

    public static InvocationHandlerAdapter of(InvocationHandler invocationHandler, String fieldName) {
        return new ForStaticDelegation(ByteBuddyCommons.nonNull(invocationHandler), ByteBuddyCommons.isValidIdentifier(fieldName), false);
    }

    public static InvocationHandlerAdapter toInstanceField(String fieldName) {
        return new ForInstanceDelegation(ByteBuddyCommons.isValidIdentifier(fieldName), false);
    }

    private static List<StackManipulation> argumentValuesOf(MethodDescription instrumentedMethod) {
        TypeList parameterTypes = instrumentedMethod.getParameterTypes();
        ArrayList<StackManipulation> instruction = new ArrayList<StackManipulation>(parameterTypes.size());
        int currentIndex = 1;
        for (TypeDescription parameterType : parameterTypes) {
            instruction.add(MethodVariableAccess.forType(parameterType).loadFromIndex(currentIndex));
            currentIndex += parameterType.getStackSize().getSize();
        }
        return instruction;
    }

    public abstract Instrumentation withMethodCache();

    protected ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod, TypeDescription instrumentedType, StackManipulation preparingManipulation) {
        TypeDescription.ForLoadedType objectType = new TypeDescription.ForLoadedType(Object.class);
        TypeDescription.ForLoadedType invocationHandlerType = new TypeDescription.ForLoadedType(InvocationHandler.class);
        StackManipulation.Size stackSize = new StackManipulation.Compound(preparingManipulation, FieldAccess.forField(instrumentedType.getDeclaredFields().named(this.fieldName)).getter(), MethodVariableAccess.forType(objectType).loadFromIndex(0), this.cacheMethods ? MethodConstant.forMethod(instrumentedMethod).cached() : MethodConstant.forMethod(instrumentedMethod), ArrayFactory.targeting(objectType).withValues(InvocationHandlerAdapter.argumentValuesOf(instrumentedMethod)), MethodInvocation.invoke(invocationHandlerType.getDeclaredMethods().getOnly()), this.assigner.assign(objectType, instrumentedMethod.getReturnType(), true), MethodReturn.returning(instrumentedMethod.getReturnType())).apply(methodVisitor, instrumentationContext);
        return new ByteCodeAppender.Size(stackSize.getMaximalSize(), instrumentedMethod.getStackSize());
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.cacheMethods == ((InvocationHandlerAdapter)other).cacheMethods && this.fieldName.equals(((InvocationHandlerAdapter)other).fieldName);
    }

    public int hashCode() {
        return 31 * this.fieldName.hashCode() + (this.cacheMethods ? 1 : 0);
    }

    protected static class ForInstanceDelegation
    extends InvocationHandlerAdapter {
        protected ForInstanceDelegation(String fieldName, boolean cacheMethods) {
            super(fieldName, cacheMethods);
        }

        @Override
        public Instrumentation withMethodCache() {
            return new ForInstanceDelegation(this.fieldName, true);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(InvocationHandler.class), 1);
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForInstanceDelegation{fieldName=" + this.fieldName + "cacheMethods=" + this.cacheMethods + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForInstanceDelegation.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.instrumentedType, MethodVariableAccess.forType(this.instrumentedType).loadFromIndex(0));
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForInstanceDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForInstanceDelegation.this;
            }

            public int hashCode() {
                return 31 * ForInstanceDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForInstanceDelegation.Appender{invocationHandlerAdapter=" + ForInstanceDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }

    protected static class ForStaticDelegation
    extends InvocationHandlerAdapter {
        protected final InvocationHandler invocationHandler;

        private ForStaticDelegation(InvocationHandler invocationHandler, String fieldName, boolean cacheMethods) {
            super(fieldName, cacheMethods);
            this.invocationHandler = invocationHandler;
        }

        @Override
        public Instrumentation withMethodCache() {
            return new ForStaticDelegation(this.invocationHandler, this.fieldName, true);
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType.withField(this.fieldName, new TypeDescription.ForLoadedType(InvocationHandler.class), 8).withInitializer(LoadedTypeInitializer.ForStaticField.nonAccessible(this.fieldName, this.invocationHandler));
        }

        @Override
        public ByteCodeAppender appender(Instrumentation.Target instrumentationTarget) {
            return new Appender(instrumentationTarget.getTypeDescription());
        }

        @Override
        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.invocationHandler.equals(((ForStaticDelegation)other).invocationHandler);
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + this.invocationHandler.hashCode();
        }

        public String toString() {
            return "InvocationHandlerAdapter.ForStaticDelegation{fieldName=" + this.fieldName + ", cacheMethods=" + this.cacheMethods + ", invocationHandler=" + this.invocationHandler + '}';
        }

        protected class Appender
        implements ByteCodeAppender {
            private final TypeDescription instrumentedType;

            protected Appender(TypeDescription instrumentedType) {
                this.instrumentedType = instrumentedType;
            }

            @Override
            public boolean appendsCode() {
                return true;
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Instrumentation.Context instrumentationContext, MethodDescription instrumentedMethod) {
                return ForStaticDelegation.this.apply(methodVisitor, instrumentationContext, instrumentedMethod, this.instrumentedType, StackManipulation.LegalTrivial.INSTANCE);
            }

            private InvocationHandlerAdapter getInvocationHandlerAdapter() {
                return ForStaticDelegation.this;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.instrumentedType.equals(((Appender)other).instrumentedType) && ForStaticDelegation.this.equals(((Appender)other).getInvocationHandlerAdapter());
            }

            public int hashCode() {
                return 31 * ForStaticDelegation.this.hashCode() + this.instrumentedType.hashCode();
            }

            public String toString() {
                return "InvocationHandlerAdapter.ForStaticDelegation.Appender{invocationHandlerAdapter=" + ForStaticDelegation.this + "instrumentedType=" + this.instrumentedType + '}';
            }
        }
    }
}

