/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.attribute.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.type.TypeDescription;

public interface AnnotationList
extends List<AnnotationDescription> {
    public boolean isAnnotationPresent(Class<? extends Annotation> var1);

    public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> var1);

    public AnnotationList inherited(Set<? extends TypeDescription> var1);

    public AnnotationList subList(int var1, int var2);

    public static class Explicit
    extends AbstractList<AnnotationDescription>
    implements AnnotationList {
        private final List<? extends AnnotationDescription> annotationDescriptions;

        public Explicit(List<? extends AnnotationDescription> annotationDescriptions) {
            this.annotationDescriptions = annotationDescriptions;
        }

        public static List<AnnotationList> asList(List<? extends List<? extends AnnotationDescription>> annotations) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(annotations.size());
            for (List<? extends AnnotationDescription> list : annotations) {
                result.add(new Explicit(list));
            }
            return result;
        }

        @Override
        public AnnotationDescription get(int index) {
            return this.annotationDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.annotationDescriptions.size();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (AnnotationDescription annotationDescription : this.annotationDescriptions) {
                if (!annotationDescription.getAnnotationType().represents(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            for (AnnotationDescription annotationDescription : this.annotationDescriptions) {
                if (!annotationDescription.getAnnotationType().represents(annotationType)) continue;
                return annotationDescription.prepare(annotationType);
            }
            return null;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            LinkedList<AnnotationDescription> inherited = new LinkedList<AnnotationDescription>();
            for (AnnotationDescription annotationDescription : this.annotationDescriptions) {
                TypeDescription annotationType = annotationDescription.getAnnotationType();
                if (ignoredTypes.contains(annotationType) || !annotationType.getDeclaredAnnotations().isAnnotationPresent(Inherited.class)) continue;
                inherited.add(annotationDescription);
            }
            return new Explicit(new ArrayList(inherited));
        }

        @Override
        public AnnotationList subList(int fromIndex, int toIndex) {
            return new Explicit(super.subList(fromIndex, toIndex));
        }
    }

    public static class Empty
    extends AbstractList<AnnotationDescription>
    implements AnnotationList {
        public static List<AnnotationList> asList(int length) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(length);
            for (int i = 0; i < length; ++i) {
                result.add(new Empty());
            }
            return result;
        }

        @Override
        public AnnotationDescription get(int index) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return false;
        }

        @Override
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            return null;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            return this;
        }

        @Override
        public AnnotationList subList(int fromIndex, int toIndex) {
            if (fromIndex == toIndex && toIndex == 0) {
                return this;
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
    }

    public static class ForLoadedAnnotation
    extends AbstractList<AnnotationDescription>
    implements AnnotationList {
        private final Annotation[] annotation;

        public ForLoadedAnnotation(Annotation ... annotation) {
            this.annotation = annotation;
        }

        public static List<AnnotationList> asList(Annotation[][] annotations) {
            ArrayList<AnnotationList> result = new ArrayList<AnnotationList>(annotations.length);
            for (Annotation[] annotation : annotations) {
                result.add(new ForLoadedAnnotation(annotation));
            }
            return result;
        }

        @Override
        public AnnotationDescription get(int index) {
            return AnnotationDescription.ForLoadedAnnotation.of(this.annotation[index]);
        }

        @Override
        public int size() {
            return this.annotation.length;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            for (Annotation anAnnotation : this.annotation) {
                if (!anAnnotation.annotationType().equals(annotationType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends Annotation> AnnotationDescription.Loadable<T> ofType(Class<T> annotationType) {
            for (Annotation anAnnotation : this.annotation) {
                if (!anAnnotation.annotationType().equals(annotationType)) continue;
                return AnnotationDescription.ForLoadedAnnotation.of((Annotation)annotationType.cast(anAnnotation));
            }
            return null;
        }

        @Override
        public AnnotationList inherited(Set<? extends TypeDescription> ignoredTypes) {
            LinkedList<Annotation> inherited = new LinkedList<Annotation>();
            for (Annotation annotation : this.annotation) {
                if (ignoredTypes.contains(new TypeDescription.ForLoadedType(annotation.annotationType())) || !annotation.annotationType().isAnnotationPresent(Inherited.class)) continue;
                inherited.add(annotation);
            }
            return new ForLoadedAnnotation(inherited.toArray(new Annotation[inherited.size()]));
        }

        @Override
        public AnnotationList subList(int fromIndex, int toIndex) {
            return new Explicit(super.subList(fromIndex, toIndex));
        }
    }
}

