/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.ByteCodeElement;
import net.bytebuddy.instrumentation.ModifierReviewable;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationList;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.TypeList;
import net.bytebuddy.jar.asm.Type;

public interface MethodDescription
extends ByteCodeElement {
    public static final String CONSTRUCTOR_INTERNAL_NAME = "<init>";
    public static final String TYPE_INITIALIZER_INTERNAL_NAME = "<clinit>";
    public static final int TYPE_INITIALIZER_MODIFIER = 4106;

    public TypeDescription getReturnType();

    public TypeList getParameterTypes();

    public List<AnnotationList> getParameterAnnotations();

    public TypeList getExceptionTypes();

    public int getAdjustedModifiers(boolean var1);

    public boolean isConstructor();

    public boolean isMethod();

    public boolean isTypeInitializer();

    public boolean represents(Method var1);

    public boolean represents(Constructor<?> var1);

    public boolean isOverridable();

    public int getStackSize();

    public int getParameterOffset(int var1);

    public boolean isDefaultMethod();

    public boolean isSpecializableFor(TypeDescription var1);

    public String getUniqueSignature();

    public Object getDefaultValue();

    public <T> T getDefaultValue(Class<T> var1);

    public static class Latent
    extends AbstractMethodDescription {
        private final String internalName;
        private final TypeDescription declaringType;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;
        private final int modifiers;
        private final List<? extends TypeDescription> exceptionTypes;

        public Latent(String internalName, TypeDescription declaringType, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, int modifiers, List<? extends TypeDescription> exceptionTypes) {
            this.internalName = internalName;
            this.declaringType = declaringType;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.modifiers = modifiers;
            this.exceptionTypes = exceptionTypes;
        }

        public static MethodDescription typeInitializerOf(TypeDescription declaringType) {
            return new Latent(MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME, declaringType, new TypeDescription.ForLoadedType(Void.TYPE), new TypeList.Empty(), 4106, Collections.emptyList());
        }

        @Override
        public TypeDescription getReturnType() {
            return this.returnType;
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.Explicit(this.parameterTypes);
        }

        @Override
        public List<AnnotationList> getParameterAnnotations() {
            return AnnotationList.Empty.asList(this.parameterTypes.size());
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.Explicit(this.exceptionTypes);
        }

        @Override
        public boolean isConstructor() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME.equals(this.internalName);
        }

        @Override
        public boolean isTypeInitializer() {
            return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME.equals(this.internalName);
        }

        @Override
        public boolean represents(Method method) {
            return this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    public static class ForLoadedMethod
    extends AbstractMethodDescription {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.method.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return new TypeDescription.ForLoadedType(this.method.getReturnType());
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.ForLoadedType(this.method.getParameterTypes());
        }

        @Override
        public List<AnnotationList> getParameterAnnotations() {
            return AnnotationList.ForLoadedAnnotation.asList(this.method.getParameterAnnotations());
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.method.getExceptionTypes());
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }

        @Override
        public boolean represents(Method method) {
            return this.method.equals(method);
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.method.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return this.method.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getMethodDescriptor(this.method);
        }

        public Method getLoadedMethod() {
            return this.method;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.method.getDeclaredAnnotations());
        }

        @Override
        public Object getDefaultValue() {
            Object value = this.method.getDefaultValue();
            return value == null ? null : AnnotationDescription.ForLoadedAnnotation.wrap(value, new TypeDescription.ForLoadedType(this.method.getReturnType()));
        }
    }

    public static class ForLoadedConstructor
    extends AbstractMethodDescription {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.constructor.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return new TypeDescription.ForLoadedType(Void.TYPE);
        }

        @Override
        public TypeList getParameterTypes() {
            return new TypeList.ForLoadedType(this.constructor.getParameterTypes());
        }

        @Override
        public List<AnnotationList> getParameterAnnotations() {
            return AnnotationList.ForLoadedAnnotation.asList(this.constructor.getParameterAnnotations());
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.constructor.getExceptionTypes());
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.constructor.equals(constructor);
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.constructor.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME;
        }

        @Override
        public String getDescriptor() {
            return Type.getConstructorDescriptor(this.constructor);
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.constructor.getDeclaredAnnotations());
        }
    }

    public static abstract class AbstractMethodDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements MethodDescription {
        private static final int SOURCE_MODIFIERS = 1343;

        @Override
        public String getUniqueSignature() {
            return this.getInternalName() + this.getDescriptor();
        }

        @Override
        public int getStackSize() {
            return this.getParameterTypes().getStackSize() + (this.isStatic() ? 0 : 1);
        }

        @Override
        public boolean isMethod() {
            return !this.isConstructor() && !this.isTypeInitializer();
        }

        @Override
        public String getName() {
            return this.isMethod() ? this.getInternalName() : this.getDeclaringType().getName();
        }

        @Override
        public String getDescriptor() {
            StringBuilder descriptor = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameterTypes()) {
                descriptor.append(parameterType.getDescriptor());
            }
            return descriptor.append(")").append(this.getReturnType().getDescriptor()).toString();
        }

        @Override
        public String getGenericSignature() {
            return null;
        }

        @Override
        public int getAdjustedModifiers(boolean nonAbstract) {
            return nonAbstract ? this.getModifiers() & 0xFFFFFAFF : this.getModifiers() & 0xFFFFFEFF | 0x400;
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.getDeclaringType().isVisibleTo(typeDescription) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType()));
        }

        @Override
        public boolean isOverridable() {
            return !this.isConstructor() && !this.isFinal() && !this.isPrivate() && !this.isStatic() && !this.getDeclaringType().isFinal();
        }

        @Override
        public int getParameterOffset(int parameterIndex) {
            int offset = this.isStatic() ? 0 : 1;
            int currentIndex = 0;
            for (TypeDescription parameterType : this.getParameterTypes()) {
                if (currentIndex == parameterIndex) {
                    return offset;
                }
                ++currentIndex;
                offset += parameterType.getStackSize().getSize();
            }
            throw new IllegalArgumentException(this + " does not have a parameter of index " + parameterIndex);
        }

        @Override
        public boolean isDefaultMethod() {
            return !this.isAbstract() && !this.isBridge() && this.getDeclaringType().isInterface();
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            if (this.isStatic()) {
                return false;
            }
            if (this.isPrivate() || this.isConstructor() || this.isDefaultMethod()) {
                return this.getDeclaringType().equals(targetType);
            }
            return !this.isAbstract() && this.getDeclaringType().isAssignableFrom(targetType);
        }

        @Override
        public <T> T getDefaultValue(Class<T> type) {
            return type.cast(this.getDefaultValue());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof MethodDescription && this.getInternalName().equals(((MethodDescription)other).getInternalName()) && this.getDeclaringType().equals(((MethodDescription)other).getDeclaringType()) && this.getReturnType().equals(((MethodDescription)other).getReturnType()) && this.getParameterTypes().equals(((MethodDescription)other).getParameterTypes());
        }

        public int hashCode() {
            int hashCode = this.getDeclaringType().hashCode();
            hashCode = 31 * hashCode + this.getInternalName().hashCode();
            hashCode = 31 * hashCode + this.getReturnType().hashCode();
            return 31 * hashCode + this.getParameterTypes().hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (TypeDescription typeDescription : this.getParameterTypes()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            TypeList exceptionTypes = this.getExceptionTypes();
            if (exceptionTypes.size() > 0) {
                stringBuilder.append(" throws ");
                first = true;
                for (TypeDescription typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getName());
                }
            }
            return stringBuilder.toString();
        }
    }
}

