/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.matcher.MethodMatcher;

public interface MethodList
extends List<MethodDescription> {
    public MethodList filter(MethodMatcher var1);

    public MethodList subList(int var1, int var2);

    public MethodDescription getOnly();

    public static class Empty
    extends AbstractList<MethodDescription>
    implements MethodList {
        @Override
        public MethodDescription get(int index) {
            throw new IndexOutOfBoundsException("index = " + index);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public MethodList filter(MethodMatcher methodMatcher) {
            return this;
        }

        @Override
        public MethodDescription getOnly() {
            throw new IllegalStateException("Expected to find exactly one method but found none");
        }

        @Override
        public MethodList subList(int fromIndex, int toIndex) {
            if (fromIndex == toIndex && toIndex == 0) {
                return this;
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
    }

    public static class Explicit
    extends AbstractList<MethodDescription>
    implements MethodList {
        private final List<? extends MethodDescription> methodDescriptions;

        public Explicit(List<? extends MethodDescription> methodDescriptions) {
            this.methodDescriptions = Collections.unmodifiableList(methodDescriptions);
        }

        @Override
        public MethodDescription get(int index) {
            return this.methodDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.methodDescriptions.size();
        }

        @Override
        public MethodList filter(MethodMatcher methodMatcher) {
            ArrayList<MethodDescription> result = new ArrayList<MethodDescription>(this.methodDescriptions.size());
            for (MethodDescription methodDescription : this.methodDescriptions) {
                if (!methodMatcher.matches(methodDescription)) continue;
                result.add(methodDescription);
            }
            return new Explicit(result);
        }

        @Override
        public MethodDescription getOnly() {
            if (this.methodDescriptions.size() == 1) {
                return this.methodDescriptions.get(0);
            }
            throw new IllegalStateException("Expected to find exactly one method but found " + this.methodDescriptions.size());
        }

        @Override
        public MethodList subList(int fromIndex, int toIndex) {
            return new Explicit(super.subList(fromIndex, toIndex));
        }
    }

    public static class ForLoadedType
    extends AbstractList<MethodDescription>
    implements MethodList {
        private final Method[] methods;
        private final Constructor<?>[] constructors;

        public ForLoadedType(Class<?> type) {
            this.methods = type.getDeclaredMethods();
            this.constructors = type.getDeclaredConstructors();
        }

        @Override
        public MethodDescription get(int index) {
            if (index < this.constructors.length) {
                return new MethodDescription.ForLoadedConstructor(this.constructors[index]);
            }
            return new MethodDescription.ForLoadedMethod(this.methods[index - this.constructors.length]);
        }

        @Override
        public int size() {
            return this.constructors.length + this.methods.length;
        }

        @Override
        public MethodList filter(MethodMatcher methodMatcher) {
            MethodDescription.AbstractMethodDescription methodDescription;
            ArrayList<MethodDescription.ForLoadedMethod> result = new ArrayList<MethodDescription.ForLoadedMethod>(this.size());
            for (Method method : this.methods) {
                methodDescription = new MethodDescription.ForLoadedMethod(method);
                if (!methodMatcher.matches(methodDescription)) continue;
                result.add((MethodDescription.ForLoadedMethod)methodDescription);
            }
            for (Executable executable : this.constructors) {
                methodDescription = new MethodDescription.ForLoadedConstructor((Constructor<?>)executable);
                if (!methodMatcher.matches(methodDescription)) continue;
                result.add((MethodDescription.ForLoadedMethod)methodDescription);
            }
            return new Explicit(result);
        }

        @Override
        public MethodDescription getOnly() {
            if (this.size() == 1) {
                return this.get(0);
            }
            throw new IllegalStateException("Expected to find exactly one method but found " + this.size() + " methods");
        }

        @Override
        public MethodList subList(int fromIndex, int toIndex) {
            return new Explicit(super.subList(fromIndex, toIndex));
        }
    }
}

