/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.instrumentation.method.bytecode.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.concurrent.Callable;
import net.bytebuddy.instrumentation.Instrumentation;
import net.bytebuddy.instrumentation.attribute.annotation.AnnotationDescription;
import net.bytebuddy.instrumentation.method.MethodDescription;
import net.bytebuddy.instrumentation.method.MethodList;
import net.bytebuddy.instrumentation.method.bytecode.bind.MethodDelegationBinder;
import net.bytebuddy.instrumentation.method.bytecode.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.instrumentation.method.bytecode.stack.assign.Assigner;
import net.bytebuddy.instrumentation.method.matcher.MethodMatchers;
import net.bytebuddy.instrumentation.type.TypeDescription;
import net.bytebuddy.instrumentation.type.auxiliary.MethodCallProxy;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface DefaultCall {
    public Class<?> targetType() default void.class;

    public boolean serializableProxy() default false;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<DefaultCall>
    {
        INSTANCE;

        private static final MethodDescription TARGET_TYPE;
        private static final MethodDescription SERIALIZABLE_PROXY;

        @Override
        public Class<DefaultCall> getHandledType() {
            return DefaultCall.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<DefaultCall> annotation, int targetParameterIndex, MethodDescription source, MethodDescription target, Instrumentation.Target instrumentationTarget, Assigner assigner) {
            TypeDescription targetType = (TypeDescription)target.getParameterTypes().get(targetParameterIndex);
            if (!(targetType.represents(Runnable.class) || targetType.represents(Callable.class) || targetType.represents(Object.class))) {
                throw new IllegalStateException("A default method call proxy can only be assigned to Runnable or Callable types: " + target);
            }
            TypeDescription typeDescription = annotation.getValue(TARGET_TYPE, TypeDescription.class);
            Instrumentation.SpecialMethodInvocation specialMethodInvocation = (typeDescription.represents(Void.TYPE) ? DefaultMethodLocator.Implicit.INSTANCE : new DefaultMethodLocator.Explicit(typeDescription)).resolve(instrumentationTarget, source);
            return specialMethodInvocation.isValid() ? new MethodDelegationBinder.ParameterBinding.Anonymous(new MethodCallProxy.AssignableSignatureCall(specialMethodInvocation, annotation.getValue(SERIALIZABLE_PROXY, Boolean.class))) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        static {
            MethodList annotationProperties = new TypeDescription.ForLoadedType(DefaultCall.class).getDeclaredMethods();
            TARGET_TYPE = annotationProperties.filter(MethodMatchers.named("targetType")).getOnly();
            SERIALIZABLE_PROXY = annotationProperties.filter(MethodMatchers.named("serializableProxy")).getOnly();
        }

        protected static interface DefaultMethodLocator {
            public Instrumentation.SpecialMethodInvocation resolve(Instrumentation.Target var1, MethodDescription var2);

            public static class Explicit
            implements DefaultMethodLocator {
                private final TypeDescription typeDescription;

                public Explicit(TypeDescription typeDescription) {
                    this.typeDescription = typeDescription;
                }

                @Override
                public Instrumentation.SpecialMethodInvocation resolve(Instrumentation.Target instrumentationTarget, MethodDescription source) {
                    if (!this.typeDescription.isInterface()) {
                        throw new IllegalStateException(source + " method carries default method call parameter on non-interface type");
                    }
                    return instrumentationTarget.invokeDefault(this.typeDescription, source.getUniqueSignature());
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.typeDescription.equals(((Explicit)other).typeDescription);
                }

                public int hashCode() {
                    return this.typeDescription.hashCode();
                }

                public String toString() {
                    return "DefaultCall.Binder.DefaultMethodLocator.Explicit{typeDescription=" + this.typeDescription + '}';
                }
            }

            public static enum Implicit implements DefaultMethodLocator
            {
                INSTANCE;


                @Override
                public Instrumentation.SpecialMethodInvocation resolve(Instrumentation.Target instrumentationTarget, MethodDescription source) {
                    String uniqueSignature = source.getUniqueSignature();
                    Instrumentation.SpecialMethodInvocation specialMethodInvocation = null;
                    for (TypeDescription candidate : instrumentationTarget.getTypeDescription().getInterfaces()) {
                        if (!source.isSpecializableFor(candidate)) continue;
                        if (specialMethodInvocation != null) {
                            return Instrumentation.SpecialMethodInvocation.Illegal.INSTANCE;
                        }
                        specialMethodInvocation = instrumentationTarget.invokeDefault(candidate, uniqueSignature);
                    }
                    return specialMethodInvocation != null ? specialMethodInvocation : Instrumentation.SpecialMethodInvocation.Illegal.INSTANCE;
                }
            }
        }
    }
}

